

/*************************************************************************
**************************************************************************

   Listing 3
   Copyright David Perelman-Hall & Jamshid Afshar 1994.
   VariableValue class

**************************************************************************
*************************************************************************/

#ifndef VARIABLE_H
#define VARIABLE_H

#include <cstring.h>    // BORLAND HEADER
#include "value.h"      // BASE VALUE CLASS


typedef string Variable;  // BORLAND

Variable gensym();

class VariableValue : public Value {
private:
   Variable _v;
public:
   //empty constructor
   VariableValue(){}

   //copy constructor
   VariableValue( const VariableValue& value ) : _v(value._v) { }

   VariableValue( const Variable& var ) : _v(var) { }

   Value* copy() const { return new VariableValue(*this); }

   const Variable& str() const { return _v; }

   //assignment operator
   void operator = (const VariableValue& value) { _v = value._v; }

   virtual bool operator == (const Value& value) const;
   virtual bool operator == (const VariableValue& value) const;

   virtual bool unify(const Value& value, SubstitutionList& subst, ValuePtr& result) const;
   virtual bool unify(const AtomicValue&, SubstitutionList&, ValuePtr& result) const;
   virtual bool unify(const VariableValue& var, SubstitutionList& subst, ValuePtr& result) const;
   virtual bool unify(const DagValue&, SubstitutionList&, ValuePtr& result) const;

   virtual void write(ostream& os, int level) const { os << _v; }
   virtual void read(istream& is) { is >> _v; }
   virtual ValuePtr substitute(const SubstitutionList& substList) const;
};

#endif
