/*  Project popclnt
    
  
    SUBSYSTEM:    popclnt.exe Application
    FILE:         tppmdicl.cpp
    AUTHOR:       Robert A. Duffy


    OVERVIEW
    ========
    Source file for implementation of TPopMDIClient (TMDIClient).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <dir.h>

#include "ppclntap.hpp"
#include "tppedtfl.hpp"
#include "tppmdich.hpp"
#include "tppmdicl.hpp"

// Helper input dialog classes

const int MAX_LINE = 255;

class ConnectInfo
{
public:
  string sHost;
  string sUser;
  string sPassword;
};

class TConnectDialog : public TDialog
{
public:
  TConnectDialog(ConnectInfo* pC, TWindow* pParent,TResId,TModule*);
protected:
  void SetupWindow();
  void CleanupWindow();
  ConnectInfo* pConnectionInfo;
  TEdit* pHostEdit;
  TEdit* pUserEdit;
  TEdit* pPasswordEdit;
};

TConnectDialog::TConnectDialog(ConnectInfo* pC, TWindow* pParent,TResId resID = DIALOG_CONNECT,TModule* pModule = 0)
               :TDialog(pParent,resID,pModule)
{
  pConnectionInfo = pC;
  pHostEdit = new TEdit(this,IDC_EDIT_HOST);
  pUserEdit = new TEdit(this,IDC_EDIT_USER);
  pPasswordEdit = new TEdit(this,IDC_EDIT_PASSWORD);
}

void TConnectDialog::SetupWindow()
{
  TDialog::SetupWindow();
  pHostEdit->Insert(pConnectionInfo->sHost.c_str());
  pUserEdit->Insert(pConnectionInfo->sUser.c_str());
  pPasswordEdit->Insert(pConnectionInfo->sPassword.c_str());
}

void TConnectDialog::CleanupWindow()
{
  char* pData = new char[MAX_LINE];
  pHostEdit->GetLine(pData,MAX_LINE,0);
  pConnectionInfo->sHost = pData;
  pUserEdit->GetLine(pData,MAX_LINE,0);
  pConnectionInfo->sUser = pData;
  pPasswordEdit->GetLine(pData,MAX_LINE,0);
  pConnectionInfo->sPassword = pData;
  delete []pData;
  TDialog::CleanupWindow(); 
}


//{{TPopMDIClient Implementation}}


//
// Build a response table for all messages/commands handled
// by TPopMDIClient derived from TMDIClient.
//
DEFINE_RESPONSE_TABLE1(TPopMDIClient, TMDIClient)
//{{TPopMDIClientRSP_TBL_BEGIN}}
	 EV_COMMAND(CM_MDIFILENEW, CmFileNew),
    EV_COMMAND(CM_MDIFILEOPEN, CmFileOpen),
	 EV_COMMAND(CM_MAILRETRIEVE, CmMailRetrieve),
//{{TPopMDIClientRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// TPopMDIClient
// ===========
// Construction/Destruction handling.
TPopMDIClient::TPopMDIClient (TModule* module)
              :TMDIClient(module),TPOPSocketCatch()
{
  pPOPSocket = new TAsyncPOPSocket(this,this);

	 // Change the window's background color
	 SetBkgndColor(RGB(0xc0, 0xc0, 0xc0));

    ChildCount = 0;

	 // INSERT>> Your constructor code here.

}


TPopMDIClient::~TPopMDIClient ()
{
  Destroy();

    // INSERT>> Your destructor code here.
  delete pPOPSocket;
}


//////////////////////////////////////////////////////////
// TPopMDIClient
// ===========
// MDIClient site initialization.
void TPopMDIClient::SetupWindow ()
{
    // Default SetUpWindow processing.
	 TMDIClient::SetupWindow ();

   TPopClientApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), TPopClientApp);

    // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
    // computed in the member functions CmFileOpen, and CmFileSaveAs.
	 theApp->FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	 theApp->FileData.SetFilter("All Files (*.*)|*.*|");

}

// CmMailRetrieve
// Retrieve mail using TAsyncPOPSocket class
//
// Basic steps:
// 1.  Obtain host, username, and password from user
// 2.  Construct a TAsyncPOPSocket and Init it
// 3.  If initialization of socket was ok, call RetrieveMail with info
// 4.    otherwise, report error condition
// 5.  For each mail message we are notified of, open as MDI child window
// 6.  Thats it
//
void TPopMDIClient::CmMailRetrieve()
{
  //assume the POP socket is valid
  ConnectInfo connInfo;
  if (TConnectDialog(&connInfo,this).Execute() == IDOK)
  {
    pPOPSocket->RetrieveMail(connInfo.sHost.c_str(),connInfo.sUser.c_str(),connInfo.sPassword.c_str());
  }
}

void TPopMDIClient::MessageCount(int nMessageCount)
{
  nPendingMessageCount = nMessageCount;
  if (nMessageCount == 0)
    MessageBox("No Mail","Message",MB_OK) ;
  else
  {
    char c[128];
    wsprintf(c,"Retrieving %d pieces of Mail",nMessageCount);
    TPopClientApp* theApp = TYPESAFE_DOWNCAST(GetApplication(), TPopClientApp);
    if (theApp)
      theApp->pStatusBar->SetText(c);
  }
}


void TPopMDIClient::MessageRetrieved(int /* nMessageID */, const char* pFilename)
{
  OpenFile(pFilename);  
}

void TPopMDIClient::WinSocketError(int nError, const char* /* pErrText */)
{
  char c[128];
  wsprintf(c,"Error code %d",nError);
  MessageBox(c,"POPSocket Error",MB_OK);
}

//////////////////////////////////////////////////////////
// TPopMDIClient
// ===========
// Menu File New command
void TPopMDIClient::CmFileNew ()
{
	 char    title[255];

	 // Generate a title for the MDI child window.
    wsprintf(title, "%d", ChildCount++);

    TPopMDIChild* child = new TPopMDIChild(*this, title, 0);

    // Associate ICON w/ this child window.
    child->SetIcon(GetApplication(), IDI_DOC);

	 // If the current active MDI child is maximize then this one should be also.
    TPopMDIChild *curChild = (TPopMDIChild *)GetActiveMDIChild();
    if (curChild && (curChild->GetWindowLong(GWL_STYLE) & WS_MAXIMIZE))
        child->Attr.Style |= WS_MAXIMIZE;

	 child->Create();
}


void TPopMDIClient::OpenFile (const char *fileName)
{
    TPopClientApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), TPopClientApp);

    if (fileName)
        strcpy(theApp->FileData.FileName, fileName);

    //
    // Create a MDIChild window whose client is TPopEditFile.
	 //
	 TPopMDIChild* child = new TPopMDIChild(*this, "", new TPopEditFile(0, 0, 0, 0, 0, 0, 0, theApp->FileData.FileName));

    // Associate ICON w/ this child window.
    child->SetIcon(GetApplication(), IDI_DOC);

	 // If the current active MDI child is maximize then this one should be also.
    TPopMDIChild *curChild = (TPopMDIChild *)GetActiveMDIChild();
    if (curChild && (curChild->GetWindowLong(GWL_STYLE) & WS_MAXIMIZE))
        child->Attr.Style |= WS_MAXIMIZE;

    child->Create();

    LoadTextFile();
}


//////////////////////////////////////////////////////////
// TPopMDIClient
// ===========
// Menu File Open command
void TPopMDIClient::CmFileOpen ()
{
    TPopClientApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), TPopClientApp);

    //
    // Display standard Open dialog box to select a file name.
    //
    *(theApp->FileData.FileName) = 0;
    if (TFileOpenDialog(this, theApp->FileData).Execute() == IDOK)
        OpenFile();
}


// Used by ListBox client to read a text file into the list box.
void TPopMDIClient::LoadTextFile ()
{
    char            buf[255+1];
	 ifstream        *inStream;

    TPopClientApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), TPopClientApp);

    TPopMDIChild  *curChild = (TPopMDIChild *)GetActiveMDIChild();
    TListBox        *client = TYPESAFE_DOWNCAST(curChild->GetClientWindow(), TListBox);

    // Only work if the client class is a TListBox.
    if (client) {
        client->ClearList();
        inStream = new ifstream(theApp->FileData.FileName);
        while (inStream->good()) {
            inStream->getline(buf, sizeof(buf) - 1);
            if (inStream->good())
                client->AddString(buf);
        }

        // Return an error message if we had a stream error and it wasn't the eof.
        if (inStream->bad() && !inStream->eof()) {
				string msgTemplate(*GetModule(), IDS_UNABLEREAD);
            char*  msg = new char[MAXPATH + msgTemplate.length()];
            wsprintf(msg, msgTemplate.c_str(), *(theApp->FileData.FileName));
            MessageBox(msg, GetApplication()->GetName(), MB_ICONEXCLAMATION | MB_OK);
            delete msg;
        }

        delete inStream;
    }
}


