/*  Project popclnt
    
    SUBSYSTEM:    popclnt.exe Application
    FILE:         ppclntap.cpp
    AUTHOR:       Robert A. Duffy


    OVERVIEW
    ========
    Source file for implementation of TPopClientApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "ppclntap.hpp"
#include "tppmdicl.hpp"
#include "tppclnad.hpp"                        // Definition of about dialog.       


//{{TPopClientApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(TPopClientApp, TApplication)
//{{TPopClientAppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{TPopClientAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// TPopClientApp
// =====
//
TPopClientApp::TPopClientApp () : TApplication("POP Client")
{

    // INSERT>> Your constructor code here.
}


TPopClientApp::~TPopClientApp ()
{
    // INSERT>> Your destructor code here.
}


void TPopClientApp::SetupSpeedBar (TDecoratedMDIFrame *frame)
{ 
    //
    // Create default toolbar New and associate toolbar buttons with commands.
    //   
    TControlBar* cb = new TControlBar(frame);
    cb->Insert(*new TButtonGadget(CM_MDIFILENEW, CM_MDIFILENEW));
    cb->Insert(*new TButtonGadget(CM_MDIFILEOPEN, CM_MDIFILEOPEN));
    cb->Insert(*new TButtonGadget(CM_FILESAVE, CM_FILESAVE));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_EDITCUT, CM_EDITCUT));
    cb->Insert(*new TButtonGadget(CM_EDITCOPY, CM_EDITCOPY));
    cb->Insert(*new TButtonGadget(CM_EDITPASTE, CM_EDITPASTE));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_EDITUNDO, CM_EDITUNDO));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_EDITFIND, CM_EDITFIND));
	 cb->Insert(*new TButtonGadget(CM_EDITFINDNEXT, CM_EDITFINDNEXT));
	 cb->Insert(*new TSeparatorGadget(6));
	 cb->Insert(*new TButtonGadget(CM_MAILRETRIEVE, CM_MAILRETRIEVE));
	 cb->Insert(*new TButtonGadget(CM_MAILSEND, CM_MAILSEND));

    // Add fly-over help hints.
    cb->SetHintMode(TGadgetWindow::EnterHints);

    frame->Insert(*cb, TDecoratedFrame::Top);
}


//////////////////////////////////////////////////////////
// TPopClientApp
// =====
// Application intialization.
//
void TPopClientApp::InitMainWindow ()
{
    if (nCmdShow != SW_HIDE)
        nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

	 mdiClient = new TPopMDIClient;
    TDecoratedMDIFrame* frame = new TDecoratedMDIFrame(Name, MDI_MENU, *mdiClient, true);

    // Set the client area to the application workspace color.
    frame->SetBkgndColor(::GetSysColor(COLOR_APPWORKSPACE));

    //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_MDIAPPLICATION);

    //
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(MDI_MENU);
    
    //
    // Associate with the accelerator table.
    //
    frame->Attr.AccelTable = MDI_MENU;

    SetupSpeedBar(frame);

    pStatusBar = new TStatusBar(frame, TGadget::Recessed,
                                    TStatusBar::CapsLock        |
                                    TStatusBar::NumLock         |
                                    TStatusBar::ScrollLock      |
                                    TStatusBar::Overtype);
    frame->Insert(*pStatusBar, TDecoratedFrame::Bottom);
  
    SetMainWindow(frame);

    frame->SetMenuDescr(TMenuDescr(MDI_MENU));
}


//////////////////////////////////////////////////////////
// TPopClientApp
// ===========
// Menu Help About popclnt.exe command
void TPopClientApp::CmHelpAbout ()
{
    //
    // Show the modal dialog.
    //
    TPopClientAboutDlg(MainWindow).Execute();
}
int OwlMain (int , char* [])
{
    try {
        TPopClientApp    app;
        return app.Run();
    }
    catch (xmsg& x) {
        ::MessageBox(0, x.why().c_str(), "Exception", MB_OK);
    }

    return -1;
}
