#include "misc.h"
#pragma hdrstop
#include <stdio.h>

Variable gensym()
{
   static unsigned i = 0;
   char sym[20];
   sprintf(sym, "_X%ud", i++);
   return Variable(sym);
}

bool VariableValue::unify(const Value& value, SubstitutionList& subst, ValuePtr& result) const
{ 
   if (!value.unify(*this, subst, result)) {
      if (!subst.set(_v, value)) 
         return FALSE;
      result = value;
   }
  return TRUE;
}

bool VariableValue::unify(const AtomicValue& value, SubstitutionList& subst, ValuePtr& result) const
{ 
   if( !subst.set(_v, value) )
      return FALSE;
  result = value; 
  return TRUE;
}

bool VariableValue::unify(const VariableValue& var, SubstitutionList& subst, ValuePtr& result) const
{ 
   if( !subst.set_identical(_v, var.str()) ) {
      //cerr << "unify vars (" << *this << "," << var << ")\n"; //##
      return FALSE;
   }
   result = var; 
   return TRUE;
}

bool VariableValue::unify(const DagValue& value, SubstitutionList& subst, ValuePtr& result) const
{
   if( !subst.set(_v, value) )
      return FALSE;
   result = value; 
   return TRUE; 
}

ValuePtr VariableValue::substitute(const SubstitutionList& substList) const
{ 
   if( substList.contains(_v) )
      return substList.val(_v);
   else
      return VariableValue(_v);
}

bool VariableValue::operator == (const Value& value) const
{ return value==*this; }
bool VariableValue::operator == (const VariableValue& /*value*/) const
{ return TRUE;/*## _v == value._v;*/ }

