
/*************************************************************************
**************************************************************************

   Listing 5, SUBST.H
   Copyright David Perelman-Hall & Jamshsid Afshar 1994.
   SubstitutionList class header file definition.
   Defines class and methods for tracking instantiations of variables
   during unification.

**************************************************************************
*************************************************************************/


#ifndef SUBST_H
#define SUBST_H

#include "misc.h"
#pragma hdrstop


typedef SetOf</*Variable*/String> VariableSet;

class SubstitutionList : private MapOf</*Variable*/String, ValuePtr> {
public:
   //empty constructor
   SubstitutionList() : MapOf</*Variable*/String, ValuePtr>() {}

   //copy constructor
   SubstitutionList( const SubstitutionList& subst ) 
      : MapOf</*Variable*/String, ValuePtr>(subst) {}

//   void add(const /*Variable*/String& variable, const ValuePtr& valueptr);

   bool set(const /*Variable*/String& variable, const ValuePtr& valueptr);

   bool set_identical(const /*Variable*/String& var1, const /*Variable*/String& var2);

   bool contains(const /*Variable*/String& var) const;

   ValuePtr val(const /*Variable*/String& var) const;

   VariableSet same(const /*Variable*/String& var) const;
   // returns set of variables which were set_identical to "var"

   int empty() const {
      return MapOf</*Variable*/String, ValuePtr>::empty()
               && _var_eqs.empty();
      }
protected:
   ListOf< VariableSet > _var_eqs;
private:
   friend ostream& operator<<(ostream& os, const SubstitutionList& subst);
};

ostream& operator<<(ostream& os, const SubstitutionList& subst);


#endif
