

/*************************************************************************
**************************************************************************

   Listing 6
   Copyright David Perelman-Hall & Jamshid Afshar 1994.
   Base Value class and ValuePtr class.

**************************************************************************
*************************************************************************/



#ifndef VALUE_H
#define VALUE_H

#include "misc.h"    // GATHERED INCLUDES.  HELPS WITH PRE-COMPILED HEADERS.

// Forward References
class SubstitutionList;
class Value;

// Pointer (or Reference) class to a Value
class ValuePtr {
friend ostream& operator << (ostream& os, const ValuePtr& vp);
private:
   Value* _ptr;
public:
   ValuePtr();
   ValuePtr(const ValuePtr& vp);
   ValuePtr(const Value& v);
   ~ValuePtr();
   void operator=(const ValuePtr& vp);
   bool operator==(const ValuePtr& vp) const;
   bool operator!=(const ValuePtr& vp) const;
   const Value* operator->() const;
   const Value& operator*() const;
   operator const void*() const { return _ptr; }
};


// FORWARD REFERENCES TO CLASSES DERIVING FROM VALUE
class AtomicValue;
class VariableValue;
class DagValue;

class Value {
   public:
      //void CTOR
      Value() {}

      virtual Value* copy() const = 0;
      virtual void write(ostream& os, int level=0) const = 0;

      virtual bool operator == (const Value& value) const = 0;
      virtual bool operator == (const AtomicValue&) const { return FALSE; }
      virtual bool operator == (const VariableValue&) const { return FALSE; }
      virtual bool operator == (const DagValue&) const { return FALSE; }

      virtual bool unify(const Value& value, SubstitutionList&, ValuePtr&) const = 0;
      virtual bool unify(const AtomicValue&, SubstitutionList&, ValuePtr&) const;
      virtual bool unify(const VariableValue&, SubstitutionList&, ValuePtr&) const;
      virtual bool unify(const DagValue&, SubstitutionList&, ValuePtr&) const;

      virtual ValuePtr substitute(const SubstitutionList& substList) const = 0;
};

inline
ostream& operator << (ostream& os, const Value& v)
{
   v.write(os);
   return os;
}


inline ValuePtr::ValuePtr() : _ptr(0) { }
inline ValuePtr::ValuePtr(const ValuePtr& vp) : _ptr(vp._ptr->copy()) { }
inline ValuePtr::ValuePtr(const Value& v) : _ptr(v.copy()) { }
inline ValuePtr::~ValuePtr() { delete _ptr; _ptr=0; }

inline void ValuePtr::operator=(const ValuePtr& vp){
   if(_ptr!=0)
      delete _ptr; 
   if(vp._ptr != 0)
      _ptr = vp._ptr->copy();
   else
      _ptr = 0;
}

inline bool ValuePtr::operator==(const ValuePtr& vp) const
   { return (*_ptr) == *(vp._ptr); }

inline bool ValuePtr::operator!=(const ValuePtr& vp) const
   { return !( *this == vp ); }

inline const Value* ValuePtr::operator->() const { assert(_ptr != 0); return _ptr; }
inline const Value& ValuePtr::operator*() const { assert(_ptr != 0); return *_ptr; }

inline ostream& operator << (ostream& os, const ValuePtr& vp)
{
   assert(vp._ptr != 0);
   os << *(vp._ptr);
   return os;
}

#endif
