#include "misc.h"
#pragma hdrstop


// DAG SPECIFIC OSTREAM OPERATOR
ostream& operator << ( ostream& os, const Dag& dag )
{
   dag.write(os, 0);
   return os;
}

// DAG SPECIFIC OUTPUT OPERATOR
void Dag::write(ostream& os, int level) const
{
   os << "[";
   for (FVListIter i(&fvlist()); !i.offEnd(); i.next()) {
      os << i.key() << " : ";
      i.value()->write(os, level+1);
      if (!i.last()) {
               os << "\n";
               for (int i=0; i<level; i++)
                  os << "   ";
               os << " ";
         os << " | ";
         }
      }
   os << "]";
}

// RETRIEVE THE LIST OF FEATURES OF THIS DAG
FeatureSet Dag::list_features() const 
{
   // CREATE A SET OF KEYS TO RETURN
   FeatureSet tmp_features(fvlist().keys(),fvlist().size());

   // RETURN IT
   return tmp_features;
}


// EQUALITY OPERATOR
bool Dag::operator==(const Dag& d) const
{
   // TYPEDEF AN ITERATOR OVER A MAP FROM FEATURES TO VALUE POINTERS
   typedef MapOfIter<Feature, ValuePtr> FVIter;

   // STEP SIUMULTANEOUSLY THROUGH LIST OF FEATURES IN BOTH THIS AND PASSED-IN DAG
   for (FVIter fv1(&this->fvlist()), fv2(&d.fvlist()); !fv1.offEnd() && !fv2.offEnd(); fv1.next(), fv2.next()){

      // IF EITHER CURRENT FEATURES OR CURRENT VALUES DON'T MATCH, RETURN FALSE
      if (fv1.key()!=fv2.key() || fv1.value()!=fv2.value())
         return FALSE;
   }
   // RETURN TRUE IF STEPPED ENTIRELY THROUGH BOTH LISTS, ELSE RETURN FALSE
   return fv1.offEnd() && fv2.offEnd();
}

// SUBSTITUTE
Dag Dag::substitute(const SubstitutionList& substList) const
{
   // RETURN DAG
   Dag tmpDag;

   // LIST OF FEATURES IN THIS DAG
   FeatureSet features=list_features();

   // STEP THROUGH LIST OF FEATURES FROM THIS DAG
   for (SetOfIter<Feature> feature(&features); feature; ++feature)

      // ADD TO RETURN DAG THE FEATURE AND ANY VALUE LISTED FOR IT IN THE
      // SUBSTITUTION LIST, AS FOLLOWS:
      // 1) IF THERE IS A SUBSTITUTION FOR IT AND THE VALUE IS A
      //    VARIABLE, ADD WHATEVER EXISTS IN THE SUBSTITUTION LIST
      //    FOR THAT VARIABLE,
      // 2) IF THERE IS NO SUBSTITUTION FOR IT AND THE VALUE IS A
      //    VARIABLE, ADD THE VARIABLE,
      tmpDag.add(feature(),value(feature())->substitute(substList));

   // RETURN THE CREATED DAG
   return tmpDag;
}



// OUTPUT OPERATOR FOR A DAGVALUE
void DagValue::write(ostream& os, int level) const
{
   _d.write(os, level);
}

bool DagValue::unify(const DagValue& value, SubstitutionList& subst, ValuePtr& result) const
{
   Dag unification;
   // CALL GLOBAL FUNCTION, PASSING 2 DAGs
   if (::unify(_d, value._d, subst, unification)) {
      result = DagValue(unification);
      return TRUE;
   }
   else {
      return FALSE;
   }
}

ValuePtr DagValue::substitute(const SubstitutionList& substList) const
{ return DagValue(_d.substitute(substList)); }


// GLOBAL UNIFY FUNCTION
bool unify(const Dag& dag1, const Dag& dag2, SubstitutionList& subst, Dag& result)
{
   // GET SET OF ALL FEATURES FROM BOTH DGAS
   FeatureSet features = dag1.list_features() + dag2.list_features();

   {
   for (SetOfIter<Feature> feature(&features); feature; ++feature) {
      // TRY TO UNIFY VALUES WHERE FEATURE IS COMMON TO BOTH DAGS
      if (dag1.contains(feature()) && dag2.contains(feature())) {
         // cout << "Attempting to unify feature " << feature() << " in both dags." << endl;
         ValuePtr unified_value; // TO HOLD THE RESULT OF SUCCESSFUL UNIFICATION

         // CALL VALUE::UNIFY THROUGH VALUEPTR WRAPPER, BUILDING UP SUBSTITUTION 
         // LIST & RESULTING DAG
         if (dag1.value(feature())->unify(*(dag2.value(feature())), subst, unified_value)) {
            result.add(feature(), unified_value);
         }
         else { // FAILED TO UNIFY VALUES FOR FEATURE COMMON TO BOTH DAGS
            cout << dag1.value(feature()) << " and " << dag2.value(feature()) << " did not unify." << endl;
            return FALSE;
            }
      }
      else { // ADD FEATURE-VALUE WHERE EXISTS IN ONE DAG ONLY
         if(dag1.contains(feature()))
            result.add(feature(), dag1.value(feature()));
         else
            result.add(feature(), dag2.value(feature()));
      }
   }
   }

   Dag result_with_subst;
   {
   // DO VARIABLE SUBSTITUTIONS BUILT UP IN PREVIOUS LOOP
   for (SetOfIter<Feature> feature(&features); feature; ++feature) {
      result_with_subst.add(feature(), result.value(feature())->substitute(subst));
   }
   }

   result = result_with_subst;
   return TRUE;
}
