#include "misc.h"
#pragma hdrstop

//PROTOTYPED FOR BASE CLASS
bool AtomicValue::operator == (const Value& value) const
   { return value==*this; }

//PROTOTYPED FOR ATOMIC VALUE
bool AtomicValue::operator == (const AtomicValue& value) const
   { return (Atomic&)*this == (Atomic&)value; }

//PROTOTYPED FOR BASE CLASS
bool AtomicValue::unify(const Value& value, SubstitutionList& subst, ValuePtr& result) const
      { return value.unify(*this, subst, result); }

//PROTOTYPED FOR ATOMIC VALUE
bool AtomicValue::unify(const AtomicValue& value, SubstitutionList& /*subst*/, ValuePtr& result) const
{ 
   if (value == *this) {
      result = *this;
      return TRUE; 
   }
   else {
      return FALSE; 
   }
}

