UNIT RcAccel;

INTERFACE

USES RcTypes;

PROCEDURE ParseAccel;
PROCEDURE ParseHelpTable;
PROCEDURE ParseHelpSubTable;
PROCEDURE Write_res_Accels;
PROCEDURE Write_Accels;
PROCEDURE Write_res_HelpTables;
PROCEDURE Write_HelpTables;
PROCEDURE Write_res_HelpSubTables;
PROCEDURE Write_HelpSubTables;

VAR
   TempAccel:PAccel;
   TemphelpTable:PHelptable;
   TempHelpSubTable:PHelpTable;

CONST
     AccelCount:WORD=0;
     HelptableCount:WORD=0;
     HelpSubTableCount:WORD=0;

IMPLEMENTATION

PROCEDURE Write_Res_Accels;
VAR a,a1:PAccel;
BEGIN
     a:=Accelerators;
     WHILE a<>NIL DO
     BEGIN
          WriteWord(a^.SubCount);
          WriteWord($0352);
          a1:=a^.entries;
          WHILE a1<>NIL DO
          BEGIN
               WriteWord(a1^.Flag);
               WriteWord(a1^.name);
               WriteWord(a1^.ident);
               a1:=a1^.Next;
          END;
          a:=a^.next;
     END;
END;

PROCEDURE Write_Res_HelpTables;
VAR h,h1:PHelpTable;
    hi:PHelptableEntry;
BEGIN
     h:=Helptables;
     WHILE h<>NIL DO
     BEGIN
          hi:=h^.Entries;
          WHILE hi<>NIL do
          BEGIN
               Writeword(hi^.i1);
               WriteWord(hi^.i2);
               WriteWord($ffff);
               WriteWord(hi^.i3);
               hi:=hi^.next;
          END;
          WriteWord(0);
          h:=h^.next;
     END;
END;

PROCEDURE Write_Res_HelpSubTables;
VAR h,h1:PHelpTable;
    hi:PHelptableEntry;
BEGIN
     h:=HelpSubtables;
     WHILE h<>NIL DO
     BEGIN
          WriteWord(2);
          hi:=h^.Entries;
          WHILE hi<>NIL do
          BEGIN
               Writeword(hi^.i1);
               WriteWord(hi^.i2);
               hi:=hi^.next;
          END;
          WriteWord(0);
          h:=h^.next;
     END;
END;


PROCEDURE Write_Accels;
VAR a:pAccel;
BEGIN
     AccelOffset:=DialogOffset;
     {Nun die Bezeichner der Acceleratortables}
     a:=Accelerators;
     while a<>NIL do
     begin
          WriteWord(8);                     {Typ:Accelerator}
          writeword(a^.ident);              {Bezeichner des Accelerators}
          writeword(a^.subsize AND 65535);  {Lnge der Eintrge fr diese Tabelle}
          writeword(a^.subsize SHR 16);
          writeWord(3);                     {Object number}
          writeWord(AccelOffset AND 65535);  {Relativer Resourcenoffset}
          writeWord(AccelOffset SHR 16);
          inc(AccelOffset,a^.SubSize);
          a:=a^.next;
     end;
END;

PROCEDURE Write_HelpTables;
VAR h:pHelptable;
BEGIN
     HelpTableOffset:=AccelOffset;
     {Nun die Bezeichner der Acceleratortables}
     h:=HelpTables;
     while h<>NIL do
     begin
          WriteWord($12);                     {Typ:helptable}
          writeword(h^.ident);              {Bezeichner der Helptable}
          writeword(h^.subsize AND 65535);  {Lnge der Eintrge fr diese Tabelle}
          writeword(h^.subsize SHR 16);
          writeWord(3);                     {Object number}
          writeWord(HelptableOffset AND 65535);  {Relativer Resourcenoffset}
          writeWord(HelpTableOffset SHR 16);
          inc(HelptableOffset,h^.SubSize);
          h:=h^.next;
     end;
END;

PROCEDURE Write_HelpSubTables;
VAR h:pHelptable;
BEGIN
     HelpSubTableOffset:=HelpTableOffset;
     {Nun die Bezeichner der HilfeSubTabellen}
     h:=helpSubTables;
     while h<>NIL do
     begin
          WriteWord($13);                   {Typ:HelpSubTable}
          writeword(h^.ident);              {Bezeichner der HelpSubTable}
          writeword(h^.subsize AND 65535);  {Lnge der Eintrge fr diese Tabelle}
          writeword(h^.subsize SHR 16);
          writeWord(3);                     {Object number}
          writeWord(HelpSubTableOffset AND 65535);  {Relativer Resourcenoffset}
          writeWord(HelpSubTableOffset SHR 16);
          inc(HelpSubTableOffset,h^.SubSize);
          h:=h^.next;
     end;
END;

PROCEDURE NewAccel(VAR a,a1:PAccel);
Var spos:Byte;
BEGIN
     IF a=NIL THEN
     BEGIN
          New(a);
          a1:=a;
     END
     ELSE
     BEGIN
          a1:=a;
          while a1^.next<>NIL do a1:=a1^.next;
          new(a1^.next);
          a1:=a1^.next;
     END;
     a1^.SubCount:=0;
     a1^.SubSize:=0;
     a1^.Flag:=0;
     a1^.Next:=NIL;
     a1^.Entries:=NIL;
END;

PROCEDURE NewHelpTable(VAR h,h1:PHelpTable);
Var spos:Byte;
BEGIN
     IF h=NIL THEN
     BEGIN
          New(h);
          h1:=h;
     END
     ELSE
     BEGIN
          h1:=h;
          while h1^.next<>NIL do h1:=h1^.next;
          new(h1^.next);
          h1:=h1^.next;
     END;
     h1^.Entries:=NIL;
     h1^.Next:=NIL;
END;

PROCEDURE NewHelpEntry(VAR h:PHelpTable;VAR h1:PHelpTableEntry);
Var spos:Byte;
BEGIN
     IF h^.Entries=NIL THEN
     BEGIN
          New(h^.Entries);
          h1:=h^.Entries;
     END
     ELSE
     BEGIN
          h1:=h^.Entries;
          while h1^.next<>NIL do h1:=h1^.next;
          new(h1^.next);
          h1:=h1^.next;
     END;
     h1^.Next:=NIL;
END;


CONST AccelOpt:ARRAY[1..9] OF TStyle=(
       (Name:'CHAR';Style:$0001),
       (Name:'VIRTUALKEY';Style:$0002),
       (Name:'SCANCODE';Style:$0004),
       (Name:'SHIFT';Style:$0008),
       (Name:'CONTROL';Style:$0010),
       (Name:'ALT';Style:$0020),
       (Name:'LONEKEY';Style:$0040),
       (Name:'SYSCOMMAND';Style:$0100),
       (Name:'HELP';Style:$0200)
       );

CONST VirtualKeys:ARRAY[1..59] OF TStyle=(
      (Name:'VK_BUTTON1';Style:$01),
      (Name:'VK_BUTTON2';Style:$02),
      (Name:'VK_BUTTON3';Style:$03),
      (Name:'VK_BREAK';Style:$04),
      (Name:'VK_BACKSPACE';Style:$05),
      (Name:'VK_TAB';Style:$06),
      (Name:'VK_BACKTAB';Style:$07),
      (Name:'VK_NEWLINE';Style:$08),
      (Name:'VK_SHIFT';Style:$09),
      (Name:'VK_CTRL';Style:$0A),
      (Name:'VK_ALT';Style:$0B),
      (Name:'VK_ALTGRAF';Style:$0C),
      (Name:'VK_PAUSE';Style:$0D),
      (Name:'VK_CAPSLOCK';Style:$0E),
      (Name:'VK_ESC';Style:$0F),
      (Name:'VK_SPACE';Style:$10),
      (Name:'VK_PAGEUP';Style:$11),
      (Name:'VK_PAGEDOWN';Style:$12),
      (Name:'VK_END';Style:$13),
      (Name:'VK_HOME';Style:$14),
      (Name:'VK_LEFT';Style:$15),
      (Name:'VK_UP';Style:$16),
      (Name:'VK_RIGHT';Style:$17),
      (Name:'VK_DOWN';Style:$18),
      (Name:'VK_PRINTSCRN';Style:$19),
      (Name:'VK_INSERT';Style:$1A),
      (Name:'VK_DELETE';Style:$1B),
      (Name:'VK_SCRLLOCK';Style:$1C),
      (Name:'VK_NUMLOCK';Style:$1D),
      (Name:'VK_ENTER';Style:$1E),
      (Name:'VK_SYSRQ';Style:$1F),
      (Name:'VK_F1';Style:$20),
      (Name:'VK_F2';Style:$21),
      (Name:'VK_F3';Style:$22),
      (Name:'VK_F4';Style:$23),
      (Name:'VK_F5';Style:$24),
      (Name:'VK_F6';Style:$25),
      (Name:'VK_F7';Style:$26),
      (Name:'VK_F8';Style:$27),
      (Name:'VK_F9';Style:$28),
      (Name:'VK_F10';Style:$29),
      (Name:'VK_F11';Style:$2A),
      (Name:'VK_F12';Style:$2B),
      (Name:'VK_F13';Style:$2C),
      (Name:'VK_F14';Style:$2D),
      (Name:'VK_F15';Style:$2E),
      (Name:'VK_F16';Style:$2F),
      (Name:'VK_F17';Style:$30),
      (Name:'VK_F18';Style:$31),
      (Name:'VK_F19';Style:$32),
      (Name:'VK_F20';Style:$33),
      (Name:'VK_F21';Style:$34),
      (Name:'VK_F22';Style:$35),
      (Name:'VK_F23';Style:$36),
      (Name:'VK_F24';Style:$37),
      (Name:'VK_ENDDRAG';Style:$38),
      (Name:'VK_CLEAR';Style:$39),
      (Name:'VK_EREOF';Style:$3A),
      (Name:'VK_PA1';Style:$3B)
      );

PROCEDURE Read_Options(VAR flags:WORD);
VAR s,Temp:STRING;
    t:BYTE;
Label l;
BEGIN
l:
     SplitLine(Params,Temp,'|');
     FOR t:=1 TO length(Temp) DO Temp[t]:=upcase(temp[t]);
     FOR t:=1 TO 9 DO
     BEGIN
          IF AccelOpt[t].Name=temp THEN
          BEGIN
               Flags:=Flags or Accelopt[t].Style;
               IF params<>'' THEN goto l;
               exit;
          END;
     END;
     Error('Illegal Accelerator flag:'+temp);
END;

PROCEDURE ParseAccel;
VAR a,a1:PAccel;
    i:WORD;
    i1:LONGINT;
    c:Integer;
    s:string;
Label l,l1;
BEGIN
     INC(AccelCount);
     val(params,i,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(params,i1) THEN
            error('Illegal numeric format');
          i:=i1;
     END;
     params:='';
     NewAccel(Accelerators,a);
     a^.ident:=i;
     Read_Line;
     IF commanditem<>__BEGIN THEN Error('BEGIN expected');
     Read_Line;
     REPEAT
           params:=command;
           SplitLine(Params,s,',');
           IF s[1]<>'"' THEN
           BEGIN
                val(s,i,c);
                IF c<>0 THEN
                BEGIN
                     FOR c:=1 TO 59 DO IF s=virtualkeys[c].name THEN goto l1;
                     Error('Illegal constant:'+s);
l1:
                     i:=virtualkeys[c].Style;
                END;
                IF i>255 THEN Error('Range check');
                IF i<0 THEN Error('Range check');
                NewAccel(a^.Entries,a1);
                inc(a^.SubCount);
                a1^.name:=i;
                goto l;
           END;
           IF s[3]<>'"' THEN Error('Char expected');
           delete(s,1,1);
           dec(s[0]);
           IF length(s)<>1 THEN Error('Char expected');
           NewAccel(a^.Entries,a1);
           inc(a^.SubCount);
           a1^.name:=ord(s[1]);
l:
           a1^.Flag:=0;
           SplitLine(params,s,',');
           val(s,i,c);
           if c<>0 then
           BEGIN
                IF not SearchConstant(s,i1) THEN
                  error('Illegal numeric format');
                i:=i1;
           END;
           a1^.ident:=i;
           Read_Options(a1^.flag);
           Read_Line;
     UNTIL commanditem=__END;
     a^.Subsize:=4+6*a^.subcount;
END;

PROCEDURE ParseHelpTable;
VAR h,h1:PHelpTable;
    i:WORD;
    i1:LONGINT;
    c:Integer;
    s:string;
    count:WORD;
    w1,w2,w3:WORD;
    hi:PHelpTableEntry;
Label l,l1;
BEGIN
     INC(HelpTableCount);
     val(params,i,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(params,i1) THEN
            error('Illegal numeric format');
          i:=i1;
     END;
     params:='';
     NewHelpTable(HelpTables,h);
     h^.ident:=i;
     Read_Line;
     IF commanditem<>__BEGIN THEN Error('BEGIN expected');
     count:=0;
     Read_Line;
     REPEAT
           IF commanditem<>__HELPITEM THEN Error('HELPITEM expected');
           inc(count);

           SplitLine(params,s,',');
           val(s,i,c);
           if c<>0 then
           BEGIN
                IF not SearchConstant(s,i1) THEN
                  error('Illegal numeric format');
                i:=i1;
           END;
           w1:=i;

           SplitLine(params,s,',');
           val(s,i,c);
           if c<>0 then
           BEGIN
                IF not SearchConstant(s,i1) THEN
                  error('Illegal numeric format');
                i:=i1;
           END;
           w2:=i;

           SplitLine(params,s,',');
           val(s,i,c);
           if c<>0 then
           BEGIN
                IF not SearchConstant(s,i1) THEN
                  error('Illegal numeric format');
                i:=i1;
           END;
           w3:=i;

           NewHelpEntry(h,hi);
           hi^.i1:=w1;
           hi^.i2:=w2;
           hi^.i3:=w3;
           Read_Line;
     UNTIL commanditem=__END;
     h^.Subsize:=(count*8)+2;
END;


PROCEDURE ParseHelpSubTable;
VAR h,h1:PHelpTable;
    i:WORD;
    i1:LONGINT;
    c:Integer;
    s:string;
    count:WORD;
    w1,w2,w3:WORD;
    hi:PHelpTableEntry;
Label l,l1;
BEGIN
     INC(HelpSubTableCount);
     val(params,i,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(params,i1) THEN
            error('Illegal numeric format');
          i:=i1;
     END;
     params:='';
     NewHelpTable(HelpSubTables,h);
     h^.ident:=i;
     Read_Line;
     IF commanditem<>__BEGIN THEN Error('BEGIN expected');
     count:=0;
     Read_Line;
     REPEAT
           IF commanditem<>__HELPSUBITEM THEN Error('HELPSUBITEM expected');
           inc(count);

           SplitLine(params,s,',');
           val(s,i,c);
           if c<>0 then
           BEGIN
                IF not SearchConstant(s,i1) THEN
                  error('Illegal numeric format');
                i:=i1;
           END;
           w1:=i;

           SplitLine(params,s,',');
           val(s,i,c);
           if c<>0 then
           BEGIN
                IF not SearchConstant(s,i1) THEN
                  error('Illegal numeric format');
                i:=i1;
           END;
           w2:=i;

           NewHelpEntry(h,hi);
           hi^.i1:=w1;
           hi^.i2:=w2;
           Read_Line;
     UNTIL commanditem=__END;
     h^.Subsize:=(count*4)+4;
END;


BEGIN
END.