UNIT RcIcon;

INTERFACE

USES RcTypes;

VAR
   TempIcon:PIcon;

CONST
     IconCount:Word=0;
     BitmapCount:WORD=0;

PROCEDURE ParseIcon;
PROCEDURE Parsebitmap;
PROCEDURE Write_res_Icons(i:PIcon);
PROCEDURE Write_Icons;
PROCEDURE Write_Bitmaps;

IMPLEMENTATION

PROCEDURE NewIcon(VAR i,i1:PIcon;num:Word);
Var spos:Byte;
    f:file;
    l:longint;
BEGIN
     IF i=NIL THEN
     BEGIN
          New(i);
          i1:=i;
     END
     ELSE
     BEGIN
          i1:=i;
          while i1^.next<>NIL do i1:=i1^.next;
          new(i1^.next);
          i1:=i1^.next;
     END;
     i1^.IconName:=params;
     i1^.ident:=Num;
     assign(f,i1^.IconName);
     reset(f,1);
     if ioresult<>0 then error('Icon/Bitmap not found:'+i1^.Iconname);
     l:=filesize(f);
     i1^.SubSize:=l;  {Independent color form format 1.2 recommended}
     close(f);
     if ioresult<>0 then error('File read error:'+i1^.Iconname);
     i1^.Next:=NIL;
END;

PROCEDURE ParseIcon;
VAR i:PICON;
    n:word;
    s:string;
    c:Integer;
    i1:LONGINT;
BEGIN
     INC(IconCount);
     SplitLine(params,s,' ');
     val(s,n,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(s,i1) THEN
            error('Illegal numeric format');
          n:=i1;
     END;
     NewIcon(Icons,i,n);
END;

PROCEDURE Parsebitmap;
VAR i:PICON;
    n:word;
    s:string;
    c:Integer;
    i1:LONGINT;
BEGIN
     INC(BitmapCount);
     SplitLine(params,s,' ');
     val(s,n,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(s,i1) THEN
            error('Illegal numeric format');
          n:=i1;
     END;
     NewIcon(Bitmaps,i,n);
END;

PROCEDURE Write_Icons;
VAR w:Word;
    i:PIcon;
BEGIN
     IconOffset:=BitMapOffset;

     {Nun die Bezeichner der Icons}
     i:=Icons;
     while i<>NIL do
     begin
          WriteWord(1);          {Typ:Icon or mouseshape}
          writeword(i^.ident);   {Bezeichner des Menus}
          writeword(i^.subsize MOD 65536); {Lnge der Eintrge fr dieses Menu}
          writeword(i^.subsize DIV 65536);
          writeWord(3);  {Object number}
          writeWord(IconOffset MOD 65536);
          writeWord(IconOffset DIV 65536);
          inc(IconOffset,i^.SubSize);
          i:=i^.next;
     end;
END;

PROCEDURE Write_Bitmaps;
VAR w:Word;
    i:PIcon;
BEGIN
     BitmapOffset:=0;

     {Nun die Bezeichner der Bitmaps}
     i:=Bitmaps;
     while i<>NIL do
     begin
          WriteWord(2);          {Typ:Bitmap}
          writeword(i^.ident);   {Bezeichner der Bitmap}
          writeword(i^.subsize MOD 65536); {Lnge der Eintrge fr diese Bitmap}
          writeword(i^.subsize DIV 65536);
          writeWord(3);  {Object number}
          writeWord(BitmapOffset MOD 65536);
          writeWord(BitmapOffset DIV 65536);
          inc(BitmapOffset,i^.SubSize);
          i:=i^.next;
     end;
END;

PROCEDURE Write_res_Icons(i:PIcon);
var
    w:word;
    t:word;
    f:file;
    p:^Byte;
BEGIN
     if i=NIL then exit;
     while i<>NIL do
     begin
          assign(f,i^.IconName);
          reset(f,1);
          if ioresult<>0 then error('File not found:'+i^.IconName);

          Getmem(p,i^.SubSize);
          blockread(f,p^,i^.SubSize);
          if ioresult<>0 then
          begin
               close(f);
               error('Disk read error');
          end;
          blockwrite(zielf,p^,i^.Subsize);
          if ioresult<>0 then
          begin
               close(f);
               error('File write error');
          end;
          {WriteWord(0);}
          close(f);
          if ioresult<>0 then error('Disk read error');
          i:=i^.next;
     END;
END;

BEGIN
END.