PROGRAM PmMenus;

{***************************************************************************
*                                                                          *
*                Speed-Pascal/2 Sample program "PMMenus"                   *
*                                                                          *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.              *
*                                                                          *
*                                                                          *
*  This program illustrates how to use Menus with Object-PM                *
*                                                                          *
*                                                                          *
****************************************************************************}



USES PmObject,Crt;  {bind Units used}

RESOURCE PMMenus;     {bind External resources}

{define Menu commands}
CONST
     CM_ITEM1=500;
     CM_ITEM2=501;
     CM_ITEM3=502;
     CM_ITEM4=503;
     CM_SUBITEM1=504;
     CM_SUBITEM2=505;
     CM_SUBITEM3=506;
     CM_BITMAP1=507;
     CM_BITMAP2=508;
     CM_CHECKED=509;
     CM_HIGHLIGHTED=510;
     CM_DISABLED=511;


TYPE TMyApplication=OBJECT(TApplication)
                         CONSTRUCTOR Init;
                         DESTRUCTOR Done;
                         FUNCTION HandleEvent(Win:HWND;Msg:ULONG;
                                              Para1,Para2:POINTER;
                                              VAR Handled:BOOLEAN):
                                              ULONG:VIRTUAL;
                    END;

VAR
   MyApp:TMyApplication;


{Implementation of the methods}

CONSTRUCTOR TMyApplication.Init;
BEGIN
     Inherited.Init;  {Eltern aufrufen}
     InsertResources(TRUE,FALSE,TRUE); {Application has menu and icon}
END;

DESTRUCTOR TMyApplication.Done;
BEGIN
END;


{Virtual Method HandleEvent. All messages come here first}
FUNCTION TMyApplication.HandleEvent(Win:HWND;Msg:ULONG;Para1,Para2:POINTER;
                                    VAR Handled:BOOLEAN):ULONG;
VAR r:LONGWORD;
    H:BOOLEAN;
    Command:WORD;
BEGIN
     H:=TRUE;
     r:=Inherited.HandleEvent(Win,Msg,Para1,Para2,Handled);
     CASE Msg OF
         WM_COMMAND:
         BEGIN
              Command:=WORD(Para1);
              CASE Command OF
                 CM_ITEM1:Messagebox('Item1 selected');
                 CM_ITEM2:Messagebox('Item2 selected');
                 CM_ITEM3:Messagebox('Item3 selected');
                 CM_ITEM4:Messagebox('Item4 selected');
                 CM_SUBITEM1:Messagebox('SubItem1 selected');
                 CM_SUBITEM2:Messagebox('SubItem2 selected');
                 CM_SUBITEM3:Messagebox('SubItem3 selected');
                 CM_BITMAP1:Messagebox('Bitmap1 selected');
                 CM_BITMAP2:Messagebox('Bitmap2 selected');
                 CM_CHECKED:Messagebox('Checked item selected');
                 CM_HIGHLIGHTED:Messagebox('Hilited item selected');
                 ELSE IF Not Handled THEN H:=FALSE;
              END; {case}
         END;
         ELSE IF not handled THEN H:=FALSE;
     END; {Case}
     Handled:=H;
     HandleEvent:=r;
END;


BEGIN
     MyApp.Init;
     MyApp.Run(1000,'PMMenus Demo Application',CLR_BLUE,CLR_WHITE);
     MyApp.Done;
END.
{The end}
























































 



























 



























 



























 
























































