PROGRAM Hallo2;

{***************************************************************************
*                                                                          *
*                Speed-Pascal/2 Sample program "Hallo2"                    *
*                                                                          *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.              *
*                                                                          *
*                                                                          *
*  This program extends the sample program "Hallo1" by a MenuBar           *
*                                                                          *
*                                                                          *
****************************************************************************}


USES PmTypes,Crt,API;  {bind Units used}


{Bind external resources}
RESOURCE Hallo2;


VAR
    HalloClass:STRING; {Window-Class of the main window}
    WindowStyle:ULONG; {Style of the main window}
    Frame,Win:HWND;    {Handles of the main Window}
    Title:STRING;      {Title of the main window}
    _qmsg:QMSG;        {Message queue}


{Dialog procedure for the Dialog "About". Handles messages.
 Messages not processed will be given to the Standard Dialog-Procedure
 (WinDefDlgProc).
 This function must be CDECL because PM calls this in C-Manner}
FUNCTION DlgWinProc(Dlg:HWND;Msg:ULONG;Para1,Para2:POINTER):ULONG;CDECL;
VAR
    result:ULONG;
BEGIN
     result:=WinDefDlgProc(Para2,Para1,Msg,Dlg);
     DlgWinProc:=result;
END;

{Window procedure for the Window-Class "Hallo". Handles messages.
 Messages not processed will be given to the Standard Window-Procedure
 (WinDefWndProc).
 This function must be CDECL because PM calls this in C-Manner}
FUNCTION WindowProc(Win:HWND;Msg:ULONG;Para1,Para2:POINTER):ULONG;CDECL;
VAR Handled:BOOLEAN;
    result:ULONG;
    command:WORD;
    Dlg:HWND;
BEGIN
     Handled:=TRUE;
     result:=0;
     CASE Msg OF
         WM_ERASEBACKGROUND:result:=1;
         WM_CLOSE:WinPostMsg(NIL,NIL,WM_QUIT,Win);
         WM_COMMAND:
         BEGIN
              command:=WORD(para1);
              CASE command OF
                  CM_ABOUT:
                  BEGIN
                        Dlg:=WinLoadDlg(NIL,2000,0,@DlgWinProc,Frame,
                                        HWND_DESKTOP);
                        WinProcessDlg(Dlg);
                        WinDestroyWindow(Dlg);
                  END;
                  ELSE Handled:=FALSE;
              END; {case}
         END;
         ELSE Handled:=FALSE;
     END; {Case}
     IF not Handled THEN result:=WinDefWindowProc(Para2,Para1,Msg,Win);
     WindowProc:=result;
END;

BEGIN {Main}
     {Initialize PM}
     AppHandle:=WinInitialize(0);
     AppQueueHandle:=WinCreateMsgQueue(0,AppHandle);

     {register Window class}
     HalloClass:='Hallo';
     WinRegisterClass(0,CS_SIZEREDRAW,@WindowProc,HalloClass,AppHandle);

     {ddefine main window}
     WindowStyle:=FCF_TITLEBAR OR FCF_SYSMENU OR FCF_MINMAX OR FCF_TASKLIST
                  OR FCF_SIZEBORDER OR FCF_ICON OR FCF_MENU;
     Title:='Hallo2 Sample Application';
     Frame:=WinCreateStdWindow(Win,1000,0,0,Title,HalloClass,WindowStyle,0,
                               HWND_DESKTOP);

     {Set position and show main window}
     WinSetWindowPos(SWP_SHOW OR SWP_ACTIVATE OR SWP_MOVE OR SWP_SIZE,
                     200,300,100,100,HWND_TOP,Frame);

     {Handle message queue}
     WHILE WinGetMsg(0,0,0,_qmsg,Apphandle)<>0 DO
       WinDispatchMsg(_qmsg,Apphandle);

     {Destroy main window}
     WinDestroyWindow(Frame);

     {Shut down PM}
     WinDestroyMsgQueue(AppQueueHandle);
     WinTerminate(AppHandle);
END.

 





























 
































 
























































