Procedure Spiral; assembler;
Var
  Starting_Point,
  Spiral_Count,
  Horiz_Line_Length,
  Vert_Line_Length,
  Step_Count,
  Line_Count : word;
asm
  push ds
  mov     ax,0B800h
  mov     es,ax                           {Set ES = Screen}
  mov     word ptr ds:[Spiral_Count],0Ch
  mov     word ptr ds:[Starting_Point],0D0h

 @Spiral_Loop:
  mov     ax,ds:[Starting_Point]
  mov     ds:[Step_Count],ax

 @One_Step_Loop:
  mov     word ptr ds:[Horiz_Line_Length],39h
  mov     word ptr ds:[Vert_Line_Length],1
  mov     di,798h
  mov     ax,ds:[Spiral_Count]
  mov     ds:[Line_Count],ax

 @Move_Horiz_Line_Left:
  mov     cx,ds:[Horiz_Line_Length]
  dec     cx

  push    ds
  push    es
  pop     ds
  mov     si,di
  add     si,2
  cld
  rep     movsw
  pop     ds

  mov     cx,ds:[Vert_Line_Length]
  push    ds
  push    es
  pop     ds
  mov     si,di
  sub     si,0A0h
  mov     ax,0A2h
  cld

 @Move_Vert_Line_Up:
  movsw
  sub     di,ax
  sub     si,ax
  loop    @Move_Vert_Line_Up

 @Move_Horiz_Line_Right:
  pop     ds
  mov     cx,ds:[Horiz_Line_Length]
  push    ds
  push    es
  pop     ds
  mov     si,di
  sub     si,2
  std
  rep     movsw
  pop     ds
  mov     cx,ds:[Vert_Line_Length]
  inc     cx
  push    ds
  push    es
  pop     ds
  mov     si,di
  add     si,0a0h
  mov     ax,0A2h
  std

 @Move_Vert_Line_Down:
  movsw
  add     di,ax
  add     si,ax
  loop @Move_Vert_Line_Down

  pop     ds

  add     word ptr ds:[Horiz_Line_Length],2
  add     word ptr ds:[Vert_Line_Length],2
  dec     word ptr ds:[Line_Count]
  jnz     @Move_Horiz_Line_Left
  dec     word ptr ds:[Step_Count]
  jz      @Done_One_Spiral
  jmp     @One_Step_Loop

 @Done_One_Spiral:
  sub     word ptr ds:[Starting_Point],8
  dec     word ptr ds:[Spiral_Count]
  jz      @Done_Spiral
  { Make sure there's no keypressed }
  call    crt.keypressed
  cmp     al,00h
  je      @Spiral_Loop

 @Done_Spiral:
  pop ds
end;
