Program Mymodem;
Uses Comm,asmmisc,crt,dos,int,fossil;
Const
  product = 'MyModem';
  author  = 'John Stephenson';
  version = '1.11a';
  release = 'Gamma';
Var
  _bps: longint;
  _comport: byte;
  _irq: byte;
  _routine: byte;

{$I MYMODEM.INC}

function Hex(i : Word) : String;
const hc : Array[0..15] of Char = '0123456789ABCDEF';
var l, h : Byte;
begin
  l := Lo(i);
  h := Hi(i);
  Hex[0] := #4;          { Length of String = 4 }
  Hex[1] := hc[h shr 4];
  Hex[2] := hc[h and $F];
  Hex[3] := hc[l shr 4];
  Hex[4] := hc[l and $F];
end;

Procedure Help;
begin
  writeln('Usage: ',paramstr(0),' [send/receive] (filename/dir to recieve)');
  writeln;
  writeln('Optional parameters (use at end of line): ');
  writeln('  /COM??? - ??? is the com port you wish to use');
  writeln('  /B????? - ????? is the bps you wish mymodem to use');
  writeln('  /IRQ?   - ? is the Non-Standard IRQ you might wish to use, if you''re');
  writeln('            not using a FOSSIL');
  writeln('  /INT    - Force interrupt driven comm routines');
  writeln('  /FOSSIL - Force FOSSIL driven comm routines');
  writeln;
  writeln('If /Int or /Fossil is not used, MyModem will autodetect!');
  halt(1);
end;

Function Numfunc(st: string): longint;
var
  code: word;
  temp: longint;
begin
  val(st,temp,code);
  numfunc := temp;
end;

Procedure ParseCommandline;
var
  temp: string;
  loop: byte;
begin
  for loop := 1 to paramcount do begin
    temp := upcasestr(paramstr(loop));
    if copy(temp,1,4) = '/COM' then _comport := numfunc(copy(temp,5,255));
    if copy(temp,1,2) = '/B' then _bps := numfunc(copy(temp,3,255));
    if copy(temp,1,4) = '/IRQ' then _irq := numfunc(copy(temp,5,255));
    if copy(temp,1,7) = '/FOSSIL' then _routine := 1;
    if copy(temp,1,4) = '/INT' then _routine := 2;
  end;
end;

var temp: string;
begin
  _comport := 1;
  _bps := 19200;
  _irq := 0;
  _routine := 0;
  textattr := lightcyan;
  writeln(product+' v'+version+' '+release+' by '+author);
  textattr := lightgray;
  if (paramcount < 1) then help;
  ParseCommandline;

  case _routine of
    1: Using_FOSSIL := true;
    2: Using_FOSSIL := false;
  end;
  if _irq > 0 then I_SetNSI(_ComPort,_IRQ);
  porton(_comport);
  initport(_comport,_bps,8,'n',1);

  writeln('Comport: ', comport);
  if using_fossil then writeln('Using FOSSIL')
  else begin
    textattr := lightred;
    writeln('Comm Address: ',hex(I_CombaseAdr[comport]),'h');
    writeln('IRQ Mask: ',hex(I_IntMasks[comport]),'h');
    writeln('IRQ Vector: ',hex(I_IntVect[comport]),'h');
    textattr := lightgray;
    writeln('Using Interrupt driven comm routines');
  end;
  if not carrier then begin
    writeln('No Carrier bonehead!');
    write('Continue [y/N]? ');
    if upcase(readkey) = 'Y' then writeln('Yes')
    else begin
      writeln('No');
      halt(1);
    end;
  end;

  temp := upcasestr(paramstr(1));
  if temp[1] = 'S' then mymodem_send(paramstr(2))
  else if temp[1] = 'R' then mymodem_recieve(paramstr(2))
  else begin
    textattr := lightred;
    writeln('Error in parameters!');
    help;
  end;
end.
