{$A+,B-,D+,E+,F-,G-,I-,L+,N-,O-,P-,Q-,R-,S+,T-,V+,X+}
{$M 16384,0,655360}
Program TestDoor;
Uses jsdoor,crt,asmmisc;
{ Note fossil and jsdoor units must be in the current dir }

Procedure Help;
begin
  textattr := lightcyan;
  writeln('TestDoor by John Stephenson');
  textattr := lightgray;
  writeln(enter+'Type TESTDOOR /F=DOOR.SYS');
  writeln('or TESTDOOR /D=DORINFOx.DEF');
  writeln(enter+'Use /n??? to override node number');
  halt;
end;

Procedure DrawStatusBar(dorsys : doorsystype);
var org : array[1..3] of byte;
const
  statustype = magenta shl 4 + white;
  info = magenta shl 4 + lightmagenta;
begin
  { Save current position }
  org[1] := wherex;
  org[2] := wherey;
  org[3] := textattr;
  { Draw status bar }
  with dorsys do begin
    { Fill the line with colour }
    textattr := statustype;  Gotoxy(1, maxheight);  clreol;
    { Write all the info }
    gotoxy(2, maxheight);  textattr := statustype;  write('User: ');
    textattr := info;  write(username);
    gotoxy(24, maxheight); textattr := statustype;  write('Bps: ');
    textattr := info;  write(baudrate);
    gotoxy(36, maxheight);  textattr := statustype;  write('Node: ');
    textattr := info;  write(node);
    gotoxy(45, maxheight);  textattr := statustype;  write('Access: ');
    textattr := info;  write(access, '  ');
    gotoxy(57, maxheight);  textattr := statustype;  write('Com: ');
    textattr := info;  write(comport);
    gotoxy(65, maxheight);
    textattr := info;  write('F1 '); textattr := statustype; write('Exit ');
    textattr := info;  write('F4 '); textattr := statustype; write('Chat');
  end;
  window(1, 1, maxwidth, maxheight-1);
  { Restore, taking into account that the maxheight changed }
  if org[2] > maxheight-1 then dec(org[2]);
  gotoxy(org[1], org[2]);
  textattr := org[3];
end;

Procedure Finish; far;
var org : array[1..2] of byte;
begin
  org[1] := wherex;
  org[2] := wherey;
  window(1,1,maxwidth,maxheight);
  gotoxy(1,maxheight);
  textattr := lightgray;
  clreol;
  gotoxy(org[1], org[2]);
  halt(0);
end;

{$I Spiral.inc}

var tempparam: string; newnode,code: integer; loop: byte;
begin
  { Scan the parameter(s) }
  newnode := -1;
  if paramcount = 0 then help;
  for loop := 1 to paramcount do begin
    tempparam := upcasestr(paramstr(loop));
    if tempparam[1] = '/' then begin
      case tempparam[2] of
        'F': readdoorsys(copy(tempparam,4,255),doorsys);
        'D': readdorinfo(copy(tempparam,4,255),doorsys);
        'N': begin
          val(copy(tempparam,3,255),newnode,code);
          if code <> 0 then begin
            writeln('Error in over ride node number');
            halt(1);
          end;
        end;
        '?': help;
        else begin
          textattr := lightred;
          writeln('Unknown parameter (',loop,')!');
          help;
        end;
      end;
    end
    else begin
      textattr := lightred;
      writeln('Unknown parameter (',loop,')!');
      help;
    end;
  end;
  if newnode <> -1 then doorsys.node := newnode;

  chatproc := @chat;
  finishup := @finish;
  spiral; { For cool effects. Note that this routine is from the assembler echo }
  while keypressed do readkey;

  clrscr;
  drawstatusbar(doorsys);
  jswriteln(avtcyan+'Hello to '+avtlightcyan+'TESTDOOR'+avtcyan
    +', here I''ll display a file called '+avtlightcyan+'TESTDOOR.BBS'+avtcyan+'.');
  jswriteln('It is a compiled '+avtlightcyan+'DECCA'+avtcyan+' file.  Check out to see whats in it :)  The uncompiled');
  jswriteln(avtlightcyan+'DECCA'+avtcyan+' file is Called '+avtlightcyan+'TESTDOOR.DEC'
    +avtcyan+', to compile type "decca testdoor"');
  jswrite(enter+'Press any key to view '+avtlightcyan+'TESTDOOR.BBS'+avtcyan+' file..');
  jsreadkey;
  jswriteln('');
  dispfile('TESTDOOR.BBS',1);

  jswriteln(avtlightmagenta+'Okay, anyways, to chat with yourself hit f4 :)');
  Jswriteln('Come on, hit f4 for Chat, or F3 for DOS, F5 for snoop off (requires a caller!)');
  jswriteln('or f2 to hangup on the current user, or F1 to kick the person off (you)' + enter);
  jswriteln(avtlightred+'NOTE: These commands only can be executed locally..');
  textcolor(lightcyan); { Note colours still can be changed this way too! }
  jswrite(enter+'Well.. What are you waiting for! (or press enter to quit)');
  repeat
  until jsreadkey=#13;

  JSwriteln(enter+avtwhite+'Well, I hope you enjoyed the DEMO!');
  finish;
end.
