
/************************************************************************
 *  Mouse.h                                                             *
 *                                                                      *
 *  (C) Adrian Christie July 1994                                       *
 *                                                                      *
 *  This header file supports the following mouse services:             *
 *  0 - initialize mouse.                                               *
 *  1 - turn on mouse.                                                  *
 *  2 - turn off mouse.                                                 *
 *  3 - get x & y coordinates, and which button pressed.                *
 *  4 - reset x & y coordinates.                                        *
 *  5 - how many times a button has been pressed                        *
 *  6 - mouse release information                                       *
 *  7 - set horizontal limits.                                          *
 *  8 - set vertical limits.                                            *
 ************************************************************************/              

 #define Mouse      0x33               /* interrupt 33 for mouse driver */

 static union REGS inregs, outregs;    /* register contents for int*/

 static struct Mouse_data{             /* structure for mouse data */
	int MouseFlag;
	int MouseButton;
	int MouseX;
	int MouseY;
	int MouseMinX;
	int MouseMaxX;
	int MouseMinY;
	int MouseMaxY;
 }Hold;

 /* mouse function calls -------------------------------- Service*/
 void MouseInit          (struct Mouse_data *M_ptr);    /*   0   */
 void MouseShow          (struct Mouse_data *M_ptr);    /*   1   */
 void MouseHide          (struct Mouse_data *M_ptr);    /*   2   */
 void MouseCoord         (struct Mouse_data *M_ptr);    /*   3   */
 void MouseCoordSet      (struct Mouse_data *M_ptr);    /*   4   */
 void MouseReset         (struct Mouse_data *M_ptr);    /*   4   */
 void MouseTimesPressed  (struct Mouse_data *M_ptr);    /*   5   */
 void MouseTimesReleased (struct Mouse_data *M_ptr);    /*   6   */
 void Mouse_x_limit      (struct Mouse_data *M_ptr);    /*   7   */
 void Mouse_y_limit      (struct Mouse_data *M_ptr);    /*   8   */

 /********************* End of header Mouse.h ********************/
