%This script M-file contain many of the examples in the
%MathViews tutorial sector of the manual.
%NOTE: MATHDEMO might not run all the examples (choose continue
%if you get an error)

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

clear
%matrix and vector manipulations
A = [ 1:4; 2:5]
x = 2:-0.5:0.5
x = sqrt(1:4)
1 + 1:5
1 + (1:5)
1:5 + 1

x = [ 1 2 3]
x = [ x, 4 5 6]
A = [ x; 5:10]

BA = [ 1 2 3 4 5 6 7 8 9]
BA = [BA;BA;BA]
BA = [BA;BA;BA]
BAT = BA'

BA(1:4, 1:4)
BA(3,:)
x = [ 2 4 6]
BA(:, x) = BA(:,6:8)
BA(:,2:3) = BA(:, 3:-1:2)
BA(2:3, [1 1 2 2])

L = [ 0 1 0 1 0 1 0 1 0]
BA(L,:)

%matrix reshaping and assignment
A = [ 1 2 3; 2 3 4]
A(:)
A(:) = 21:26
A(:) = [ 21 24 26 3 4 5]
%B(:) = 23:30 % should report an error

%linear and circular shifting.
A = [ 1 2 3 4; 5 6 7 8; 9 10 11 ...
12; 13 14 15 16]
A >> 2
A >> -2
A >> [ 0 2]
A >> [ 2 -2]

A <> [ 2 -2 3]
A <> [ 2 1 1; -2 3 4]

%matrix, element, column and vector deletion
%using  [ ] matrix to delete rows/columns
BA
BA(:, [ 1 3 5]) = [ ]
BA([2 4 6 8],:) = [ ]

%manipulation using logical vectors.
%9/14 doesn't work yet
%9/21 -- fixed
A = [ 1 2 3 4; 5 6 7 8; 9 10 11 12]
x = [ 1 0 1 0]
y = [ 0 1 0]
A(y,x)

x = [ 1 1 1 1]
A(y,x)

x = [ 1 1 3]
A(:,x)



%piping
x = [ 1 2 3]
abs( sqrt( cos( exp(x))))
exp(x)->cos->sqrt->abs

%dependence assignment
x = 1
y = 1
z = 2
A := abs(x + y)
B := sqrt(z + A)
 
%relational and logical operations
%relational
A =[ 1 2 3 4; 5 6 7 8; 9 10 11 12]
x = (A >= 5)
B =[ 9 2 45 4; 4 6 8 8; 9 20 11 12]
x = A == B

%logical
A = [  1 0 1; 0 1 0]
B = [ 1 1 1; 0 1 1]

%A AND B
A & B

%A OR B
A | B

%NOT
~(A == B)

%if constructions
A = [  1 0 1; 0 1 0]
B = [ 1 1 1; 0 1 1]
C = [ 1 1 1; 0 1 1]
if ( all(all(A == B)))
    disp('MathViews')
else
    disp('B ~= A')
end

if ( all(all(C == A)))
    disp('C == A')
elseif all(all(C == B))
    disp('C == B')
end

%while and for constructions
A = [  1 0 1; 0 1 0]
x = 0
while( A(2) == 0 )
    disp(x++)
    if x == 5
        A(2) = 1
    end
end

A = zeros(2)
B = rand(A)
while B > A
    disp(B>A)
    A = B
    B = rand(2,2)
end

BA = [ 1 2 3 4 5 6 7 8 9]
BA = [BA;BA;BA]
BA = [BA;BA;BA]
[m, n] = size(BA)

for i = 1:m
    for j = 1:n
        if ( i ~= j)
            BA(i,j) = BA(j,i);
        end
    end
end
BA

for i = 1:m
    for j = 1:n
            BA(i,j) = i * j;
            if ( (i == 2) & (j ==2))
                 break
            elseif ( (i == 4) & (j == 4))
                break
            elseif( (i==6) & (j==6))
                break
            end
        end
    end
end
BA
