function y=fft(x,n)
%y=fft(x,n)
%computes the FFT of the input array, x
%n specifies the size of the required transform

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

if ~isvector(x)
   error('input argument should be a vector')
end

[xm,xn]=size(x);
x=x(:);

if nargin > 1
   nx = length(x);
   if nx > n
      x=x(1:n);
   else
      x(n)=0;
   end
end

y=_fft(x);
if xn > xm
   y=y.';
end
