function [x1, y1] = meshdom(x,y)
%[x1, y1] = meshdom(x,y)
%compatibility function

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

% error checking
if nargin < 2
   error('meshdom: not enough input arguments');
end
if  ~isvector(x) || ~isvector(y)
   error('meshdom: input arguments must be vectors');
end

x1=x;
if ~isrow(x1)       % transpose a col vecor
   x1=x1.';
end

y1=y;
if ~iscol(y1)       % transpose a row vecor
   y1=y1.';
end

nx = length(x);
ny = length(y);
x1 = x1(ones(ny, 1),:);

y1 = flipud(y1);
y1 = y1(:,ones(1, nx));
