@ECHO OFF
REM * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
REM *                                                                     *
REM * ENVFORM example two                                                 *
REM *                                                                     *
REM * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 

REM - Set defaults
  SET testfile=

REM - Call ENVFORM.EXE with name of .INI file
  :loop
  envform ex2.ini

REM - Test for any errors or user abort
  IF ERRORLEVEL 1 GOTO byebye

REM - Perform SET statements defined in .INI file
  Call ex2b.bat
  Erase ex2b.bat

REM - Set error and re-enter if no file entered
  SET ENVError=File name to edit must be entered!
  IF (%testfile%)==() GOTO LOOP

REM - Set error and re-enter if file does not exist
  SET ENVError=File does not exist, please re-enter!
  IF NOT EXIST %testfile% GOTO LOOP

REM - Execute a program using newly set environment variables
  EDIT %testfile%

REM - Cleanup is always recommended (but seldom done)
  :byebye
  SET ENVError=
  SET testfile=
