'  -- TERM_IO.PAS --
'
'  This program is donated to the Public
'  Domain by MarshallSoft Computing, Inc.
'  It is provided as an example of the use
'  of the Personal Communications Library.
'

DEFINT A-Z

'$INCLUDE: 'PCL4B.BI'
'$INCLUDE: 'TERM_IO.BI'

CONST CR = 13, ESC = 27, BS = 8
CONST BLK = 32, CAN = 24

CONST LowVideo =  7
CONST HighVideo = 1

'** match baud rate string

FUNCTION MatchBaud(BaudString$)
  MatchBaud = -1
  IF BaudString$ = "300" THEN MatchBaud = 0
  IF BaudString$ = "600" THEN MatchBaud = 1
  IF BaudString$ = "1200" THEN MatchBaud = 2
  IF BaudString$ = "2400" THEN MatchBaud = 3
  IF BaudString$ = "4800" THEN MatchBaud = 4
  IF BaudString$ = "9600" THEN MatchBaud = 5
  IF BaudString$ = "19200" THEN MatchBaud = 6
  IF BaudString$ = "38400" THEN MatchBaud = 7
  IF BaudString$ = "57600" THEN MatchBaud = 8
  IF BaudString$ = "115200" THEN MatchBaud = 9
END FUNCTION

'** Transmits CAN's **

SUB TxCAN(BYVAL Port)
  FOR I = 1 TO 6
    Code = SioPutc(Port, CAN)
  NEXT I
END SUB

'** read message form line 25 **

SUB ReadMsg(MsgString$, BYVAL StartCol, BYVAL MaxLength)
  I = 0
  Row = CSRLIN
  Col = POS(0)
  VIEW PRINT 25 TO 25
  COLOR HighVideo
  MsgString$ = ""
  'input text from user
  LOCATE 25, StartCol, 1
  DO
    AnyKey$ = INKEY$
    IF AnyKey$ <> "" THEN
      SELECT CASE LEFT$(AnyKey$, 1)
        CASE CHR$(13)
          COLOR LowVideo
          VIEW PRINT 1 TO 24
          LOCATE Row, Col, 1
          EXIT SUB
        CASE CHR$(27)  'Escape
          'return empty string
          MsgString$ = ""
          COLOR LowVideo
          VIEW PRINT 1 TO 24
          LOCATE Row, Col, 1
          EXIT SUB
        CASE CHR$(8) 'backspace
          'back up if can
          IF I > 0 THEN
            'adjust buffer
            I = I - 1
            MsgString$ = LEFT$(MsgString$, LEN(MsgString$) - 1)
            'write blank at cursor
            LOCATE 25, StartCol + I, 1
            PRINT " ";
            LOCATE 25, StartCol + I, 1
          END IF
        CASE ELSE 'not one of above special chars
          'display on bottom line
          LOCATE 25, StartCol + I, 1
          PRINT AnyKey$;
          'save character
          I = I + 1
          MsgString$ = MsgString$ + AnyKey$
          'done ?
          IF I >= MaxLength THEN
            VIEW PRINT 1 TO 24
            COLOR LowVideo
            LOCATE Row, Col, 1
            EXIT SUB
          END IF
      END SELECT
    END IF
  LOOP
END SUB

'** write onto line 25

SUB WriteMsg(MsgString$, BYVAL StartCol)
  Col = POS(0)
  Row = CSRLIN
  VIEW PRINT 25 TO 25
  COLOR HighVideo
  LOCATE 25, StartCol, 1
  PRINT STRING$(40," ");
  LOCATE 25, StartCol, 1
  PRINT MsgString$;
  VIEW PRINT 1 TO 24
  COLOR LowVideo
  LOCATE Row, Col, 1
END SUB

                           