#    Copyright (C) 1991, 1992, 1993, 1994 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# Auxiliary MS-DOS makefile for maintenance operations.

# This file pertains to Aladdin Enterprises maintenance operations,
# and is unlikely to be useful to users.

# Targets:
#	xmit -- make the tar files for Kermit transmission
#	xjpeg -- make the tar file for the JPEG code
#	xfonts -- make the tar files for the fonts
#	laptop -- make a diskette for working on a laptop
#	release -- make the tar files for a release
# Remember to erase *.zip / *.taz, if needed, before running these.

PKZIP_ND=pkzip -ex
PKZIP=$(PKZIP_ND) -P

# ---------------- Make files for Kermit transmission ---------------- #

TARS=1.taz 2.taz dll.taz gnu.taz pdf.taz

FILES1=*.1 gs*.bat bdftops.bat font2c.bat ps2*.bat gs*.cmd
FILES2=fontmap.* copying news public readme bdftops font2c ps2*.
FILES_E=doc ps
FILES_XE=*.doc *.ps
FILES_RM=aa.ps c_*.* q* q*.* t.* comp1.*
SRC10=\rm.bat \cp.bat \mv.bat rm.cmd cp.cmd mv.cmd tar_*.bat *.lis
SRC11=g*.asm i*.asm ansi2knr.c echogs.c ega.c turboc.cfg gs*.com
SRC12=gs*.def *.icx gs*.rc *.mak *.sh *.tr tar_*. gs*. ccgs
SRC1_E=h mak
SRC1_XE=*.h *.mak
SRC11_RM=arch.h ccf*.tr c_*.* gconfig*.h j*.h n*.h n*.mak
SRC12_RM=l*.tr o*.tr q* q*.* t.* comp1.* _temp*.*
SRC1TEMP_RM=dvx-gcc.mak unixansi.mak unix-cc.mak unix-gcc.mak
SRC2=g*.c i*.c s*.c z*.c
DLL_F=dll.doc gsdll.c gsdll.h
GNU_F=COPYLEFT gdevla7t.c gdevln03.c gdevxes.c slzwce.c
GNU_RM=slzwe.c gdevgif.c
PDF_F=pdf*.ps

xmit: $(TARS)

xexe: 0.taz

xfonts: 8.taz 9.taz

xjpeg: 3.taz

release: xmit xexe

# The dependency lists for the .taz files should be much longer!

gs-tests.taz:
	if exist \gs\gs-tests.tar erase \gs\gs-tests.tar
	cd \gs\test
	tar -b20 -cf \gs\gs-tests.tar *.ps
	cd \gs
	if exist gs-tests.taz erase gs-tests.taz
	gzip gs-tests.tar

# We don't make 0.taz a dependent of gs.exe, because that forces
# rebuilding of gs.exe if we've switched configurations recently.
0.taz:
	@if not exist gs.exe echo gs.exe does not exist, do you want to proceed?
	@if not exist gs.exe pause
	@if not exist gs386.exe echo gs386.exe does not exist, do you want to proceed?
	@if not exist gs386.exe pause
	@if not exist gswin.exe echo gswin.exe does not exist, do you want to proceed?
	@if not exist gswin.exe pause
	if exist 0.tar erase 0.tar
	tar -b20 -cf 0.tar -uexe -uico -ures gs*.exe gs*.ico gs*.res
	if exist 0.taz erase 0.taz
	gzip 0.tar

STAGING=\gs\master\staging

1.taz:
	erase $(STAGING)\*.* <\y
	for %f in ($(FILES1)) do xcopy %f $(STAGING)
	for %f in ($(FILES2)) do xcopy %f $(STAGING)
	for %e in ($(FILES_E)) do xcopy *.%e $(STAGING)
	for %f in ($(SRC10)) do xcopy %f $(STAGING)
	for %f in ($(SRC11)) do xcopy %f $(STAGING)
	for %f in ($(SRC12)) do xcopy %f $(STAGING)
	for %e in ($(SRC1_E)) do xcopy *.%e $(STAGING)
	cd $(STAGING)
	tar_cat
	rm $(FILES_RM)
	rm $(DLL_F)
	rm $(GNU_F)
	rm $(PDF_F)
	xcopy \gs\quit.ps
	rm $(SRC11_RM)
	rm $(SRC12_RM)
	copy fontmap.gs fontmap
	if exist \gs\1.tar erase \gs\1.tar
	tar -b20 -cf \gs\1.tar *.*
	erase $(STAGING)\*.* <\y
	cd \gs
	if exist 1.taz erase 1.taz
	gzip 1.tar

2.taz: gs.c
	erase $(STAGING)\*.* <\y
	for %f in ($(SRC2)) do xcopy %f $(STAGING)
	cd $(STAGING)
	rm $(DLL_F)
	rm $(GNU_F)
	rm $(PDF_F)
	if exist \gs\2.tar erase \gs\2.tar
	tar -b20 -cf \gs\2.tar *.*
	erase $(STAGING)\*.* <\y
	cd \gs
	if exist 2.taz erase 2.taz
	gzip 2.tar

dll.taz: gsdll.c
	if exist dll.tar erase dll.tar
	tar -b10 -cf dll.tar $(DLL_F)
	if exist dll.taz erase dll.taz
	gzip dll.tar

gnu.taz: gdevln03.c
	erase $(STAGING)\*.* <\y
	for %f in ($(GNU_F)) do xcopy %f $(STAGING)
	cd $(STAGING)
	rm $(GNU_RM)
	if exist \gs\gnu.tar erase \gs\gnu.tar
	tar -b10 -cf \gs\gnu.tar *.*
	erase $(STAGING)\*.* <\y
	cd \gs
	if exist gnu.taz erase gnu.taz
	gzip gnu.tar

pdf.taz: pdf.ps
	if exist pdf.tar erase pdf.tar
	tar -b10 -cf pdf.tar $(PDF_F)
	if exist pdf.taz erase pdf.taz
	gzip pdf.tar

3.taz: jpeg\readme
	if exist 3.tar erase 3.tar
	tar -b20 -cf 3.tar -ugif -ujpg -uppm jpeg/*.*
	if exist 3.taz erase 3.taz
	gzip 3.tar

8.taz: fonts\pagd.gsf fonts\bchr.pfa
	if exist 8.tar erase 8.tar
	tar -b20 -cf 8.tar fonts/?0*.gsf fonts/p*.gsf fonts/z*.gsf fonts/b*.pfa fonts/n*.pfa fonts/p*.pfa
	if exist 8.taz erase 8.taz
	gzip 8.tar

9.taz: fonts\fcyr.gsf fonts\hrsyr.gsf fonts\hrger.pfa
	if exist 9.tar erase 9.tar
	tar -b20 -cf 9.tar fonts/f*.gsf fonts/h*.gsf fonts/h*.pfa
	if exist 9.taz erase 9.taz
	gzip 9.tar

# ---------------- Make a diskette for a laptop ---------------- #

laptop: gsfiles.zip gssrc1.zip gssrc2.zip
	@echo ---------------- Insert diskette:
	@command /c pause
	xcopy \utils\pk*.exe A: /v
	xcopy \utils\dif.exe A:
	xcopy \autoexec.bat A: /v
	xcopy \config.sys A: /v
	pkzip A:root.zip \*.bat y
	pkzip -d A:root.zip autoexec.bat
	pkzip A:eps.zip \eps\*.*
	pkzip A:fastback.zip \fastback\*.*
	pkzip -d A:fastback.zip *.his
	pkzip A:uu.zip \uu\*.c \uu\*.exe
	pkzip A:xtpro.zip \xtpro\*.*
	xcopy gsfiles.zip A:
	xcopy gssrc*.zip A:

# ---------------- Make MS-DOS diskette sets ---------------- #

SRCZIPS=gsfiles.zip gssrc1.zip gssrc2.zip gssrcdll.zip gssrcgnu.zip gssrcpdf.zip
FONTZIPS=gsfonts1.zip gsfonts2.zip gsfonts3.zip gsfonts4.zip

allzips: gsexe.zip $(SRCZIPS) $(FONTZIPS)
	@echo ---------------- Done. ----------------

fontzips: $(FONTZIPS)
	@echo ---------------- Done. ----------------

srczips: $(SRCZIPS)
	@echo ---------------- Done. ----------------

zips: gsexe.zip $(SRCZIPS)
	@echo ---------------- Done. ----------------

# We don't make gsexe.zip a dependent of gs.exe, because that forces
# rebuilding of gs.exe if we've switched configurations recently.
gsexe.zip:
	@if not exist gs.exe echo gs.exe does not exist, do you want to proceed?
	@if not exist gs.exe pause
	@if not exist gs386.exe echo gs386.exe does not exist, do you want to proceed?
	@if not exist gs386.exe pause
	@if not exist gswin.exe echo gswin.exe does not exist, do you want to proceed?
	@if not exist gswin.exe pause
	if exist _temp_.zip erase _temp_.zip
	$(PKZIP) _temp_.zip gs*.exe
	if exist gs386.exe $(PKZIP_ND) -a _temp_.zip \watc\bin\dos4gw.exe
	if exist gswin.exe $(PKZIP) -a _temp_.zip gs*.ico gs*.res
	if exist gspmdrv.exe $(PKZIP) -a _temp_.zip gs*.ico gs*.res
	if exist gsexe.zip erase gsexe.zip
	rename _temp_.zip gsexe.zip

gsfiles.zip: maint.mak
	if exist _temp_.zip erase _temp_.zip
	copy fontmap fontmap_
	copy fontmap.gs fontmap
	$(PKZIP) _temp_.zip $(FILES1)
	$(PKZIP) -a _temp_.zip $(FILES2)
	copy fontmap_ fontmap
	erase fontmap_
	$(PKZIP) -a _temp_.zip $(FILES_XE)
	pkzip -d _temp_.zip $(FILES_RM)
	pkzip -d _temp_.zip $(DLL_F)
	pkzip -d _temp_.zip $(GNU_F)
	pkzip -d _temp_.zip $(PDF_F)
	$(PKZIP) -a _temp_.zip quit.ps
	if exist gsfiles.zip erase gsfiles.zip
	rename _temp_.zip gsfiles.zip

gssrc1.zip: ansi2knr.c
	if exist _temp_.zip erase _temp_.zip
	tar_cat
	$(PKZIP) _temp_.zip $(SRC10)
	$(PKZIP) -a _temp_.zip $(SRC11)
	$(PKZIP) -a _temp_.zip $(SRC12)
	$(PKZIP) -a _temp_.zip $(SRC1_XE)
	rm -f $(SRC1TEMP_RM)
	pkzip -d _temp_.zip $(SRC11_RM)
	pkzip -d _temp_.zip $(SRC12_RM)
	pkzip -d _temp_.zip $(DLL_F)
	pkzip -d _temp_.zip $(GNU_F)
	pkzip -d _temp_.zip $(PDF_F)
	if exist gssrc1.zip erase gssrc1.zip
	rename _temp_.zip gssrc1.zip

gssrc2.zip: gs.c
	if exist _temp_.zip erase _temp_.zip
	$(PKZIP) _temp_.zip $(SRC2)
	pkzip -d _temp_.zip $(DLL_F)
	pkzip -d _temp_.zip $(GNU_F)
	if exist gssrc2.zip erase gssrc2.zip
	rename _temp_.zip gssrc2.zip

gssrcdll.zip: gsdll.c
	if exist _temp_.zip erase _temp_.zip
	$(PKZIP) _temp_.zip $(DLL_F)
	if exist gssrcdll.zip erase gssrcdll.zip
	rename _temp_.zip gssrcdll.zip

gssrcgnu.zip: gdevln03.c
	if exist _temp_.zip erase _temp_.zip
	$(PKZIP) _temp_.zip $(GNU_F)
	pkzip -d _temp_.zip $(GNU_RM)
	if exist gssrcgnu.zip erase gssrcgnu.zip
	rename _temp_.zip gssrcgnu.zip

gssrcpdf.zip: pdf.ps
	if exist _temp_.zip erase _temp_.zip
	$(PKZIP) _temp_.zip $(PDF_F)
	if exist gssrcpdf.zip erase gssrcpdf.zip
	rename _temp_.zip gssrcpdf.zip

# IJG code.
gsjpeg.zip: jpeg\readme
	if exist _temp_.zip erase _temp_.zip
	$(PKZIP) _temp_.zip jpeg\*.*
	if exist gsjpeg.zip erase gsjpeg.zip
	rename _temp_.zip gsjpeg.zip

# Fonts created from X11 or other freely distributed bitmaps
# by Aladdin Enterprises.
gsfonts1.zip: fonts\phvr.gsf fonts\zcr.gsf
	if exist _temp_.zip erase _temp_.zip
	$(PKZIP_ND) _temp_.zip fonts\p*.* fonts\z*.*
	pkzip -d _temp_.zip pu*.*
	if exist gsfonts1.zip erase gsfonts1.zip
	rename _temp_.zip gsfonts1.zip

# Type 1 fonts from the X11 distribution.
gsfonts2.zip: fonts\bchr.pfa fonts\ncrr.pfa fonts\putr.pfa
	if exist _temp_.zip erase _temp_.zip
	$(PKZIP_ND) _temp_.zip fonts\b*.* fonts\nc*.* fonts\pu*.*
	if exist gsfonts2.zip erase gsfonts2.zip
	rename _temp_.zip gsfonts2.zip

# Freeware fonts.
gsfonts3.zip: fonts\fcyr.gsf fonts\hrpld.pfa fonts\hrplr.gsf
	if exist _temp_.zip erase _temp_.zip
	$(PKZIP_ND) _temp_.zip fonts\f*.* fonts\h*.*
	if exist gsfonts3.zip erase gsfonts3.zip
	rename _temp_.zip gsfonts3.zip

# GNU-licensed fonts donated by third parties.
gsfonts4.zip: fonts\n019003l.gsf fonts\u004006t.gsf
	if exist _temp_.zip erase _temp_.zip
	$(PKZIP_ND) _temp_.zip fonts\n0*.gsf fonts\u0*.gsf
	if exist gsfonts4.zip erase gsfonts4.zip
	rename _temp_.zip gsfonts4.zip
