/* Copyright (C) 1992, 1993 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* gxdcconv.h */
/* Internal device color conversion interfaces */
#include "gxfrac.h"

/* Color representation conversion routines */
void color_hsb_to_rgb(P4(floatp h, floatp s, floatp b, float rgb[3]));
void color_rgb_to_hsb(P4(floatp r, floatp g, floatp b, float hsb[3]));
/* Color space conversion routines */
frac color_rgb_to_gray(P4(frac r, frac g, frac b,
  const gs_state *pgs));
void color_rgb_to_cmyk(P5(frac r, frac g, frac b,
  const gs_state *pgs, frac cmyk[4]));
frac color_cmyk_to_gray(P5(frac c, frac m, frac y, frac k,
  const gs_state *pgs));
void color_cmyk_to_rgb(P6(frac c, frac m, frac y, frac k,
  const gs_state *pgs, frac rgb[3]));
