unit SS_Unit;
{$R ss_unit.res}     { resource file with password dialogs. }

interface

uses
   OWindows, ODialogs, Wintypes, Winprocs, Strings;

type
   { Screen saver main window type }
   PSaverWin = ^TSaverWin;
   TSaverWin = Object(TWindow)
      AppNameStr: string;    { Name given to this application, for CONTROL.INI }
      LastMouse: Tpoint;     { Where mouse was when saver turned on. }
      constructor Init(aParent: PWindowsObject; AppName: PChar);
      function GetClassName: PChar; virtual;
      procedure GetWindowClass(var WndClass: TWndClass); virtual;
      procedure SetUpWindow; virtual;
      procedure Animate; virtual;      { Ancestor for the action of the saver }
      procedure EndShow(var Msg: TMessage); virtual;       { Time to stop the saver }
      function PassWordOk: boolean;    { Check to see if authorized to stop . }
      procedure WMMousemove(var Msg: TMessage);   virtual wm_first + WM_MOUSEMOVE;
      procedure WMLbuttondown(var Msg: TMessage); virtual wm_first + WM_LBUTTONDOWN;
      procedure WMRbuttondown(var Msg: TMessage); virtual wm_first + WM_RBUTTONDOWN;
      procedure WMMbuttondown(var Msg: TMessage); virtual wm_first + WM_MBUTTONDOWN;
      procedure WMSyskeydown(var Msg: TMessage);  virtual wm_first + WM_SYSKEYDOWN;
      procedure WMKeydown(var Msg: TMessage);     virtual wm_first + WM_KEYDOWN;
      end;

   { Configuration dialog type }
   PConfigDlg = ^TConfigDlg;
   TConfigDlg = object(TDlgWindow)
      AppNameStr: string;    { Application name for CONTROL.INI use. }
      constructor Init(AppName, DlgName: PChar);
      function  GetClassName: PChar; virtual;
      procedure SetUpWindow; virtual;
      procedure SetEditString(EditId: integer; Content: string);
      function GetEditString(EditId: integer): string;
      procedure SetEditInteger(EditId, Val: integer);
      function GetEditInteger(EditId: integer): integer;
      procedure SetButton(EditId: integer; State: boolean);
      function GetButton(EditId: integer): boolean;
      procedure PassWordButton(var Msg: TMessage); virtual id_First + 200;
      procedure Ok(var Msg: TMessage); virtual id_First + id_Ok;
      end;

   { This Dialog collects the original password from the user. }
   PPassWordGetDlg = ^TPassWordGetDlg;
   TPassWordGetDlg = object(TDialog)
      procedure Ok(var Msg: TMessage); virtual id_First + Id_Ok;
      procedure Cancel(var Msg: TMessage); virtual id_First + Id_Cancel;
      end;

   { This Dialog gets the password from the user to test. }
   PPassWordCheckDlg = ^TPassWordCheckDlg;
   TPassWordCheckDlg = object(TDialog)
      procedure Ok(var Msg: TMessage); virtual id_First + Id_Ok;
      end;

implementation
var
   UserPassWordHash: string;           { Dialogs can put hash in here. }

{ ******************* TSaverWin methods ************************** }
function TSaverWin.GetClassName: PChar;
begin
   GetClassName := 'BPScreenSaver';    { distinct name for special class. }
   end;

{ Register some of the non-default attributes. }
procedure TSaverWin.GetWindowClass(var WndClass:TWndClass);
begin
   inherited GetWindowClass(WndClass);
   WndClass.Style := 0;
   WndClass.hCursor := 0;              { Turn off cursor. }
   WndClass.hbrBackGround := GetStockObject(Black_Brush);  { Erase background. }
   end;

{ Size window to screen. }
constructor TSaverWin.Init(aParent: PWindowsObject; AppName: PChar);
begin
   inherited Init(aParent, AppName);
   with Attr do
       begin
       Style := WS_POPUP or WS_VISIBLE;
       X := 0;                                   { Upper left corner }
       Y := 0;
       W := GetSystemMetrics(SM_CXSCREEN);       { Full size in X and Y }
       H := GetSystemMetrics(SM_CYSCREEN);
       end;
   AppNameStr := StrPas(AppName);                { Save name passed in. }
   AppNameStr[length(AppNameStr) + 1] := #0;     { Make PChar compatible. }
   UserPassWordHash := '';
   end;

{ Get ready to show the window. }
procedure TSaverWin.SetUpWindow;
begin
   inherited SetUpWindow;
   SetWindowPos(hWindow, $FFFF{HWND_TOPMOST}, 0, 0, 0, 0, SWP_NOMOVE or SWP_NOSIZE);
   GetCursorPos(LastMouse);   { Find reference mouse position. }
   end;

{ Keep knocking that cursor back. }
procedure TSaverWin.Animate;
begin
   SetCursor(0);
   end;

{ Is it okay to close up screeen saver? }
function TSaverWin.PassWordOk: boolean;
var
   OldHashStr: string;
   OldHash: array[0..40] of char;
begin
   if 0 <> GetPrivateProfileInt(@AppNameStr[1], 'PWProtected', 0, 'CONTROL.INI')
   then begin      { Password protect in effect. }
      OldHash[0] := #0;
      GetPrivateProfileString('ScreenSaver', 'Password',
                               @OldHash[0], @OldHash[0], 41, 'CONTROL.INI');
      OldHashStr := StrPas(OldHash);   { Force PChar into string. }
      if OldHashStr <> ''
      then begin
         Application^.ExecDialog(new(PPassWordCheckDlg, Init(@Self, 'PASSCHECK_DLG')));
         if OldHashStr <> UserPassWordHash       { hashes match? }
         then begin
            PassWordOk := false;       { A real failure. }
            if UserPassWordHash <> ''  { blank user hash means no attempt, or a cancel. }
            then MessageBox(hwindow, 'Invalid password.', 'Alert', mb_ok);
            end
         else PassWordOk := true;      { Passwords did match! }
         end
      else PassWordOK := true;         { Null original password needs no match. }
      end
   else PassWordOK := true;  { automaticaly ok, no checking was needed. }
   end;

{ Check password if needs be, then close. }
procedure TSaverWin.EndShow(var Msg: TMessage);
begin
   if PasswordOK
   then PostMessage(HWindow, WM_CLOSE, 0, 0);    { Let main loop do closing. }
   end;

{ Any of these will try to close the screen saver. }
procedure TSaverWin.WMLbuttondown(var Msg: TMessage);
begin EndShow(Msg); end;
procedure TSaverWin.WMRbuttondown(var Msg: TMessage);
begin EndShow(Msg); end;
procedure TSaverWin.WMMbuttondown(var Msg: TMessage);
begin EndShow(Msg); end;
procedure TSaverWin.WMSyskeydown(var Msg: TMessage);
begin EndShow(Msg); end;
procedure TSaverWin.WMKeydown(var Msg: TMessage);
begin EndShow(Msg); end;
procedure TSaverWin.WMMouseMove(var Msg: TMessage);
var
   CurrMouse: Tpoint;
begin
   GetCursorPos(CurrMouse);            { Where's the mouse?  }
   if (LastMouse.x <> CurrMouse.x)
   or (LastMouse.y <> CurrMouse.y)
   then EndShow(Msg)                  { Try to end if new mouse position }
   else DefWndProc(Msg);
   end;

{ ***** Official Windows Screen Saver encryption, lame as it is. ***** }
{ Mask and Txt are characters to be merged. }
function Stir(Mask, Txt: char): char;
const
   NotAllowed = [0..$20, $7F..$90, $93..$FF, $3d, $5b, $5d];
   { the last three are '[', ']', '='  which are not allowed in profile string }
   { apparently AE and ae ($91 and $92) are allowed in. }
var
   Mix: byte;
begin
   Mix := ord(Mask) xor ord(Txt);
   if Mix in NotAllowed
   then Stir := Txt           { Do nothing if result is bad. }
   else Stir := char(Mix);    { Otherwise use exclusive or function. }
   end;

{ Scan forward through text }
function Pass1(Raw: string): string;
var
   i: integer;
   Mask: char;
begin
   Mask := Raw[0];                               { grab length }
   for i := 1 to length(Raw) do begin
      Raw[i] := Stir(Mask, Raw[i]);              { xor with length }
      if i = 1
      then  Raw[i] := Stir(char($2a), Raw[i])    { a constant for first character }
      else begin
         Raw[i] := Stir(char(i - 1), Raw[i]);    { xor with current count }
         Raw[i] := Stir(Raw[i - 1], Raw[i]);     { xor with prior character }
         end;
      end;
   Pass1 := Raw;
   end;

{ Scan backwards through text }
function Pass2(Raw: string): string;
var
   i: integer;
   Mask: char;
begin
   Mask := Raw[0];                               { grab length }
   for i := length(Raw) downto 1 do begin
      Raw[i] := Stir(Mask, Raw[i]);              { xor with length }
      if i = length(Raw)
      then  Raw[i] := Stir(char($2a), Raw[i])    { a constant for fisrt character }
      else begin
         Raw[i] := Stir(char(i - 1), Raw[i]);    { xor with current count }
         Raw[i] := Stir(Raw[i + 1], Raw[i]);     { xor with later character }
         end;
      end;
   Pass2 := Raw;
   end;

{ Take a string, and encrypt it in standard sreen saver way. }
function Encrypt(Plain: string): string;
var
   i: integer;
begin
   for i := 1 to length(Plain) do Plain[i] := UpCase(Plain[i]);      { All caps. }
   if length(Plain) > 1
   then Encrypt := Pass2(Pass1(Plain))           { Both passes if more than one char. }
   else Encrypt := Pass1(Plain);                 { One pass if one char }
   end;

{ *************** TPassWordGetDlg methods ***************}
{ Store password from dialog where parent can get it. }
procedure TPassWordGetDlg.Ok(var Msg:Tmessage);
var
   PassWord: string;
begin
   PassWord[1] := #0;           { Safety for failure }
   SendDlgItemMsg(100, wm_GetText, 40, longint(@PassWord[1]));
   Password[41] := #0;          { Safety for too long}
   PassWord[0] := char(StrLen(@PassWOrd[1]));
   UserPassWordHash := Encrypt(PassWord);
   inherited OK(Msg);
   end;

{ Cancel is equivalent to no password. }
procedure TPassWordGetDlg.Cancel(var Msg:Tmessage);
begin
   UserPassWordHash := '';
   inherited Cancel(Msg);
   end;

{ *************** TPassWordCheckDlg methods ***************}
{ Store hash of password where parent can get it. }
procedure TPassWordCheckDlg.Ok(var Msg:Tmessage);
var
   PassWord: string;
begin
   PassWord[1] := #0;           { Safety for failure }
   SendDlgItemMsg(100, wm_GetText, 40, longint(@PassWord[1]));
   Password[41] := #0;          { Safety for too long}
   PassWord[0] := char(StrLen(@PassWOrd[1]));
   UserPassWordHash := Encrypt(PassWord);
   inherited OK(Msg);
   end;

{ ************ TConfigDlg methods ***************** }
{  Ancestral dialog initialization. }
constructor TConfigDlg.Init(AppName, DlgName: PChar);
begin
   inherited Init(nil, DlgName);
   AppNameStr := StrPas(AppName);
   AppNameStr[length(AppNameStr) + 1] := #0;  { make PChar compatable. }
   UserPassWordHash := '';
   end;

{ Don't change the class name. }
function  TConfigDlg.GetClassName: PChar;
begin
   GetClassName := 'ScreenSaveDialog'; { This name seems special. }
   end;

{ Set up the password enabled checkbox. }
procedure TConfigDlg.SetUpWindow;
begin
   inherited SetUpWindow;
   if 0 <> GetPrivateProfileInt(@AppNameStr[1], 'PWProtected', 0, 'CONTROL.INI')
   then SetButton(201, true)           { Password protect is on }
   else SetButton(201, false);
   end;

{ Retrieve a string from an edit control }
function TConfigDlg.GetEditString(EditId: integer): string;
var
   PBuffer: array[0..41] of char;
begin
   Pbuffer[0] := #0;           { Safety for failure }
   SendDlgItemMsg(EditId, wm_GetText, 40, longint(@PBuffer));
   Pbuffer[41] := #0;          { Safety for too long}
   GetEditString := StrPas(PBuffer);
   end;

{ Write a string into an edit control }
procedure TConfigDlg.SetEditString(EditId: integer; Content: string);
var
   Buffer: string[40];
begin
   Buffer := Content + #0;
   SendDlgItemMsg(EditId, wm_SetText, 0, longint(@Buffer[1]));
   end;

{ Write an integer into an edit control }
procedure TConfigDlg.SetEditInteger(EditId, Val: integer);
var
   Buffer: string[40];
begin
   str(Val, Buffer);
   SetEditString(EditId,  Buffer);
   end;

{ write an integer into an edit control }
function TConfigDlg.GetEditInteger(EditId: integer): integer;
var
   Buffer: string[40];
   Num, Code: integer;
begin
   Buffer := GetEditString(EditId);
   Val(Buffer, Num, Code);
   GetEditInteger := Num;
   end;

{ Set the state of a button control }
procedure TConfigDlg.SetButton(EditId: integer; State: boolean);
begin
   if State
   then SendDlgItemMsg(EditId, bm_SetCheck, 1, 0)
   else SendDlgItemMsg(EditId, bm_SetCheck, 0, 0);
   end;

{ Return the state of the named button, true = on }
function TConfigDlg.GetButton(EditId: integer): boolean;
begin
   if 1 = SendDlgItemMsg(EditId, bm_GetCheck, 0, 0)
   then GetButton := true
   else GetButton := false;
   end;

{ Take care of ancestral password enable/disable functions. }
procedure TConfigDlg.Ok(var Msg: TMessage);
begin
   if GetButton(201)         { Is password enable checked? }
   then WritePrivateProfileString(@AppNameStr[1], 'PWProtected', '1', 'CONTROL.INI')
   else WritePrivateProfileString(@AppNameStr[1], 'PWProtected', '0', 'CONTROL.INI');
   WritePrivateProfileString (nil, nil, nil, 'CONTROL.INI');         { flush cache }
   inherited OK(Msg);
   end;

{ Take care of Password button pushes. }
procedure TConfigDlg.PassWordButton(var Msg: TMessage);
begin
   Application^.ExecDialog(new(PPassWordGetDlg, Init(@Self, 'PASSGET_DLG')));
   if  UserPassWordHash <> ''
   then begin      { set the active password for all savers. }
      UserPassWordHash := UserPassWordHash + #0;
      WritePrivateProfileString('Screensaver', 'Password', @UserPassWordHash[1], 'CONTROL.INI');
      WritePrivateProfileString (nil, nil, nil, 'CONTROL.INI');      { flush cache }
      end;
   end;

begin  { no unit initialization needed. }
   end.
