   TITLE    Access to the 32 bit Memory for Unit MEM32bit.PAS
   NAME     MEM32bit    ; Jochen Magnus, 10/94

   code SEGMENT PUBLIC USE16
   assume cs:code

   LOCALS @@
   .386

   PUBLIC mem32copy, mem32fill

   ; NOTE: Procedures are declared as Near!


mem32copy PROC NEAR        ;  (ssel:word; sofs:longint;
                           ;   tsel:word; tofs:longint;
                           ;   len:longint); NEAR!

   len   EQU dword ptr ss:[bx+ 2]   ; len to move (Near and without BP-push)
   tofs  EQU dword ptr ss:[bx+ 6]   ; Target-Offset   (16)
   tsel  EQU word ptr  ss:[bx+10]   ; Target-Selector (32)
   sofs  EQU dword ptr ss:[bx+12]   ; Source-Offset   (16)
   ssel  EQU word ptr  ss:[bx+16]   ; Source-Selector (32)

   mov   bx,sp                ; BX is used for parameter access instead of BP
   mov   dx,ds                ; save DS in DX

   mov   ecx,len
   mov   ds,ssel
   mov   esi,sofs
   mov   es,tsel
   mov   edi,tofs
   cld                     ; vorbesetzen mit 'aufwaerts kopieren'

   cmp   ecx,12
   jae   @@20              ; wenigstens 12 Byte sonst simple Byte-Moveroutine
   jecxz @@100             ; gar nichts zu tun

   cmp   esi,edi
   jae   @@10              ; Ziel>Quelle
   add   esi,ecx           ; Ziel<Quelle
   add   edi,ecx
   dec   esi
   dec   edi
   std                     ; abwaerts kopieren
@@10:
   db    67h
   rep   movsb
   jmp   @@100

@@20:                      ; Move mit Dwords ab 386er CPU
   cmp   esi,edi
   jae   @@50              ; Ziel>Quelle
   add   esi,ecx           ; Ziel<Quelle
   add   edi,ecx
   dec   esi
   dec   edi
   std                     ; abwaerts kopieren
   shr   ecx,1                ; erst Restbyte, Restword, DWords
   jnc   @@30
   db    67h
   movsb
@@30:
   dec   edi                  ; Zeiger auf Wordgrenze
   dec   esi
   shr   ecx,1
   jnc   @@40
   db    67h
   movsw
@@40:
   dec   edi
   dec   edi                  ; Zeiger auf Dwordgrenze
   dec   esi
   dec   esi
   db    67h
   rep   movsd
   jmp   @@100

@@50:                         ; aufwaerts, erst DWords, Restword, Restbyte
   shr   ecx,1
   setc  al                   ; Flags (Carry) in AL merken
   shr   ecx,1
   db    67h
   rep   movsd
   jnc   @@60
   db    67h
   movsw
@@60:
   test al,1               ; war Carry beim ersten shr
   jz   @@100
   db    67h
   movsb

@@100:
   cld                     ; nur zur Vorsicht
   mov   ds,dx             ; restore ds
   retn  16
mem32copy endp



mem32fill PROC NEAR        ;  (sel:word; ofs:longint;
                           ;   len:longint; pattern:byte); NEAR!

   pat   EQU byte ptr  ss:[bx+ 2]   ; pattern to fill in
   len   EQU dword ptr ss:[bx+ 4]   ; len to move
   ofs   EQU dword ptr ss:[bx+ 8]   ; Target-Offset   (16)
   sel   EQU word ptr  ss:[bx+12]   ; Target-Selector (32)
   

   mov   bx,sp                ; BX is used for parameter access instead of BP
   mov   al,pat            ; Fllbyte
   mov   ah,al             ; fr STOSW auch im Highbyte
   mov   dx,ax             ; in BX merken
   shl   eax,16            ; ab ins High-Word fr STOSD
   mov   ax,dx                ; und Low-Word zurckladen

   mov   ecx,len
   mov   es,sel
   mov   edi,ofs
   cld

   shr   ecx,1
   setc  dl                   ; Flags (Carry) in DL merken
   je    @@20              ; CX jetzt 0 (war also 0..1)
   shr   ecx,1
   je    @@10              ; CX jetzt 0 (war also 2..3)
   db    67h
   rep   stosd
@@10:
   jnc   @@20
   db    67h
   stosw
@@20:
   test  dl,1                 ; war Carry beim ersten shr
   jz    @@100
   db    67h
   stosb

@@100:
   retn  12

mem32fill endp


code ends
end
