' Example program and demo for The Font Editor
' Subroutines for loading and using fonts
' Can be merged into program

DECLARE SUB LoadFont (FileName$, Font%())
DECLARE SUB GFPrint (Text$, X%, Y%, XStep%, YStep%, Font%())

' DIMension arrays
DIM F1%(3795)
DIM F2%(3795)
DIM F3%(3795)
DIM F4%(3795)

' Load fonts into arrays
LoadFont "TF001.FNT", F1%()
LoadFont "TF002.FNT", F2%()
LoadFont "TF003.FNT", F3%()
LoadFont "GF001.FNT", F4%()


' Print Font
SCREEN 9: CLS
LINE (39, 0)-(599, 100), 7, BF
'---
GFPrint "THE FONT EDITOR", 120, 10, 24, 0, F2%()
GFPrint "EXAMPLE PROGRAM", 120, 60, 24, 0, F2%()
'---
GFPrint "JKKKKKKKKKKKKL", 0, 0, 0, 24, F4%()
GFPrint "JKKKKKKKKKKKKL", 616, 0, 0, 24, F4%()
'---
GFPrint "DOWN", 70, 170, 0, 24, F1%()
GFPrint "FORWARD", 250, 120, 24, 0, F1%()
GFPrint "SLANTED", 120, 130, 24, 24, F1%()
GFPrint "UP", 550, 280, 0, -24, F1%()
GFPrint "BACKWARD", 510, 180, -24, 0, F1%()
'---
GFPrint "PRESS ANY KEY", 150, 310, 24, 0, F3%()
'---
A$ = INPUT$(1)
END

' Text$ is the string to be printed
' X% & Y% give the starting point to begin printing
' XStep% & YStep% give the amount of spacing between letters
' Font%() is integer array which holds font. (See LoadFont subroutine)
' --------------------------------------------------------------------------
SUB GFPrint (Text$, X%, Y%, XStep%, YStep%, Font%())
Text$ = UCASE$(Text$)
FOR A% = 1 TO LEN(Text$)
N% = ASC(MID$(Text$, A%, 1))
IF N% = 32 THEN GOTO GFPSkipPut
N% = ((N% - 65) * 146)
PUT (X%, Y%), Font%(N%), PSET
GFPSkipPut:
X% = X% + XStep%: Y% = Y% + YStep%
NEXT A%
END SUB

' FileName$ is the name of the font to be loaded
' Font%() is an integer array to hold font DIMensioned to 3795
' OPTION BASE 0 (Default) must be used
SUB LoadFont (FileName$, Font%())
DEF SEG = VARSEG(Font%(0))
BLOAD FileName$, VARPTR(Font%(0))
DEF SEG
END SUB

