.386
LOCALS ; enable local labels
;
;  Add two longints together using real 32 bit code, (no segment prefix overrides)
;
;  This should be called from 16 bit Windows using a 32 bit call gate.
;
;  It runs in ring 3 which has our usual 16 bit stack so there is no reason to copy parameters
;  with the call gate.
;
;  To compile use: TASM s32;
;                  TLINK s32;
;                  EXE2BIN s32;
;
;  This creates s32.bin which is then directly loaded into your 32 bit code segment and
;  called using a 32 bit call gate.
;
;  See the file ZC32LOAD.PAS for more information.
;
;

DATA SEGMENT USE32
DATA ENDS

CODE SEGMENT USE32
ASSUME cs:CODE

ALIGN 16 ; Align code on paragraph boundarys

add2longs PROC
          PUBLIC add2longs;

          ; Preamble, we want to use ebp with a 16 bit stack, so we clear its upper word
              push bp
              xor ebp,ebp
              mov bp,sp

          ; Load the arguments
              mov eax,[ebp+0eh]; 1st parameter
              mov ebx,[ebp+0ah]; 2nd parameter

          ; Do the addition
              add eax,ebx

          ; copy the hiword of EAX into DX so that 16-bit BP can deal with it
              mov edx,eax
              shr edx,16

          ; goodbye
              pop bp
              retf 4

add2longs ENDP


CODE ENDS
END


