unit hexunit;
{$A+,B-,D+,F+,G+,I+,K+,L+,N+,P-,Q-,R-,S-,T-,V-,W-,X+,Y+}
{$M 8192,1024}

interface

{ Hex utilities Written for BPW 7.0 }

type string15=string[15];
function hex2( decimal : word ) : string15;
function hex( decimal : word ) : string15;
function hexl( decimal : longint ) : string15;
function hex6( l:longint ):string15;
function hexls( decimal : longint ) : string15;
function hexad( ad:pointer ):string15;
const hex1 : array[0..15] of char = '0123456789abcdef';

implementation

function hex2( decimal : word ) : string15;
begin
     hex2[0] := chr(2);
     hex2[1] := hex1[ (decimal shr 4) and $f ];
     hex2[2] := hex1[ decimal and $f ];
end;

function hex( decimal : word ) : string15;
var i:integer;
begin
     hex[0] := chr(4);
     for i := 4 downto 1 do begin
         hex[i] := hex1[ decimal and $f ];
         decimal := decimal shr 4;
         end;
end;

function hexl( decimal : longint ) : string15;
var i:integer;
begin
     hexl[0] := chr(8);
     for i := 8 downto 1 do begin
         hexl[i] := hex1[ decimal and $f ];
         decimal := decimal shr 4;
         end;
end;

function hexls( decimal : longint ) : string15;
begin
     if decimal<=$ffff then hexls := hex(  decimal )
                       else hexls := hexl( decimal );
end;

function hex6(l:longint):string15;
var h:string15;
    i:integer;
begin
     h := hexl(l);
     for i := 1 to 2 do if h[1]='0' then delete(h,1,1);
     hex6 := h;
end;


function hexad( ad:pointer ):string15;
var l:longint;
    i:integer;
begin
     l := longint(ad);
     hexad[0] := chr(9);
     for i := 9 downto 1 do begin
         if i<>5 then begin
             hexad[i] := hex1[ l and $f ];
             l := l shr 4;
             end
         else hexad[i] := ':';
         end;
end;

end.