{ Contains TDOSDesktop and TDOSBackground - allow using DOS screen before program
  start up as background
  Written by Tim J. Duncan
  Compuserve 72603,3616
}
unit DOSBkGnd;

{}Interface{}

uses
  App,      {  Turbo Vision unit  }
  Crt,      {  Borland unit  }
  Drivers,  {  Turbo Vision unit  }
  MiscStr,  {  Contains miscellaneous string definitions and routines  }
  Objects,  {  Turbo Vision unit  }
  Video,    {  Contains routines and data to directly access video memory  }
  Views;    {  Turbo Vision unit  }


type
  {  Uses DOS screen before TV start up as background  }
  {  Must be used by TDOSDesktop only  }
  PDOSBackground = ^TDOSBackground;
  TDOSBackground =
    object (TBackground)
    constructor Init (var Bounds : TRect);
    procedure Draw; virtual;
    end;  {  of TBackground  }

  {  Uses TDOSBackground only  }
  PDOSDesktop = ^TDOSDesktop;
  TDOSDesktop =
    object (TDesktop)
    constructor Init;
    procedure InitBackground; virtual;
    end;  {  of TDOSDesktop  }

{  Saves a copy of video memory before calling TV's InitVideo  }
procedure InitVideoDOS;
{  Restores the previously saved copy of video memory after calling TV's DoneVideo  }
procedure DoneVideoDOS;

{}Implementation{}

{  Saves a copy of the contents of video memory before calling TV's InitVideo  }
procedure InitVideoDOS;
  begin
  SaveDOSScreen;
  InitVideo;
  end;  {  of procedure InitVideo2  }

{  Restores saved copy of video memory to video memory after TV's DoneVideo  }
procedure DoneVideoDOS;
  begin
  DoneVideo;
  UpdateDOSScreen;
  FreeVideoMemoryCopy;
  end;  {  of procedure DoneVideo2  }

{**Definition of methods for TDOSBackground**}

constructor TDOSBackground.Init
  (
  var Bounds : TRect  {  Input only  }
  );
  begin
  TView.Init (Bounds);
  GrowMode := gfGrowHiX + gfGrowHiY;
  end;  {  of constructor Init  }

procedure TDOSBackground.Draw;
  begin
  WriteBuf (0, 0, ScreenWidth, ScreenHeight, VideoMemoryCopy^);
  end;  {  of procedure Draw  }

{**Definition of methods for TDOSDesktop**}

constructor TDOSDesktop.Init;
  var
    R : TRect;
  begin
  {  Force TDesktop to control entire screen  }
  Application^.GetExtent (R);
  inherited Init (R);
  end;  {  of constructor Init  }

procedure TDOSDesktop.InitBackground;
  var
    R : TRect;
  begin
  GetExtent (R);
  Background := new (PDOSBackground, Init (R));
  end;  {  of procedure InitBackground  }

begin
end.  {  unit  }
