; ========================================================================= 
; OutFilt.Asm 1.1 by Robert Rothenburg Walking-Owl, 1994 Public Domain
; ========================================================================= 
; This routine is to be used with OutFilt.Pas: the WritePause procedure is
; passed a string.  If CopyToOutputFile is "true", WritePause writes the 
; string to the defined handle (DuplicateFile MUST be opened appropriately).
; if PauseBetweenScreens is "false", WritePause writes it directly to the
; screen (Handle 1 = StdOut) otherwise it writes each character separately,
; checking for LineFeed characters (ASCII 10): when 24 lines have been writ,
; a pause-message is displayed to the screen using BIOS Video (Int 10h).

DATA    SEGMENT BYTE PUBLIC

EXTRN PauseBetweenScreens: BYTE
EXTRN CopyOutputToFile:    BYTE
EXTRN DuplicateHandle:     WORD

DATA    ENDS

CODE    SEGMENT BYTE PUBLIC
        ASSUME  CS: CODE
        
        
        
        PUBLIC  WritePause
WritePause PROC    FAR
        push    bp                               ; set up stack frame
        mov     bp,     sp
        push    ds                               ; save data segment
        mov     al,     ds: [ CopyOutputToFile ] ; get CopyToOutputFile
        or      al,     al                       ; if not CopyToOutputFile,
        jz      NoCopy                           ;    skip "tee"
        lea     si,     DuplicateHandle          ; get DuplicateHandle
        mov     bx,     ds: [ si ]
        lds     si,     [ bp+06 ]                ; get address of Str
        mov     dx,     si
        inc     dx
        mov     cl,     ds: [ si ]               ; get Length(Str)
        xor     ch,     ch
        mov     ah,     40h                      ; Write to handle function
        int     21h                              ; call DOS...
        pop     ds                               ; restore data segment
        push    ds
NoCopy: mov     al,     ds: [ PauseBetweenScreens ]
        or      al,     al                       ; if not PauseBetweenScreen,
        jz      NoPauseWrite                     ; write it directly...
        lds     si,     [ bp+06 ]                ; get address of Str
        cld
        lodsb                                    ; get Length(Str)
        mov     cl,     al
        xor     ch,     ch
WriteLoop:
        lodsb                                    ; get character
        mov     dl,     al                       ; write char to StdOut
        mov     ah,     02
        int     21h
        call    CheckWrap
        or      al,     al
        jz      CheckLine
LineLp: loop    WriteLoop                        ; otherwise continue
        jmp     ByeUse                           ; exit...
CheckLine:        
        inc     word ptr cs: [ LineCount ]       ; increment line count
        cmp     word ptr cs: [ LineCount ], 24   ; 24 lines printed?
        jb      LineLp                           ; if not, get next char
        push    si                               ; save registers
        push    ds
        push    cx
        mov     ax,     cs
        mov     ds,     ax
        mov     dx,     offset PageMessage       ; output 'more' message
        call    WriteString
        xor     ah,     ah                       ; wait for a key
        int     16h                              ; keyboard interrupt
        push    ax                               ; save value
        mov     ax,     0920h                    ; erase 'more' message
        mov     bl,     07
        mov     cx,     79
        int     10h
        pop     ax                               ; restore value
        pop     cx                               ; restore registers
        pop     ds                         
        cmp     al,     'q'                      ; if 'q', Quit...
        je      QuitProgram
        cmp     al,     'Q'
        je      QuitProgram
        cmp     al,     ' '                      ; is it Space?
        jne     Norm                             ; 
        mov     word ptr cs: [ LineCount ], 1    ; if so, reset no. lines
Norm:   
        dec     word ptr cs: [ LineCount ]       ; decrement one line (Enter)
        pop     si                               ; restore index
        jmp     LineLp                           ; go back to char loop...
ByeUse: pop     ds                               ; restore data segment
        pop     bp
        retf    04                               ; exit procedure
QuitProgram:
        pop     ds
        pop     bp
        pop     ax                               ; clean stack
        pop     ax
        mov     ax, 4C01h                        ; exit to DOS
        int     21h

NoPauseWrite:                                    ; write line to StdOut
        lds     si,     [ bp+06 ]
        mov     cl,     ds: [ si ]
        xor     ch,     ch
        mov     dx,     si
        inc     dx
        mov     bx,     1                        ; StdOut
        mov     ah,     40h
        int     21h
        pop     ds
        pop     bp
        retf    04
PageMessage LABEL BYTE 
        db '-- more -- Hit Space for next screen, Enter for new line, '
        db '''Q'' to quit --',0
LineCount LABEL WORD 
        dw     0
WritePause ENDP

CheckWrap PROC NEAR        
        cmp     dl,     10
        jne     CheckForWrap
        xor     al,     al
        mov     dl,     al
        jmp     short   ChangeColumn
CheckForWrap:
        cmp     dl,     13
        jne     NotCarriage
        xor     al,     al
        mov     dl,     al
        jmp     short   NotLine
NotCarriage:
        mov     ah,     0Fh
        int     10h
        mov     bl,     ah
        dec     bl
        mov     ah,     03h
        push    cx
        int     10h
        pop     cx
        xor     al,     al
        or      dl,     dl
        jnz     NotLine
        cmp     bl,     byte ptr cs: [ LastColumn ]
        jne     NotLine
        cmp     dl,     byte ptr cs: [ LastColumn ]
        jb      ChangeColumn
NotLine:        
        not     al
ChangeColumn:
        mov     byte ptr cs: [ LastColumn ], dl
        retn
LastColumn LABEL BYTE
        db     0
CheckWrap ENDP

WriteString PROC NEAR
        push    si
        mov     ah,     0Fh
        int     10h
        mov     si,     dx
        cld
WriteSLoop:        
        lodsb
        or      al,     al
        jz      short   DoneWrite
        mov     ah,     09h
        mov     bl,     0Fh
        mov     cx,     1
        int     10h
        mov     ah,     03h
        int     10h
        inc     dl
        mov     ah,     02h
        int     10h
        jmp     short   WriteSLoop
DoneWrite:
        mov     ah,     03h
        int     10h
        xor     dl,     dl
        mov     ah,     02h
        int     10h
        pop     si
        retn
WriteString ENDP

CODE    ENDS
        END


