{  Demonstrates using TDOSDesktop  }
program Sample;

uses
  App,       { Turbo Vision unit  }
  Dialogs,   {  Turbo Vision unit  }
  Drivers,   {  Turbo Vision unit  }
  DOSBkGnd,  {  Contains definition of TDOSDesktop  }
  Memory,    {  Turbo Vision unit  }
  Objects,   {  Turbo Vision unit  }
  Views;     {  Turbo Vision unit  }

type

  TSampleApp =
    object  (TProgram)
    constructor Init;
    destructor Done; virtual;
    procedure InitDesktop; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    end;  {  of TOptionsApp  }

  PTestDialog = ^TTestDialog;
  TTestDialog =
    object (TDialog)
    constructor Init;
    procedure HandleEvent (var Event : TEvent); virtual;
    end;  {  of TTestDialog  }

{**Definition of TSampleApp object methods**}

constructor TSampleApp.Init;
  begin
  InitMemory;
  InitVideoDOS;  {  required - must use instead of InitVideo  }
  InitEvents;
  InitSysError;
  inherited Init;
  InsertWindow (new (PTestDialog, Init));
  end;  {  of constructor Init  }

destructor TSampleApp.Done;
  begin
  inherited Done;
  DoneSysError;
  DoneEvents;
  DoneVideoDOS;  {  required - must use instead of DoneVideo  }
  DoneMemory;
  end;  {  of destructor Done  }

procedure TSampleApp.InitDesktop;
  var
    R : TRect;
  begin
  GetExtent(R);
  Desktop := new (PDOSDesktop, Init);
  end;  {  of procedure InitDesktop  }

procedure TSampleApp.InitMenuBar;
  begin
  MenuBar := nil;
  end;  {  of procedure InitMenuBar  }

procedure TSampleApp.InitStatusLine;
  begin
  StatusLine := nil;
  end;  {  of procedure InitStatusLine  }

{**Definition of methods for TTestDialog**}

constructor TTestDialog.Init;
  var
    R : TRect;
  begin
  R.Assign (5, 10, 42, 17);
  inherited Init (R, 'Sample');

  R.Assign (4, 3, 35, 4);
  insert (new (PStaticText, Init (R, 'Press [ESC] to exit SampleApp')));
  end;  {  of constructor Init  }

procedure TTestDialog.HandleEvent
  (
  var Event : TEvent  {  Input and output  }
  );
  begin
  if (Event.What = evCommand) and (Event.Command = cmClose)
    then begin
    Event.Command := cmQuit;
    end;  {  if  }
  if (Event.What = evKeyDown) and (Event.Keycode = kbEsc)
    then begin
    Event.What := evCommand;
    Event.Command := cmQuit;
    end;  {  if  }
  inherited HandleEvent (Event);
  end;  {  of procedure HandleEvent  }

var
  SampleApp : TSampleApp;

begin
writeln ('Press [ESC] to exit SampleApp');
SampleApp.Init;
SampleApp.Run;
SampleApp.Done;
end.  {  of program  }