Unit PolarBox;
{ 7 July 94 }

{ This unit contains several drawing procedures, mainly to offload the
  main program. }

interface

uses Objects,
     OWindows,
     ODialogs,
     WinTypes,
     WinProcs,
     strings;

type pPolarBox = ^tPolarBox;
     TPolarBox = object(TButton)
     plotValue    : tpoint; {x is direction, y is velocity}
     range        : integer;
     oneknot      : real;
     r            : trect;
     center       : tpoint;
     Polarpos     : tpoint;
     bkColor      : tcolorref;
     function  GetClassName: PChar; virtual;
     procedure wmlbuttondown  (var msg: tmessage); virtual wm_first + wm_lbuttondown;
     procedure wmlbuttonup    (var msg: tmessage); virtual wm_first + wm_lbuttonup;
     procedure wmmousemove    (var msg: tmessage); virtual wm_first + wm_mousemove;
     procedure WMPaint        (var Msg: TMessage); virtual wm_First + wm_Paint;
     procedure DrawPolarBox;
     procedure GetPos(var aValue: tpoint);
     procedure setup(desiredRange: integer; xPlotValue: tpoint; abkcolor: tcolorref);
     procedure calcPlotValue(x,y: longint);
     end;


implementation
var buttonDown: boolean;


function tPolarbox.GetClassName: PChar;
begin
getclassname:= 'WINDBOX';
end;

procedure tPolarBox.GetPos(var aValue: tpoint);
begin
aValue:= plotValue;
end;

procedure tPolarBox.wmlbuttondown(var msg: tmessage);
begin
if (msg.lparamlo >= 0) and
   (msg.lparamlo <= r.right) and
   (msg.lparamhi >= 0) and
   (msg.lparamhi <= r.bottom) then
  begin
  buttondown:= true;
  setcapture(Hwindow);
  Polarpos.x := msg.lparamlo;
  Polarpos.y := msg.lparamhi;
  calcPlotValue (msg.lparamlo,msg.lparamhi);
  drawPolarBox;
  end;
defchildproc(msg);
end;


procedure tPolarBox.wmlbuttonup(var msg: tmessage);
begin
if buttondown then
  begin
  releasecapture;
  buttondown:= false;
  end;
defchildproc(msg);
end;

procedure tPolarBox.wmmousemove(var msg: tmessage);
begin
if (msg.lparamlo >= 0) and
   (msg.lparamlo <= r.right) and
   (msg.lparamhi >= 0) and
   (msg.lparamhi <= r.bottom) and
    buttondown then
  begin
  Polarpos.x := msg.lparamlo;
  Polarpos.y := msg.lparamhi;
  calcPlotValue(msg.lparamlo,msg.lparamhi);
  drawPolarBox;
  end;
defchildproc(msg);
end;


procedure tPolarBox.calcPlotValue(x,y: longint);
var x1,
    y1,
    z: real;
begin
x1:= abs(x-center.x);
y1:= abs(center.y-y);
if x1 = 0 then z:= 90;
if y1 = 0 then z:= 0;
if x1 <> 0 then z:=round(arctan(y1 / x1) * 57.296192);
if (x >= center.x) and (y <= center.y) then z:= 90 - z;
if (x >= center.x) and (y > center.y) then z:= z + 90;
if (x < center.x) and (y >= center.y) then z:= 270 - z;
if (x < center.x) and (y < center.y) then z:= 270 + z;
with plotvalue do
  begin
  x:= round(z) div 5 * 5; { direction }
  x:= x - 360;
  if x < 0 then x:= x + 360;
  end;
plotvalue.y:= round(sqrt(sqr((x - center.x) / oneknot) + sqr((y - center.y) / oneknot)));
end;

procedure tPolarbox.setup(desiredRange: integer; xPlotValue: tpoint; abkcolor: tcolorref);
begin
bkColor       := abkColor;
plotvalue     := xplotvalue;
range         := desiredRange;
buttonDown    := false;
with center do
  begin
  x:= 0;
  y:= 0;
  end;
Polarpos:= center;
with r do
  begin
  left    := 0;
  right   := 0;
  top     := 0;
  bottom  := 0;
  end;
end;

procedure tPolarBox.DrawPolarBox;
var circleRect : trect;
    textrect   : trect;
    oldRect    : trect;
    oldbitmap,
    copybitmap: hbitmap;
    dc,
    memdc      : hdc;
    count      : integer;
    textHigh   : integer;
    oldpen     : hpen;
    oldbrush   : hbrush;
    Polarbrush  : hbrush;
    wherebrush : hbrush;
    z          : real;
    oldclip,
    newclip    : hrgn;
    s,s1: array[0..100] of char;
    hdgptsa: array[0..36] of tpoint;
    hdgptsb: array[0..36] of tpoint;
    hdgptsc: array[0..12] of tpoint;

begin
{ set up tools for drawing }
dc       := getdc(hwindow);
MemDC    := CreateCompatibleDC(DC);
oldpen   := selectobject(memdc,getstockobject(black_pen));
oldbrush := selectobject(memdc,getstockobject(white_brush));
Polarbrush  := createsolidbrush(bkcolor);
wherebrush := createsolidbrush(rgb(255,0,0));
{ set up metrics for drawing }
getclientrect(hwindow,r);
CopyBitmap := CreateCompatibleBitmap(DC, r.right, r.bottom);
oldbitmap:= selectobject(memdc,copybitmap);
if r.right < r.bottom then oneknot := r.right  / (range+5) / 2
else                       oneknot := r.bottom / (range+5) / 2;
center.x := round(r.right / 2);
center.y := round(r.bottom / 2);
with circlerect do
  begin
  left   := center.x;
  right  := center.x;
  top    := center.y;
  bottom := center.y;
  end;
(** calculate the reticle heading mark coordinates **)
for count:= 0 to 36 do
  begin
  z:= count * 10 - 90;
  hdgptsa[count].x:= round(center.x + range * oneknot * cos(z/180*pi));
  hdgptsa[count].y:= round(center.y + range * oneknot * sin(z/180*pi));
  hdgptsb[count].x:= round(center.x +  (range-2) * oneknot  * cos(z/180*pi));
  hdgptsb[count].y:= round(center.y +  (range-2) * oneknot  * sin(z/180*pi));
  if count mod 3 = 0 then
    begin
    hdgptsc[count div 3].x:= round(center.x +  (range +2)* oneknot  * cos(z/180*pi));
    hdgptsc[count div 3].y:= round(center.y +  (range +2)* oneknot  * sin(z/180*pi));
    hdgptsb[count].x:= round(center.x +  10 * oneknot  * cos(z/180*pi));
    hdgptsb[count].y:= round(center.y +  10 * oneknot  * sin(z/180*pi));
    end;
  end;
{ set the clipping region }
getclipbox(memdc,oldrect);
oldclip:= createrectrgn(oldrect.left,oldrect.top,oldrect.right,oldrect.bottom);
newclip:= createrectrgn(r.left  ,
                        r.top   ,
                        r.right  ,
                        r.bottom );
selectcliprgn(memdc,newclip);
texthigh:= round(hiword(gettextextent(memdc,s1,1))/2);
{ do the drawing }
selectobject(memdc,Polarbrush);
with r do rectangle(memdc,left,top,right,bottom);

{ draw highllights }
selectobject(memdc,getstockobject(white_pen));
moveto(memdc,r.right - 2,1);
lineto(memdc,1,1);
lineto(memdc,1,r.bottom -1);
selectobject(memdc,getstockobject(black_pen));
lineto(memdc,r.right - 1,r.bottom -1);
lineto(memdc,r.right - 1 ,1);

selectobject(memdc,getstockobject(black_pen));
{ draw the azimuth text }
setbkmode(memdc,transparent);
for count:= 1 to 12 do
  begin
  with textrect do
    begin
    left   := hdgptsc[count].x - texthigh;
    right  := hdgptsc[count].x + texthigh;
    top    := hdgptsc[count].y - texthigh;
    bottom := hdgptsc[count].y + texthigh;
    end;
  str(count * 30,s);
  drawtext(memdc,s,strlen(s),textrect,dt_left);
  end;
{ draw the range circles }
selectobject(memdc,getstockobject(null_brush));
for count:= 1 to range div 10 do
  begin
  inflaterect(circlerect,round(oneknot * 10),round(oneknot * 10));
  with circlerect do ellipse(memdc,left,top,right,bottom);
  end;
{ draw the azimuth marks }
for count:= 1 to 36 do
  begin
  with hdgptsa[count] do moveto(memdc,x,y);
  with hdgptsb[count] do lineto(memdc,x,y);
  end;
{ draw a circle at the position of the Polar }
  str(plotvalue.x,s);
  str(plotvalue.y,s1);
  strcat(s,'/');
  strcat(s,s1);
  Polarpos.x:= round(center.x + plotvalue.y * oneknot * cos((plotvalue.x-90)/180*pi));
  Polarpos.y:= round(center.y + plotvalue.y * oneknot * sin((plotvalue.x-90)/180*pi));
selectobject(memdc,wherebrush);
with textrect do
  begin
  if Polarpos.x < center.x then left  := Polarpos.x + texthigh
  else                         left  := Polarpos.x - 7 * texthigh;
  if Polarpos.x < center.x then right := Polarpos.x + 7 * texthigh
  else                         right := Polarpos.x - texthigh;
  top    := Polarpos.y - texthigh;
  bottom := Polarpos.y + texthigh;
  end;
setbkmode(memdc,opaque);
with Polarpos do ellipse(memdc,x-texthigh,y-texthigh,x+texthigh,y+texthigh);
selectobject(memdc,Polarbrush);
with textrect do rectangle(memdc,left,top,right,bottom);
setbkmode(memdc,transparent);
drawtext(memdc,s,strlen(s),textrect,dt_left);
{ draw an x at the center }
with center do
  begin
  moveto(memdc, x - 5, y);
  lineto(memdc, x + 5, y);
  moveto(memdc, x, y + 5);
  lineto(memdc, x, y - 5);
  end;
BitBlt(DC, 0, 0, r.right, r.bottom, memDC, 0, 0, srcCopy);
{ clean up }
selectcliprgn(memdc,oldclip);
selectobject(memdc,oldpen);
selectobject(memdc,oldbitmap);
selectobject(memdc,oldbrush);
deleteobject(copybitmap);
deleteobject(oldclip);
deleteobject(Polarbrush);
deleteobject(wherebrush);
deleteobject(newclip);
releasedc(hwindow,dc);
deletedc(memdc);
end;

procedure tPolarBox.WMPaint(var Msg: TMessage);
begin
drawPolarBox;
defchildproc(msg);
end;


begin
end.