Unit DrawTime;

{ 3 July 94 }

{ This unit demonstates how to create an owner draw clock. To use this unit
  in your program, you must:

     1. Add DrawTime to your list of includes.
     2. Create an owner draw button in your program.
     3. Initialize a DrawTime button in your init method. }

interface

uses Objects,
     OWindows,
     ODialogs,
     WinTypes,
     WinProcs,
     strings,
     windos;

type pTimeBox = ^tTimeBox;
     TTimeBox = object(TButton)
     radius    : integer;
     r         : trect;
     center    : tpoint;
     function  GetClassName: PChar; virtual;
     procedure wmlbuttondown  (var msg: tmessage); virtual wm_first + wm_lbuttondown;
     procedure WMPaint        (var Msg: TMessage); virtual wm_First + wm_Paint;
     procedure DrawTimeBox;
     constructor InitResource(AParent: PWindowsObject; ResourceID:Word);
     destructor  Done; virtual;
     procedure WMTimer      (var Msg: TMessage); virtual wm_First + Wm_Timer;
     procedure setup;
     end;


implementation

destructor tTimeBox.Done;
begin
killtimer(hwindow,1);
TControl.Done;
end;


function getsystemtimeinseconds: longint;
var lhr,lmin,lsec: longint;
    hr,min,sec,hsec: word;
begin
GetTime(hr,min,sec,hsec);
lhr:= hr;
lmin:= min;
lsec:= sec;
getsystemtimeinseconds:= lsec + (lmin * 60) + (lhr * 3600);
end;

procedure tTimeBox.WMTimer      (var Msg: TMessage);
var x: longint;
    s: array[0..10] of char;
begin
case msg.wparam of
  1: begin
     x:= getsystemtimeinseconds;
     if x mod 60 = 0 then drawTimeBox;
     end;
  else end;
end;


constructor tTimeBox.InitResource(AParent: PWindowsObject; ResourceID:Word);
begin
tbutton.InitResource(AParent, ResourceID);
end;

procedure tTimeBox.setup;
begin
settimer(hwindow,1,1000,nil);
getclientrect(hwindow,r);
end;

function tTimebox.GetClassName: PChar;
begin
getclassname:= 'TIMEBOX';
end;


procedure tTimeBox.wmlbuttondown(var msg: tmessage);
var s: array [0..20] of char;
begin
strpcopy(s, 'Control.exe ');
winexec(s,sw_shownormal);
defchildproc(msg);
end;




procedure tTimeBox.DrawTimeBox;
var circleRect : trect;
    textrect   : trect;
    oldRect    : trect;
    oldbitmap,
    copybitmap: hbitmap;
    dc,
    memdc      : hdc;
    count      : integer;
    textHigh   : integer;
    oldpen     : hpen;
    hourpen     : hpen;
    oldbrush   : hbrush;
    windbrush  : hbrush;
    wherebrush : hbrush;
    z          : real;
    oldclip,
    newclip    : hrgn;
    s,s1: array[0..100] of char;
    hdgptsa: array[0..60] of tpoint;
    hdgptsb: array[0..60] of tpoint;
    hdgptsc: array[0..12] of tpoint;
    var hr,min,sec,hsec: word;

begin
{ set up tools for drawing }
GetTime(hr,min,sec,hsec);
dc       := getdc(hwindow);
MemDC    := CreateCompatibleDC(DC);
hourpen  := createpen(ps_solid,1,rgb(0,0,0));
oldpen   := selectobject(memdc,getstockobject(null_pen));
oldbrush := selectobject(memdc,getstockobject(white_brush));
wherebrush  := createsolidbrush(rgb(192,192,192));
windbrush := createsolidbrush(rgb(192,192,192));
{ set up metrics for drawing }
strpcopy(s1,'0');
texthigh:= round(hiword(gettextextent(memdc,s1,1)));
CopyBitmap := CreateCompatibleBitmap(DC, r.right, r.bottom);
oldbitmap:= selectobject(memdc,copybitmap);
if r.right < r.bottom then radius := round(r.right / 2) - 2
else                       radius := round(r.bottom / 2) - 2;
center.x := round(r.right  / 2);
center.y := round(r.bottom / 2);
with circlerect do
  begin
  left   := center.x;
  right  := center.x;
  top    := center.y;
  bottom := center.y;
  end;
(** calculate the reticle heading mark coordinates **)
for count:= 0 to 60 do
  begin
  z:= count * 6 - 90;
  hdgptsa[count].x:= round(center.x + radius * cos(z/180*pi));
  hdgptsa[count].y:= round(center.y + radius * sin(z/180*pi));
  hdgptsb[count].x:= round(center.x + (radius - 2) * cos(z/180*pi));
  hdgptsb[count].y:= round(center.y + (radius - 2) * sin(z/180*pi));
  end;
for count:= 0 to 12 do
  begin
  z:= count * 30 - 90;
  hdgptsc[count].x:= round(center.x +  (radius - 10)  * cos(z/180*pi));
  hdgptsc[count].y:= round(center.y +  (radius - 10 ) * sin(z/180*pi));
  end;
{ set the clipping region }
getclipbox(memdc,oldrect);
oldclip:= createrectrgn(oldrect.left,oldrect.top,oldrect.right,oldrect.bottom);
newclip:= createrectrgn(r.left  ,
                        r.top   ,
                        r.right  ,
                        r.bottom );
selectcliprgn(memdc,newclip);
{ do the drawing }
selectobject(memdc,windbrush);
with r do rectangle(memdc,left,top,right+1,bottom+1);
selectobject(memdc,wherebrush);
selectobject(memdc,getstockobject(black_pen));
with r do ellipse(memdc,left,top,right,bottom);
{ draw the hour marks }
for count:= 1 to 12 do
  begin
  with hdgptsa[count * 5] do moveto(memdc,x,y);
  with hdgptsb[count * 5] do lineto(memdc,x,y);
  end;
{
str(hr mod 12,s);
textout(memdc,1,1,s,strlen(s));
}
{ draw the hour mark }
with center do moveto(memdc,x,y);
selectobject(memdc,hourpen);
with hdgptsc[hr mod 12] do lineto(memdc,x,y);

{ draw the minute mark }
selectobject(memdc,getstockobject(black_pen));
with center do moveto(memdc,x,y);
with hdgptsb[min] do lineto(memdc,x,y);

BitBlt(DC, 0, 0, r.right, r.bottom, memDC, 0, 0, srcCopy);
{ clean up }
selectcliprgn(memdc,oldclip);
selectobject(memdc,oldpen);
selectobject(memdc,oldbitmap);
selectobject(memdc,oldbrush);
deleteobject(copybitmap);
deleteobject(oldclip);
deleteobject(windbrush);
deleteobject(wherebrush);
deleteobject(hourpen);
deleteobject(newclip);
releasedc(hwindow,dc);
deletedc(memdc);
end;

procedure tTimeBox.WMPaint(var Msg: TMessage);
begin
drawTimeBox;
defchildproc(msg);
end;

begin
end.