Unit MKMsgRG;       {Renegade Msg Unit}

{$I MKB.Def}
Interface

{
     MKMsgRG - Copyright 1994 by Ryan Thompson
     The BBS at Pooh Corner (707)445-0500 V32Bis/HST16.8 2 lines
     Fidonet: 1:125/37

     Modified from material Copyright 1993 by Mark May - MK Software
     You are free to use this code in your programs, however
     it may not be included in Source/TPU function libraries
     without my permission.

     Mythical Kingom Tech BBS (513)237-7737 HST/v32
     FidoNet: 1:110/290
     Rime: ->MYTHKING
     You may also reach me at maym@dmapub.dma.org
}


Uses
  MkMisc,
  MKGlobT,
  MKMsgAbs,
{$IFDEF WINDOWS}
  Strings,
  WinDos;
{$ELSE}
  Dos;
{$ENDIF}

Type
  netattr=
    (Private,
     Crash,
     Recd,
     NSent,
     FileAttach,
     Intransit,
     Orphan,
     KillSent,
     Local,
     Hold,
     Unused,
     FileRequest,
     ReturnReceiptRequest,
     IsReturnReceipt,
     AuditRequest,
     FileUpdateRequest);

  NetAttribs = set of netattr;

  msgstatusr=
    (mdeleted,
     sent,
     unvalidated,
     permanent,
     allowmci,
     netmail,
     prvt,
     forwarded);

  fromtoinfo=                  { from/to information for mheaderrec }
  record
    anon:byte;
    usernum:word;              { user number   }
    as:string[36];             { posted as     }
    real:string[36];           { real name     }
    name:string[36];           { system name   }
    addr:addrtype;
    (*
    zone,                      { Renegade Structs specificication }
    net,                       { lists them seperately }
    node,
    point:word;
    *)
  end;

  scanrec=                         { *.SCN files }
    record
      NewScan:boolean;             { Scan this base? }
      LastRead:longint;            { Last date read  }
    end;

  mheaderrec=
  record
     from,
     mto : fromtoinfo;               { message from/to info    }
     pointer:longint;                { starting record of text }
     textsize:word;                  { size of text            }
     replyto:word;                   { ORIGINAL + REPLYTO = CURRENT }
     date:longint;                   { date/time packed string }
     dayofweek:byte;                 { message day of week     }
     status:set of msgstatusr;       { message status flags    }
     replies:word;                   { times replied to        }
     subject:string[40];             { subject of message      }
     origindate:string[19];          { date of echo/group msgs }
     fileattached:byte;              { 0=No, 1=Yes&Del, 2=Yes&Save }
     netattribute:NetAttribs;        { Netmail attributes }
     res:array[1..2] of byte;        { reserved }
  end;

Const
  RGMsgLen = 16384;

Type RGMsgType = Record
  MsgPath : String[60];
  MsgHdrFile: File; { *.HDR }
  MsgTxtFile: File; { *.DAT }
  MsgScnFile: File; { *.SCN }
  Error : Integer;
  CurrMsg : Longint;
  MsgDone : Boolean;
  Found : Boolean;
  Name,
  Handle : string[40];
  DT : Datetime;
  TextCtr : Word;
  CurStrLoc : Word;
  CurStrPos : Byte;
  MsgHdr : mheaderrec;
  MsgChars : Array[0..RGMsgLen] of Char;
  End;


Type RGMsgObj = Object (AbsMsgObj)
  RGM: ^RGMsgType;
  Constructor Init; {Initialize}
  Destructor Done; Virtual; {Done}
  Procedure SetMsgPath(St: String); Virtual; {Set netmail path}
  Function  GetHighMsgNum: LongInt; Virtual; {Get highest netmail msg number in area}
  Procedure SetDest(Var Addr: AddrType); Virtual; {Set Zone/Net/Node/Point for Dest}
  Procedure SetOrig(Var Addr: AddrType); Virtual; {Set Zone/Net/Node/Point for Orig}
  Procedure SetFrom(Name: String); Virtual; {Set message from}
  Procedure SetTo(Name: String); Virtual; {Set message to}
  Procedure SetSubj(Str: String); Virtual; {Set message subject}
  Procedure SetCost(SCost: Word); Virtual; {Set message cost}
  Procedure SetRefer(SRefer: LongInt); Virtual; {Set message reference}
  Procedure SetSeeAlso(SAlso: LongInt); Virtual; {Set message see also}
  Procedure SetDate(SDate: String); Virtual; {Set message date}
  Procedure SetTime(STime: String); Virtual; {Set message time}
  Procedure SetLocal(LS: Boolean); Virtual; {Set local status}
  Procedure SetRcvd(RS: Boolean); Virtual; {Set received status}
  Procedure SetPriv(PS: Boolean); Virtual; {Set priveledge vs public status}
  Procedure SetCrash(SS: Boolean); Virtual; {Set crash netmail status}
  Procedure SetKillSent(SS: Boolean); Virtual; {Set kill/sent netmail status}
  Procedure SetSent(SS: Boolean); Virtual; {Set sent netmail status}
  Procedure SetFAttach(SS: Boolean); Virtual; {Set file attach status}
  Procedure SetReqRct(SS: Boolean); Virtual; {Set request receipt status}
  Procedure SetReqAud(SS: Boolean); Virtual; {Set request audit status}
  Procedure SetRetRct(SS: Boolean); Virtual; {Set return receipt status}
  Procedure SetFileReq(SS: Boolean); Virtual; {Set file request status}
  Procedure SetEcho(ES: Boolean); Virtual; {Set echo status}
  Procedure DoString(Str: String); Virtual; {Add string to message text}
  Procedure DoChar(Ch: Char); Virtual; {Add character to message text}
  Procedure DoStringLn(Str: String); Virtual; {Add string and newline to msg text}
  Function  WriteMsg: Word; Virtual; {Write msg to msg base}
  Function  GetChar: Char; Virtual; {Get msg text character}
  Function  GetString(MaxLen: Word): String; Virtual; {Get wordwrapped string}
  Procedure MsgStartUp; Virtual; {set up msg for reading}
  Function  EOM: Boolean; Virtual; {No more msg text}
  Function  WasWrap: Boolean; Virtual; {Last line was soft wrapped no CR}
  Procedure SeekFirst(MsgNum: LongInt); Virtual; {Seek msg number}
  Procedure SeekNext; Virtual; {Find next matching msg}
  Procedure SeekPrior; Virtual; {Seek prior matching msg}
  Function  GetFrom: String; Virtual; {Get from name on current msg}
  Function  GetTo: String; Virtual; {Get to name on current msg}
  Function  GetSubj: String; Virtual; {Get subject on current msg}
  Function  GetCost: Word; Virtual; {Get cost of current msg}
  Function  GetDate: String; Virtual; {Get date of current msg}
  Function  GetTime: String; Virtual; {Get time of current msg}
  Function  GetRefer: LongInt; Virtual; {Get reply to of current msg}
  Function  GetSeeAlso: LongInt; Virtual; {Get see also of current msg}
  Function  GetMsgNum: LongInt; Virtual; {Get message number}
  Procedure GetOrig(Var Addr: AddrType); Virtual; {Get origin address}
  Procedure GetDest(Var Addr: AddrType); Virtual; {Get destination address}
  Function  IsLocal: Boolean; Virtual; {Is current msg local}
  Function  IsCrash: Boolean; Virtual; {Is current msg crash}
  Function  IsKillSent: Boolean; Virtual; {Is current msg kill sent}
  Function  IsSent: Boolean; Virtual; {Is current msg sent}
  Function  IsFAttach: Boolean; Virtual; {Is current msg file attach}
  Function  IsReqRct: Boolean; Virtual; {Is current msg request receipt}
  Function  IsReqAud: Boolean; Virtual; {Is current msg request audit}
  Function  IsRetRct: Boolean; Virtual; {Is current msg a return receipt}
  Function  IsFileReq: Boolean; Virtual; {Is current msg a file request}
  Function  IsRcvd: Boolean; Virtual; {Is current msg received}
  Function  IsPriv: Boolean; Virtual; {Is current msg priviledged/private}
  Function  IsDeleted: Boolean; Virtual; {Is current msg deleted}
  Function  IsEchoed: Boolean; Virtual; {Msg should be echoed}
  Function  GetMsgLoc: LongInt; Virtual; {Msg location}
  Procedure SetMsgLoc(ML: LongInt); Virtual; {Msg location}
  Procedure YoursFirst(Name: String; Handle: String); Virtual; {Seek your mail}
  Procedure YoursNext; Virtual; {Seek next your mail}
  Function  YoursFound: Boolean; Virtual; {Message found}
  Procedure StartNewMsg; Virtual;
  Function  OpenMsgBase: Word; Virtual;
  Function  CloseMsgBase: Word; Virtual;
  Function  CreateMsgBase(MaxMsg: Word; MaxDays: Word): Word; Virtual;
  Function  SeekFound: Boolean; Virtual;
  Procedure SetMailType(MT: MsgMailType); Virtual; {Set message base type}
  Function  GetSubArea: Word; Virtual; {Get sub area number}
  Procedure ReWriteHdr; Virtual; {Rewrite msg header after changes}
  Procedure DeleteMsg; Virtual; {Delete current message}
  Function  NumberOfMsgs: LongInt; Virtual; {Number of messages}
  Function  GetLastRead(UNum: LongInt): LongInt; Virtual; {Get last read for user num}
  Procedure SetLastRead(UNum: LongInt; LR: LongInt); Virtual; {Set last read}
  Procedure MsgTxtStartUp; Virtual; {Do message text start up tasks}
  Function  GetTxtPos: LongInt; Virtual; {Get indicator of msg text position}
  Procedure SetTxtPos(TP: LongInt); Virtual; {Set text position}
  Procedure SetMsgAttr(attr : netattr); {Set netattr}
  Function  MsgBaseExists: Boolean; Virtual;
  End;


Type RGMsgPtr = ^RGMsgObj;


Implementation


Uses MKFile, MKString, MKDos, Crc32;


Constructor RGMsgObj.Init;
  Begin
  New(RGm);
  If RGm = Nil Then
    Begin
    Fail;
    Exit;
    End;
  RGM^.TextCtr:= 0;
  End;


Destructor RGMsgObj.Done;
  Begin
  Dispose(RGM);
  End;


Procedure RGMsgObj.SetMsgPath(St: String);
  Var
    ANum: Word;
  Begin
    rgm^.msgpath:= st;
  End;


Function RGMsgObj.GetHighMsgNum: LongInt;
  Var
    ANum: Word;

  Begin
  GetHighMsgNum:= SizeFile(RGM^.MsgPath + '.HDR') Div SizeOf(MHeaderRec);
  End;


Procedure RGMsgObj.SetDest(Var Addr: AddrType);
  Begin
  RGM^.MsgHdr.mto.Addr:= Addr;
  End;


Procedure RGMsgObj.SetOrig(Var Addr: AddrType);
  Begin
  RGM^.MsgHdr.from.Addr:= Addr;
  End;


Procedure RGMsgObj.SetFrom(Name: String);
  Begin
  RGM^.MsgHdr.from.as:= Name;
  RGM^.MsgHdr.from.real:= Name;
  RGM^.MsgHdr.from.name:= Name;
  End;


Procedure RGMsgObj.SetTo(Name: String);
  Begin
  RGM^.MsgHdr.mto.as:= Name;
  RGM^.MsgHdr.mto.real:= Name;
  RGM^.MsgHdr.mto.name:= Name;
  End;


Procedure RGMsgObj.SetSubj(Str: String);
  Begin
  RGM^.MsgHdr.Subject:= Str;
  End;


Procedure RGMsgObj.SetCost(SCost: Word);
  Begin
  End;


Procedure RGMsgObj.SetRefer(SRefer: LongInt);
  Begin
  RGM^.MsgHdr.ReplyTo:= SRefer and $ffff;
  End;


Procedure RGMsgObj.SetSeeAlso(SAlso: LongInt);
  Begin
  End;


Procedure RGMsgObj.SetDate(SDate: String);
  var
    temp : string[2];
    code : integer;
  Begin
    temp:= copy(SDate, 1, 2);
    val(temp, RGM^.dt.month, code);
    temp:= copy(SDate, 4, 2);
    val(temp, RGM^.dt.day, code);
    temp:= copy(SDate, 7, 2);
    val(temp, RGM^.dt.year, code);
    RGM^.dt.year:= RGM^.dt.year + 1900;
    if rgm^.dt.hour >= 24 then RGM^.dt.hour:= 0;
    if rgm^.dt.min >= 60 then RGM^.dt.min:= 0;
    if rgm^.dt.sec >= 60 then RGM^.dt.sec:= 0;
    RGM^.msghdr.Date:= DTtoUnixDate(RGM^.dt);
  End;


Procedure RGMsgObj.SetTime(STime: String);
  var
    temp : string[2];
    code : integer;
  Begin
    temp:= copy(STime, 1, 2);
    val(temp, RGM^.dt.Hour, code);
    temp:= copy(STime, 4, 2);
    val(temp, RGM^.dt.Min, code);
    RGM^.DT.sec:= 0;
    RGM^.msghdr.Date:= DTtoUnixDate(RGM^.dt);
  End;


Procedure RGMsgObj.SetMsgAttr(attr : netattr); {Set netattr}
  Begin
    include(RGM^.msghdr.netattribute, attr);
  End;


Procedure RGMsgObj.SetLocal(LS: Boolean);
  Begin
    SetMsgAttr(local);
  End;


Procedure RGMsgObj.SetRcvd(RS: Boolean);
  Begin
    SetMsgAttr(recd);
  End;


Procedure RGMsgObj.SetPriv(PS: Boolean);
  Begin
  SetMsgAttr(Private);
  End;


Procedure RGMsgObj.SetCrash(SS: Boolean);
  Begin
  SetMsgAttr(Crash);
  End;


Procedure RGMsgObj.SetKillSent(SS: Boolean);
  Begin
  SetMsgAttr(KillSent);
  End;


Procedure RGMsgObj.SetSent(SS: Boolean);
  Begin
  SetMsgAttr(NSent);
  End;


Procedure RGMsgObj.SetFAttach(SS: Boolean);
  Begin
  SetMsgAttr(FileAttach);
  End;


Procedure RGMsgObj.SetReqRct(SS: Boolean);
  Begin
  SetMsgAttr(ReturnReceiptRequest);
  End;


Procedure RGMsgObj.SetReqAud(SS: Boolean);
  Begin
  setmsgattr(auditrequest);
  End;


Procedure RGMsgObj.SetRetRct(SS: Boolean);
  Begin
  SetMsgAttr(IsReturnReceipt);
  End;


Procedure RGMsgObj.SetFileReq(SS: Boolean);
  Begin
  SetMsgAttr(FileRequest);
  End;


Procedure RGMsgObj.DoString(Str: String);
  Var
    i: Word;

  Begin
  i := 1;
  While i <= Length(Str) Do
    Begin
    DoChar(Str[i]);
    Inc(i);
    End;
  End;


Procedure RGMsgObj.DoChar(Ch: Char);
  Begin
  If RGM^.TextCtr < SizeOf(RGM^.MsgChars) Then
    Begin
      if (ch = #$0d) or (RGM^.CurStrPos = 255) then begin
        RGM^.CurStrLoc:= RGM^.TextCtr;
        RGM^.MsgChars[RGM^.CurStrLoc]:= #0;
        RGM^.CurStrPos:= 1;
        Inc(RGM^.TextCtr);
      end;
      if (ch <> #$0d) then begin
        RGM^.MsgChars[RGM^.TextCtr]:= Ch;
        Inc(RGM^.TextCtr);
        inc(RGM^.CurStrPos);
        inc(RGM^.MsgChars[RGM^.CurStrLoc]);
      end;
    End;
  End;


Procedure RGMsgObj.DoStringLn(Str: String);
  Begin
  DoString(Str);
  DoChar(#$0d);
  End;


Function  RGMsgObj.WriteMsg: Word;

  Var
    {$IFDEF WINDOWS}
    TmpDT: TDateTime;
    {$ELSE}
    TmpDT: DateTime;
    {$ENDIF}
    MsgExport: Boolean;
    MsgExportFile: File;
    MsgCount: Word;
    MsgCountFile: File;
    i: Word;
    NumRead: Word;

  Begin
  DoChar(#0);
  FileMode := fmReadWrite + fmDenyWrite;
  If shReset(RGM^.MsgTxtFile, 1) Then
    Begin
    RGM^.MsgHdr.Pointer:= FileSize(RGM^.MsgTxtFile) + 1;
    Seek(RGM^.MsgTxtFile, RGM^.MsgHdr.Pointer - 1);
    RGM^.Error:= IoResult;
    RGM^.MsgHdr.TextSize := RGM^.TextCtr;
    If RGM^.Error = 0 Then
      Begin
      BlockWrite(RGM^.MsgTxtFile, RGM^.MsgChars, RGM^.TextCtr);
      RGM^.Error := IoResult;
      End;
    If RGM^.Error = 0 Then
      Begin
      Seek(RGM^.MsgHdrFile, FileSize(RGM^.MsgHdrFile));
      RGM^.Error := IoResult;
      End;
    If RGM^.Error = 0 Then
      Begin
      BlockWrite(RGM^.MsgHdrFile, RGM^.MsgHdr, 1);
      RGM^.Error:= IoResult;
      RGM^.CurrMsg:= FileSize(RGM^.MsgHdrFile);
      End;
    If RGM^.Error = 0 Then
      Begin
      Close(RGM^.MsgTxtFile);
      RGM^.Error := IoResult;
      End;
    End
  Else
    RGM^.Error := 5;
  WriteMsg := RGM^.Error;
  End;


Function RGMsgObj.GetChar: Char;
  Begin
  If ((RGM^.TextCtr >= RGM^.MsgHdr.TextSize)
  Or (RGM^.TextCtr >= RGMsgLen)) Then
    Begin
    GetChar:= #0;
    RGM^.MsgDone:= True;
    End
  Else
    Begin
      if RGM^.CurStrPos > ord(RGM^.MsgChars[RGM^.CurStrLoc]) then begin
        RGM^.CurStrLoc:= RGM^.TextCtr;
        inc(RGM^.textctr);
        RGM^.CurStrPos:= 1;
        GetChar:= #$0a;
      end
      else begin
        GetChar:= RGM^.MsgChars[RGM^.TextCtr];
        Inc(RGM^.TextCtr);
        inc(RGM^.CurStrPos);
      end;
    End;
  End;


Function RGMsgObj.GetString(MaxLen: Word): String;
  Var
    WPos: LongInt;
    WLen: Byte;
    StrDone: Boolean;
    TxtOver: Boolean;
    StartSoft: Boolean;
    CurrLen: Word;
    PPos: LongInt;
    TmpCh: Char;
    OldPos: LongInt;
  Begin
  If EOM Then
    GetString := ''
  Else
    Begin
    StrDone:= False;
    CurrLen:= 0;
    PPos:= GetTxtPos;
    WPos:= GetTxtPos;
    WLen:= 0;
    StartSoft:= LastSoft;
    LastSoft:= True;
    OldPos:= GetTxtPos;
    TmpCh:= GetChar;
    While ((Not StrDone) And (CurrLen < MaxLen) And (Not EOM)) Do
      Begin
      Case TmpCh of
        #$00:;
        #$0d: Begin
              StrDone := True;
              LastSoft := False;
              End;
        #$8d:;
        #$0a:;
        #$20: Begin
              If ((CurrLen <> 0) or (Not StartSoft)) Then
                Begin
                Inc(CurrLen);
                WLen := CurrLen;
                GetString[CurrLen] := TmpCh;
                WPos := GetTxtPos;
                End
              Else
                StartSoft := False;
              End;
        Else
          Begin
          Inc(CurrLen);
          GetString[CurrLen] := TmpCh;
          End;
        End;
      If Not StrDone Then
        Begin
        OldPos := GetTxtPos;
        TmpCh := GetChar;
        End;
      End;
    If StrDone Then
      Begin
      GetString[0] := Chr(CurrLen);
      End
    Else
      If EOM Then
        Begin
        GetString[0] := Chr(CurrLen);
        End
      Else
        Begin
        If WLen = 0 Then
          Begin
          GetString[0] := Chr(CurrLen);
          SetTxtPos(OldPos);
          End
        Else
          Begin
          GetString[0] := Chr(WLen);
          SetTxtPos(WPos);
          End;
        End;
    End;
  End;


Procedure RGMsgObj.MsgStartUp;
  Var
    NumRead: Word;
  Begin
  If (RGM^.CurrMsg > 0) and (RGM^.CurrMsg <= FileSize(RGM^.MsgHdrFile)) Then
    Begin
    LastSoft := False;
    RGM^.MsgDone := False;
    Seek(RGM^.MsgHdrFile, RGM^.CurrMsg - 1);
    RGM^.Error := IoResult;
    If RGM^.Error = 0 Then
      Begin
        BlockRead(RGM^.MsgHdrFile, RGM^.MsgHdr, 1, NumRead);
        RGM^.Error := IoResult;
        UnixToDT(RGM^.msghdr.date, RGM^.DT);
      End;
    End;
  End;


Procedure RGMsgObj.MsgTxtStartUp;
  Var
    NumRead: Word;
  Begin
  If ((RGM^.MsgHdr.Pointer >= 0) and
     (RGM^.MsgHdr.Pointer <= FileSize(RGM^.MsgTxtFile)))
  Then Begin
    RGM^.Error:= 0;
    RGM^.TextCtr:= 1;
    RGM^.CurStrLoc:= 0;
    RGM^.CurStrPos:= 1;
    RGM^.MsgDone := False;
    FillChar(RGM^.MsgChars, SizeOf(RGM^.MsgChars), #0);
    Seek(RGM^.MsgTxtFile, RGM^.Msghdr.Pointer - 1);
    RGM^.Error := IoResult;
    If RGM^.Error = 0 Then
      Begin
       If RGM^.MsgHdr.TextSize > RGMsgLen Then
        BlockRead(RGM^.MsgTxtFile, RGM^.MsgChars, RGM^.MsgHdr.TextSize, NumRead)
      Else
        BlockRead(RGM^.MsgTxtFile, RGM^.MsgChars, RGMsgLen, NumRead);
      RGM^.Error := IoResult;
      End;
    LastSoft := False;
    End
  Else
    Begin
    RGM^.Error := 400;
    End;
  End;


Function RGMsgObj.EOM: Boolean;
  Begin
  EOM := RGM^.MsgDone;
  End;


Function RGMsgObj.WasWrap: Boolean;
  Begin
  WasWrap := LastSoft;
  End;


Function RGMsgObj.GetFrom: String; {Get from name on current msg}
  Begin
  GetFrom := RGM^.MsgHdr.From.as;
  End;


Function RGMsgObj.GetTo: String; {Get to name on current msg}
  Begin
  GetTo := RGM^.MsgHdr.mto.as;
  End;


Function RGMsgObj.GetSubj: String; {Get subject on current msg}
  Begin
  GetSubj := RGM^.MsgHdr.Subject;
  End;


Function RGMsgObj.GetCost: Word; {Get cost of current msg}
  Begin
  GetCost:= 0;
  End;


Function RGMsgObj.GetDate: String; {Get date of current msg}
  var
    date : longint;
  Begin
  PackTime(RGM^.dt, date);
  GetDate:= DateStr(date);
  End;


Function RGMsgObj.GetTime: String; {Get time of current msg}
  var
    date : longint;
  Begin
  packtime(RGM^.dt, date);
  GetTime:= Copy(TimeStr(Date), 1, 5);
  End;


Function RGMsgObj.GetRefer: LongInt; {Get reply to of current msg}
  Begin
  GetRefer := RGM^.MsgHdr.ReplyTo;
  End;


Function RGMsgObj.GetSeeAlso: LongInt; {Get see also of current msg}
  Begin
  GetSeeAlso := RGM^.MsgHdr.replyto;
  End;


Function RGMsgObj.GetMsgNum: LongInt; {Get message number}
  Begin
  GetMsgNum := RGM^.CurrMsg;
  End;


Procedure RGMsgObj.GetOrig(Var Addr: AddrType); {Get origin address}
  Begin
  Addr:= RGM^.MsgHdr.from.addr;
  End;


Procedure RGMsgObj.GetDest(Var Addr: AddrType); {Get destination address}
  Begin
  Addr:= RGM^.MsgHdr.mto.addr;
  End;


Function RGMsgObj.IsLocal: Boolean; {Is current msg local}
  Begin
  IsLocal:= (local in RGM^.MsgHdr.netattribute);
  End;


Function RGMsgObj.IsCrash: Boolean; {Is current msg crash}
  Begin
  IsCrash:= (crash in RGM^.MsgHdr.NetAttribute);
  End;


Function RGMsgObj.IsKillSent: Boolean; {Is current msg kill sent}
  Begin
  IsKillSent:= (killsent in RGM^.MsgHdr.NetAttribute);
  End;


Function RGMsgObj.IsSent: Boolean; {Is current msg sent}
  Begin
  IsSent := (nsent in RGM^.MsgHdr.NetAttribute);
  End;


Function RGMsgObj.IsFAttach: Boolean; {Is current msg file attach}
  Begin
  IsFAttach:= (FileAttach in RGM^.MsgHdr.NetAttribute);
  End;


Function RGMsgObj.IsReqRct: Boolean; {Is current msg request receipt}
  Begin
  IsReqRct:= (ReturnReceiptRequest in RGM^.MsgHdr.NetAttribute);
  End;


Function RGMsgObj.IsReqAud: Boolean; {Is current msg request audit}
  Begin
  IsReqAud:= (auditrequest in RGM^.MsgHdr.NetAttribute);
  End;


Function RGMsgObj.IsRetRct: Boolean; {Is current msg a return receipt}
  Begin
  IsRetRct:= (isReturnReceipt in RGM^.MsgHdr.NetAttribute);
  End;


Function RGMsgObj.IsFileReq: Boolean; {Is current msg a file request}
  Begin
  IsFileReq:= (FileRequest in RGM^.MsgHdr.NetAttribute);
  End;


Function RGMsgObj.IsRcvd: Boolean; {Is current msg received}
  Begin
  IsRcvd:= (recd in RGM^.MsgHdr.netAttribute);
  End;


Function RGMsgObj.IsPriv: Boolean; {Is current msg priviledged/private}
  Begin
  IsPriv:= (private in RGM^.MsgHdr.NetAttribute);
  End;


Function RGMsgObj.IsDeleted: Boolean; {Is current msg deleted}
  Begin
  IsDeleted:= (mdeleted in RGM^.MsgHdr.status);
  End;


Function RGMsgObj.IsEchoed: Boolean; {Is current msg echoed}
  Begin
    IsEchoed:= not (nsent in RGM^.MsgHdr.netAttribute);
  End;


Procedure RGMsgObj.SetEcho(ES: Boolean);
  Begin
  setmsgattr(nsent);
  End;


Procedure RGMsgObj.SeekFirst(MsgNum: LongInt); {Start msg seek}
  Begin
  RGM^.CurrMsg := MsgNum - 1;
  SeekNext;
  End;


Procedure RGMsgObj.SeekNext; {Find next matching msg}
  Begin
  RGM^.Found:= True;
  If RGM^.CurrMsg < FileSize(RGM^.MsgHdrFile) Then
    Inc(RGM^.CurrMsg)
  Else
    RGM^.Found := False;
  End;


Procedure RGMsgObj.SeekPrior;
  Begin
  If RGM^.CurrMsg > 0 Then
    Begin
    Dec(RGM^.CurrMsg);
    End;
  If RGM^.CurrMsg <= 0 Then
    RGM^.Found := False;
  End;


Function RGMsgObj.SeekFound: Boolean;
  Begin
  SeekFound := RGM^.Found;
  End;


Function RGMsgObj.GetMsgLoc: LongInt; {Msg location}
  Begin
  GetMsgLoc := GetMsgNum;
  End;


Procedure RGMsgObj.SetMsgLoc(ML: LongInt); {Msg location}
  Begin
  RGM^.CurrMsg := ML;
  End;


Procedure RGMsgObj.YoursFirst(Name: String; Handle: String);
  Begin
  RGM^.Name := Upper(Name);
  RGM^.Handle := Upper(Handle);
  RGM^.CurrMsg := 0;
  YoursNext;
  End;


Procedure RGMsgObj.YoursNext;
  Var
    FoundDone: Boolean;
    MaxSize: LongInt;

  Begin
  FoundDone := False;
  MaxSize := GetHighMsgNum;
  Inc(RGM^.CurrMsg);
  SeekFirst(RGM^.CurrMsg);
  While ((RGM^.CurrMsg <= MaxSize) And (Not FoundDone)) Do
    Begin
    MsgStartUp;
    If ((Upper(GetTo) = RGM^.Name) Or (Upper(GetTo) = RGM^.Handle)) Then
      FoundDone := True;
    If IsRcvd Then FoundDone := False;
    If Not FoundDone Then
      SeekNext;
    If Not SeekFound Then
      FoundDone := True;
    End;
  End;


Function RGMsgObj.YoursFound: Boolean;
  Begin
  YoursFound := SeekFound;
  End;


Procedure RGMsgObj.StartNewMsg;
  Begin
    FillChar(RGM^.MsgChars, SizeOf(RGM^.MsgChars), #0);
    FillChar(RGM^.MsgHdr, SizeOf(RGM^.MsgHdr), 0);
    RGM^.TextCtr:= 1;
    RGM^.CurStrLoc:= 0;
    RGM^.CurStrPos:= 1;
  End;


Function RGMsgObj.OpenMsgBase: Word;
  Begin
  RGM^.Error := 0;
  If Not FileExist(RGM^.MsgPath + '.HDR') Then
    If CreateMsgBase(0,0) = 0 Then;
  Assign(RGM^.MsgHdrFile, RGM^.MsgPath + '.HDR');
  Assign(RGM^.MsgTxtFile, RGM^.MsgPath + '.DAT');
  Assign(RGM^.MsgScnFile, RGM^.MsgPath + '.SCN');
  FileMode := fmReadWrite + fmDenyNone;
  Reset(RGM^.MsgHdrFile, SizeOf(RGM^.MsgHdr));
  RGM^.Error:= IoResult;
  If RGM^.Error = 0 Then
    Begin
    FileMode := fmReadOnly + fmDenyNone;
    Reset(RGM^.MsgTxtFile, 1);
    RGM^.Error := IoResult;
    End;
  If RGM^.Error = 0 Then
    Begin
    FileMode := fmReadOnly + fmDenyNone;
    Reset(RGM^.MsgScnFile, sizeof(scanrec));
    RGM^.Error := IoResult;
    End;
  If RGM^.Error <> 0 Then
    Begin
    Close(RGM^.MsgTxtFile);
    If IoResult <> 0 Then;
    Close(RGM^.MsgHdrFile);
    If IoResult <> 0 Then;
    Close(RGM^.MsgScnFile);
    If IoResult <> 0 Then;
    End;
  OpenMsgBase := RGM^.Error;
  End;


Function RGMsgObj.CloseMsgBase: Word;
  Begin
  If IoResult <> 0 Then;
  Close(RGM^.MsgHdrFile);
  If IoResult <> 0 Then;
  Close(RGM^.MsgTxtFile);
  If IoResult <> 0 Then;
  End;


Function RGMsgObj.CreateMsgBase(MaxMsg: Word; MaxDays: Word): Word;

  Var
    HdrFile: File;
    TxtFile: File;
    ScnFile: File;
  Begin
  Assign(HdrFile, RGM^.MsgPath + '.HDR');
  Assign(TxtFile, RGM^.MsgPath + '.DAT');
  Assign(ScnFile, RGM^.MsgPath + '.SCN');
  ReWrite(HdrFile);
  RGM^.Error := IoResult;
  If RGM^.Error = 0 Then
    Begin
    ReWrite(TxtFile);
    RGM^.Error := IoResult;
    End;
  If RGM^.Error = 0 Then
    Begin
    ReWrite(ScnFile);
    RGM^.Error := IoResult;
    End;
  Close(HdrFile);
  If IoResult <> 0 Then;
  Close(TxtFile);
  If IoResult <> 0 Then;
  Close(ScnFile);
  If IoResult <> 0 Then;
  CreateMsgBase := RGM^.Error;
  End;


Procedure RGMsgObj.SetMailType(MT: MsgMailType);
  Begin
  End;


Function RGMsgObj.GetSubArea: Word;
  Begin
  GetSubArea:= 0;
  End;


Procedure RGMsgObj.ReWriteHdr;
  Begin
  If ((RGM^.CurrMsg > 0) and (RGM^.CurrMsg <= FileSize(RGM^.MsgHdrFile))) Then
    Begin
    Seek(RGM^.MsgHdrFile, RGM^.CurrMsg - 1);
    RGM^.Error := IoResult;
    If RGM^.Error = 0 Then
      Begin
      BlockWrite(RGM^.MsgHdrFile, RGM^.MsgHdr, 1);
      RGM^.Error := IoResult;
      End;
    End;
  End;


Procedure RGMsgObj.DeleteMsg;
  Begin
  include(rgm^.msghdr.status, mDeleted);
  ReWriteHdr;
  End;


Function RGMsgObj.NumberOfMsgs: LongInt;
  Begin
  NumberOfMsgs := FileSize(RGM^.MsgHdrFile);
  End;



Function RGMsgObj.GetLastRead(UNum: LongInt): LongInt;
  Var
    LR: scanrec;
    Position: LongInt;
  Begin
    If IoResult <> 0 Then;
    Seek(RGM^.MsgScnFile, Unum);
    If IoResult <> 0 Then;
    BlockRead(RGM^.MsgScnFile, LR, sizeof(scanrec));
    If IoResult <> 0 Then;
    GetLastRead:= LR.lastread;
  End;


Procedure RGMsgObj.SetLastRead(UNum: LongInt; LR: LongInt);
  Var
    Last: scanrec;
    Position: LongInt;
  Begin
    If IoResult <> 0 Then;
    Seek(RGM^.MsgScnFile, Unum);
    If IoResult <> 0 Then;
    BlockRead(RGM^.MsgScnFile, Last, sizeof(scanrec));
    If IoResult <> 0 Then;
    Last.lastread:= LR;
    BlockWrite(RGM^.MsgScnFile, Last, sizeof(scanrec));
    If IoResult <> 0 Then;
  End;


Function RGMsgObj.GetTxtPos: LongInt;
  Begin
  GetTxtPos:= RGM^.TextCtr + longint(RGM^.CurStrLoc) shl 16;
  End;


Procedure RGMsgObj.SetTxtPos(TP: LongInt);
  Begin
  RGM^.TextCtr:= TP and $ffff;
  RGM^.CurStrLoc:= TP shr 16;
  RGM^.CurStrPos:= RGM^.TextCtr - RGM^.CurStrLoc;
  End;


Function RGMsgObj.MsgBaseExists: Boolean;
  Begin
  MsgBaseExists:= FileExist(RGM^.MsgPath + '.HDR') and
                  FileExist(RGM^.MsgPath + '.DAT');
  End;

End.
