Unit GraphPRN;  { Use HardCopy(6) for screen circle to printer circle }

Interface

Uses Graph,         { Used to get the Image from the Screen }
     Printer2;      { Used to circumvent DOS's striping of  }
                    { $1A = ^Z from output stream ( a MUST  }
                    { for Graphics output!                  }

Procedure HardCopy (Gmode: Integer);
{ Procedure HardCopy prints the current ViewPort        }
{   to an IBM or Epson compatible printer.              }
{                                                       }
{ Valid Gmode numbers are :                             }
{     -4 to -1 for Epson and IBM Graphic Printers       }
{      0 to 7 for Epson Printers                        }

Implementation

Procedure HardCopy(Gmode : Integer);

Const
   Bits : Array [0..7] of Byte = (128,64,32,16,8,4,2,1);

Var
   X,Y,YOfs           : Integer;
   BitData,MaxBits    : Byte;
   Vport              : ViewPortType;
   Height,Width       : Word;
   HIBit,LoBit        : Char;
   LineSpacing,
   GraphPrefix        : String[10];

Begin
  LineSpacing := #27+'3'+#24;  { 24/216 inch line spacing     }
  Case Gmode of
       -1: GraphPrefix := #27+'K'; { Std. Density             }
       -2: GraphPrefix := #27+'L'; { Double Density           }
       -3: GraphPrefix := #27+'Y'; { Dbl. Density, Dbl. Speed }
       -4: GraphPrefix := #27+'Z'; { Quad. Density            }
     0..7: GraphPrefix := #27+'*'+Chr(Gmode); { 8-Pin Bit Img }
    Else
     Exit;
  End;
  GetViewSettings ( Vport );
  Height := Vport.Y2-Vport.Y1;
  Width := Vport.X2-Vport.X1+1;  { added +1 to # cols for printing to }
  HiBit := Chr(Hi(Width));       { make room for right vertical boundary, }
  LoBit := Chr(Lo(Width));       { otherwise rectangle(0,0,GetMaxX,GetMaxY }
  Write( Lst, LineSpacing );     { max border will print with no right on box }
  Y := 0;
  While Y < Height Do
  Begin
     Write ( Lst,GraphPrefix,LoBit,HiBit );
     For X := 0 to Width-1 Do
     Begin
        BitData := 0;
        If Y + 7 <= Height
          Then MaxBits := 7
        Else
          MaxBits :=Height - Y;
        For YOfs := 0 to MaxBits Do
        Begin
          If GetPixel ( X, YOfs+Y ) > 0
             Then BitData := BitData or Bits[YOfs];
        End;
        Write( Lst, Chr(BitData) );
     End;
     Writeln ( Lst );
     Inc(Y,8);
  End;
End;
End.

