Unit Printer2;  { file PRINTER2.PAS }

{    This Unit is a replacement for  the Printer Unit that    }
{ came with Turbo Pascal Version 4.0.  It's purpose is two    }
{ fold.  It will allow a user to change the printer port that }
{ the LST file is writing to on the fly.  This takes the      }
{ place of LstOutPtr and the routine on page 369 of the Turbo }
{ Pascal Version 3.0 manual.  The second purpose of this Unit }
{ is that it will also circumvent DOS's stripping of a ^Z     }
{ ($1A, the End Of File character) when writinf to the        }
{ printer as an ASCII device.  ^Z was usually sent as         }
{ part of a graphics string to a printer.  In Version 3.0 of  }
{ Turbo Pascal an ASCII device was opened in binary mode, and }
{ in Version 4.0 an ASCII device is opened in ASCII mode and  }
{ DOS thus strips a ^Z.                                       }
{                                                             }
{    This also provides a good example of a Text file         }
{ device driver.                                              }

Interface

Uses DOS;         { for using Intr()  }

Var
  LST : Text;     { Publis LST file variable }

Procedure SetPrinter( Port: Byte );
{     SetPrinter sets the printer number to Port where Port   }
{ is 'n' in 'LPTn'.  To write to Lpt2, SetPrinter(2) etc..    }
{ This lets you change line printers on the fly.              }

Implementation
 {    The following routines MUST be FAR calls because they   }
 { are called bt the Read and Write routines.  They are not   }
 { Public (in the Implementation section) because they should }
 { only be accessed by the Read and Write routines.           }

{$F+}

{    LSTNoFunction performs a NUL operation for a Reset or    }
{ Rewrite on LST ( Just in case).                             }

Function LSTNoFunction( Var F: TextRec ): Integer;
Begin
  LSTNoFunction:= 0;      { no error }
End;

{     LSTOutputToPrinter sends the output to the Printer       }
{ port number stored in the first byte of the UserData area    }
{ of the Text Record.                                          }

Function LSTOutputToPrinter( Var F: TextRec): Integer;
var
  Regs: Registers;
  P : word;
Begin
  With F Do
  Begin
    P:= 0;
    Regs.AH := 16;
    While (P < BufPos) and ((Regs.AH and 16) = 16) Do
    Begin
      Regs.AL:= Ord(BufPtr^[P]);
      Regs.AH:= 0;
      Regs.DX:= UserData[1];
      Intr($17,Regs);
      Inc(P);
    End;
    BufPos:= 0;
  End;
  If (Regs.AH and 16) = 16 Then
    LSTOutputToPrinter := 0         { no error }
   Else
     If ( Regs.AH and 32) = 32 then
       LSTOutputToPrinter := 159    { out of paper }
   Else
     LSTOutputToPrinter := 160;     { device write fault }
  End;

{$F-}

{     AsignLST both sets up the LST text file record as       }
{ would ASSIGN, and initializes it as would a RESET.  It also }
{ stores the Port number in the first byte of the UserData    }
{ area.                                                       }

Procedure AssignLST( Port : Byte);
Begin
  With TextRec(LST) Do
    Begin
      Handle         := $FFF0;
      Mode           := fmOutPut;
      BufSize        := SizeOf(Buffer);
      BufPtr         := @Buffer;
      BufPos         := 0;
      OpenFunc       := @LSTNoFunction;
      InOutFunc      := @LSTOutputToPrinter;
      FlushFunc      := @LSTOutputToPrinter;
      CloseFunc      := @LSTOutputToPrinter;
      UserData[1]    := Port - 1;  { DOS counts from zero }
    End;
End;

Procedure SetPrinter(Port : Byte);  { documented above }
Begin
  With TextRec(LST) Do
    UserData[1] := Port - 1  { DOS counts from zero }
End;

Begin    { Initialization }
  AssignLST( 1 );               { Call AssignLST so its works }
End.                            { like Turbo's Printer Unit   }




