UNIT POWERS;
INTERFACE
function pwrr(x,y: REAL) : REAL;
function pwri(x: REAL; n: integer): REAL;

IMPLEMENTATION
function pwrr(x,y: REAL) : REAL;
{ evaluates X**Y, use pwri if y integer; see pc tech may '85 p213}
begin
   if x>0
      then pwrr := exp(y*ln(x))
   else if x<0
      then
        begin
          writeln('x < 0.0. HALT');
          halt
        end
   else if (x=0) and(y=0)
      then
        begin
          writeln('0 to the 0 power. HALT.');
          halt
        end
   else if (x=0) and (y<0)
      then
        begin
          writeln('0 to a negative power. HALT.');
          halt
        end
   else pwrr := 0.0
end;


function rlscan(x: REAL; n: integer): REAL;
{ used by pwri }
var  y,z: REAL;
       oh: boolean;
    bign: integer;

begin
  bign :=n;
  y := 1.0;
  z := x;
  while bign > 0 do
    begin
      oh := odd(bign);
      bign := bign div 2;
      if oh then
        begin
          y := y*z;
          rlscan := y
        end;
      z := z*z
    end;
end;


function pwri(x: REAL; n: integer): REAL;
{ computes X**I, uses rlscan above }
begin
  if ( n>0 ) then pwri := rlscan(x,n)
  else if ( x <> 0.0 ) and ( n < 0 ) then
    begin
      n := -n;
      pwri := 1.0/rlscan(x,n)
    end
  else if ( n = 0 ) and ( x <> 0.0 ) then pwri := 1.0
  else if (n = 0) and (x = 0.0) then
    begin
      writeln('0 to the 0 power. HALT.');
      halt
    end
  else if (n < 0) and (x = 0.0) then
    begin
      writeln('division by zero. HALT.');
      halt
    end
end;
END.
