{$i-}PROGRAM convert_first_folders_to_speed_folders;
USES dos;
CONST
  progdesc = '1st2SPD - Free DOS utility: Converts folders from 1st to SPEED 1.40 format.';
  author   = 'v1.00: September 14, 1994. (c) 1994 by David Daniel Anderson - Reign Ware.';
  colon = #58;
  QWKField = 25;

TYPE
  arrayQWK = ARRAY[1..QWKField] OF char;
  array6   = ARRAY[1..6] OF char;
  array8   = ARRAY[1..8] OF char;

  firstHdr=RECORD
    Status     : Char;
    msgnum     : ARRAY [1..7] OF Char;
    msgdate    : array8;
    msgtime    : ARRAY [1..5] OF Char;   { need to change to am/pm }
    whoto      ,
    whofrom    ,
    Subject    : arrayQWK;
    PassWord   : ARRAY [1..12] OF Char;
    refernum   : array8;
    NumChunk   : array6;
    Alive      : Byte;
    confnumb   : Word;
    Reserved   : ARRAY [1..3] OF Char;
  END;

VAR
  BBSID        : string;
  confname     : string;

PROCEDURE showhelp (problem :byte);
{----
 If any *foreseen* errors arise, we are sent
  here to give a little help and exit (relatively) peacefully
----}
CONST
  usage    = 'Usage:  1st2SPD folders(s)_to_convert[.FOL]';
VAR
  message : STRING[79];
BEGIN
  writeln;
  IF (problem > 0) THEN BEGIN
    CASE (problem) OF
      3 : message:='No files found.  First parameter must be a valid file specification.';
      4 : message:='Invalid first line of .IDX file.';
      5 : message:='The current .TMP temporary file already exists.  Rename or delete it.';
      6 : message:='You cannot just specify a path, add "*.*" or "\*.*" for all files.';
      7 : message:='Error opening, closing, or renaming a file.  Original may be renamed!'
    ELSE  message:='Undefined error.'
    END;
    writeln (#7,'Error encountered:'); writeln (message); writeln;
  END;
  writeln (usage);
  halt (problem);
END;

PROCEDURE iocheck (iores :byte);
BEGIN
  IF (iores <> 0) THEN showhelp (7);
END;

FUNCTION nameof (fn :STRING):STRING;
BEGIN
  IF (pos ('.', fn) > 0) THEN
    nameof:=copy (fn, 1, (pos ('.', fn)-1))
  ELSE
    nameof:=fn;
END;

FUNCTION getfsize (filename :STRING) :longint;
VAR
  sr : searchrec;
BEGIN
  findfirst (filename, anyfile, sr);
  IF (doserror = 0) THEN
    getfsize:=sr.size
  ELSE
    getfsize:=-1;
END;

PROCEDURE openfirst (VAR firstf :file; fname :STRING);
VAR
  firstline   : STRING;
  tbuffer     : array[1..128] of char;
BEGIN
  assign (firstf, fname+'.fol');
  reset  (firstf,128);  iocheck (ioresult);
  blockread(firstf,tbuffer,1);
END;

PROCEDURE openidx (VAR idxf :text; fname :STRING; VAR tmsgs :word);
VAR
  nummsgs : STRING;
  valerr  : integer;
BEGIN
  assign (idxf, fname+'.idx');
  reset (idxf);
  IF (ioresult <> 0) THEN BEGIN
    rewrite (idxf);  iocheck (ioresult);
    tmsgs:=0;
    writeln (idxf, '00000');
    flush (idxf);
  END
  ELSE BEGIN
    readln (idxf, nummsgs);
    val (nummsgs, tmsgs, valerr);
    IF ((length (nummsgs) <> 5) OR (valerr <> 0)) THEN
      showhelp (4);
    close (idxf);    iocheck (ioresult);
    append (idxf);   iocheck (ioresult);
  END;
END;

PROCEDURE resetcnf (VAR cnff :text; fname :STRING; VAR fsize :longint);
BEGIN
  fsize:=(getfsize (fname+'.cnf'));
  assign (cnff, fname+'.cnf');
  IF (fsize =-1) THEN BEGIN
    rewrite (cnff);  iocheck (ioresult);
    fsize:=0;
  END
  ELSE BEGIN
    append (cnff);   iocheck (ioresult);
  END;
END;

PROCEDURE opentmp (VAR tfile :text; fname :STRING);
BEGIN
  assign (tfile, fname+'.tmp');
  append (tfile);
  IF (ioresult = 0) THEN
    showhelp (5)
  ELSE BEGIN
    rewrite (tfile); iocheck (ioresult);
  END;
END;

FUNCTION leadingzero (w :Word; l :byte) : STRING;
VAR
  s : STRING;
BEGIN
  Str (w :0, s);
  WHILE (Length (s) < l) DO
    s:='0'+s;
  LeadingZero:=s;
END;

FUNCTION ArrayTOInteger (B:array6; Len:Byte) :LongInt;
VAR
  I :Byte;
  S :STRING;
  E :Integer;
  T :Integer;
BEGIN
  S:= '';
  FOR I:= 1 TO Len DO
    IF B[I] <> #32 THEN S:= S + B[I];
  Val (S, T, E);
  IF E = 0
    THEN ArrayTOInteger:= T
    ELSE ArrayTOInteger:= 0;
END;

FUNCTION fixtime (timestr :STRING):STRING;
VAR
  ampm   : char;
  hour   : byte;
  valerr : integer;
  temp   : byte;
BEGIN
  val (copy (timestr, 1, 2), temp, valerr);
  IF (temp > 11)
    THEN ampm:='p'
    ELSE ampm:='a';
  IF (temp > 12) THEN
    temp:=temp MOD 12;
  fixtime:=leadingzero (temp, 2)+colon+copy (timestr, 4, 2)+ampm;
END;

PROCEDURE writemsg (VAR firstf :file; VAR tmpf :text; firstr :firstHdr; VAR lines :word);
CONST
  EoMline= '';
VAR
  Buff :ARRAY [1..128] OF Char;
  MSGChunks,
  ChunkCount   :Integer;
  ByteCount    :Byte;
  msgstr       :String;
  EoM          :Boolean;
BEGIN
  lines:=0;
  ChunkCount:=1;
  msgstr:='';
  EoM:=FALSE;
  MSGChunks:=Pred (ArrayTOInteger(firstr.NumChunk,6));
  REPEAT
    BlockRead (firstf, Buff, 1);
    inc(ChunkCount);
    FOR ByteCount:= 1 TO 128 DO
      IF Buff [ByteCount] = #$E3
        THEN BEGIN
          IF (msgstr=EoMline) AND (ChunkCount >= (MSGChunks-2))
            THEN BEGIN
              EoM:=TRUE;
            END
            ELSE BEGIN
              IF EoM
                THEN BEGIN
                  IF ((Copy(msgstr,1,3)) <> ('  ')) THEN
                    EoM:=FALSE;

                  IF EoM THEN
                    CASE msgstr[4] OF
                      'F': BBSID:=Copy(msgstr,11,(Pos(')',msgstr))-11);
                      'C': confname:=Copy(msgstr,26,length(msgstr)-25);
                    ELSE
                      EoM:=FALSE;
                    END;

                  IF NOT EoM
                    THEN BEGIN
                      Writeln (tmpf,EOMLine);
                      Writeln (tmpf,msgstr);
                      inc (lines,2);
                    END;
                END
                ELSE BEGIN
                  Writeln (tmpf,msgstr);
                  inc (lines);
                END
            END;
          msgstr:='';
        END
        ELSE msgstr:=msgstr+(Buff [ByteCount]);
  UNTIL ChunkCount > MSGChunks;
END;

PROCEDURE writecnf (VAR cfile, tfile :text; firstr :firstHdr; lines :word);
VAR
  msgl    : STRING;
  PubPriv : char;
BEGIN
  WITH firstr DO BEGIN
    IF status IN ['*','+'] THEN BEGIN  { kludge for SPEED mixup }
      IF status='*' THEN
        PubPriv:='+'
      ELSE
        PubPriv:='*';
    END
    ELSE
      PubPriv:=status;

    writeln (cfile, PubPriv+'A');
    writeln (cfile, colon, confnumb);
    writeln (cfile, colon, confname);
    writeln (cfile, colon, BBSID);
    writeln (cfile, msgdate);
    writeln (cfile, fixtime(msgtime));
    writeln (cfile, refernum);
    writeln (cfile, lines);

    close (cfile);    iocheck (ioresult);
    append (cfile);   iocheck (ioresult);
    close (tfile);    iocheck (ioresult);
    reset (tfile);    iocheck (ioresult);
    WHILE (NOT eof (tfile)) DO BEGIN
      readln (tfile, msgl);
      writeln (cfile, msgl);
    END;
  END;
END;

PROCEDURE writeidx (VAR ifile :text; firstr :firstHdr; cnf_filesize :longint);
BEGIN
  WITH firstr DO BEGIN
    writeln (ifile, cnf_filesize);
    writeln (ifile, whofrom);
    writeln (ifile, whoto);
    writeln (ifile, msgnum);
    writeln (ifile, subject);
    writeln (ifile, 'Y ');        { Y = read by SPEED, then permanent/kill }
  END;              { "Read" and "normal" forced for simplicity and safety }
END;

PROCEDURE fixidx (VAR ifile, tfile :text; tmsgs :word);
VAR
  msgl : STRING;
BEGIN
  reset (ifile);    iocheck (ioresult);
  rewrite (tfile);  iocheck (ioresult);
  readln (ifile, msgl);
  writeln (tfile, leadingzero (tmsgs, 5));
  WHILE (NOT eof (ifile)) DO BEGIN
    readln (ifile, msgl);
    writeln (tfile, msgl);
  END;
  close (ifile);    iocheck (ioresult);
  close (tfile);    iocheck (ioresult);
END;

PROCEDURE swapnames (VAR ifile, tfile :text; tname :pathstr);
BEGIN
  rename (ifile, tname+'.swp');  iocheck (ioresult);
  rename (tfile, tname+'.idx');  iocheck (ioresult);
  erase (ifile);                 iocheck (ioresult);
END;

PROCEDURE matchdates (VAR cfile, tfile :text);
VAR
  filedt    : longint;    { file date and time, to match dates     }
BEGIN
  reset (cfile);    iocheck (ioresult);
  reset (tfile);    iocheck (ioresult);
  getftime (cfile, filedt);
  setftime (tfile, filedt);
  close (cfile);    iocheck (ioresult);
  close (tfile);    iocheck (ioresult);
END;

VAR
  first_file: file;
  cnf_file,
  idx_file,
  tmp_file  : text;
  info      : firstHdr;

  fpath     : pathstr;    { source file path,          }
  fdir      : dirstr;     {             directory,     }
  folder    : namestr;    {             name,          }
  fext      : extstr;     {             extension.     }
  dirinfo   : searchrec;  { contains filespec info.    }

  textname,
  fname     : STRING[8];  {             name, again    }

  cnf_size  : longint;
  msglines,               { number of lines in the current message }
  initmsgs,
  totalmsgs,              { total number of messages per folder    }
  numdone   : word;       { numdone is number of files processed   }

BEGIN
  writeln (progdesc);
  writeln (author);
  IF (paramcount <> 1) THEN showhelp (0);
  fpath:=paramstr (1);
  IF (fpath[1] IN ['/', '-']) THEN showhelp (0);
  fsplit (fexpand (fpath), fdir, folder, fext);
  IF (folder = '') THEN showhelp (6);

  findfirst (fdir+folder+'.fol', archive, dirinfo);
  IF (doserror <> 0) THEN showhelp (3);
  writeln;
  writeln ('Converting folders from 1st to SPEED in directory: ', fdir);
  numdone:=0;

  WHILE (doserror = 0) DO BEGIN
    fname:=nameof (dirinfo.name);
    textname:=fname;
    textname[0]:=chr (8);
    fillchar (textname[length (fname)+1], 8-length (fname), #46);

    write ('Converting folder: ', textname);
    inc (numdone);

    openfirst (first_file, fdir+fname);
    openidx (idx_file, fdir+fname, totalmsgs);
    initmsgs:=totalmsgs;

    WHILE (NOT eof (first_file)) DO BEGIN
      BlockRead (first_file, info, 1);
      opentmp (tmp_file, fdir+fname);
      writemsg (first_file, tmp_file, info, msglines);
      resetcnf (cnf_file, fdir+fname, cnf_size);
      writecnf (cnf_file, tmp_file, info, msglines);

      close (cnf_file);  iocheck (ioresult);
      close (tmp_file);  iocheck (ioresult);
      erase (tmp_file);  iocheck (ioresult);

      writeidx (idx_file, info, cnf_size);
      inc (totalmsgs);
    END;

    close (first_file);    iocheck (ioresult);
    close (idx_file);    iocheck (ioresult);
    fixidx (idx_file, tmp_file, totalmsgs); { put num of msgs at start of IDX }
    swapnames (idx_file, tmp_file, fdir+fname);

    matchdates (cnf_file, tmp_file);   { tmp_file is actually the .idx file }
    writeln (', added ', totalmsgs-initmsgs :2,
          ' message(s) to ', initmsgs :2,
          ', for a total of ', totalmsgs :2, '.');
    findnext (dirinfo);
  END;
  writeln ('Converted ', numdone, ' folder(s).');
END.

