/*******************************************************************
* Split a file into multiple pieces
*
* Syntax: split FileToSplit OutputFilePrefix
*
*******************************************************************/
#define INCL_DOS
#include <os2.h>

#include <stdio.h>            // printf & sprintf

#define BUFFER_SIZE 8192      // Size of read buffer

int main (int argc, char **argv)
{
APIRET      rc;                 // Return code
HFILE       hFileToSplit;       // File handle for file to split
char        *FileToSplit;       // Point to File to Split string
HFILE       hNewFile;           // File handle for Output File
char        *Prefix;            // Point to output file prefix
char        szNewFile[261];     // Output file
FILESTATUS3 FileStatus;         // File information for FileToSplit
ULONG       ulFileSize;         // File size for FileToSplit
ULONG       action;             // Action taken for a DosOpen call
ULONG       ulNewPointer;       // New pointer location for DosSetFilePtr
ULONG       ulPosition;         // Location in FileToSplit
ULONG       ulBytesRead;        // How many bytes were read on DosRead
ULONG       ulBytesWritten;     // How many bytes were written on DosWrite
ULONG       fileCount;          // Keep track of how many files FileToSplit
                                // splits into
BYTE        buffer[BUFFER_SIZE];// Read/Write buffer
ULONG       ulSize;             // Keep track of how many bytes were written
                                // per file. When we go over 500000, create
                                // a new output file.

   /**********************************************************************
   * Check the number of command line arguments. We are supposed to have
   * 2 arguements: The file to split and the output file prefix.
   **********************************************************************/
   rc=0;
   if (argc==3)
      {
      ulPosition=0;
      ulSize=0;
      fileCount=1;
      FileToSplit=argv[1];
      Prefix=argv[2];
      rc=DosOpen(FileToSplit, &hFileToSplit, &action, 0L, 0L,
              OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_FAIL_IF_NEW,
              OPEN_SHARE_DENYNONE | OPEN_ACCESS_READONLY,
              0L);
      if (rc==0)
         {
         rc=DosQueryFileInfo(hFileToSplit, 1, &FileStatus, sizeof(FileStatus));
         ulFileSize=FileStatus.cbFile;
         } /* end IF */
      if (rc==0)
         {
         rc=DosSetFilePtr(hFileToSplit, 0, FILE_BEGIN, &ulNewPointer);
         } /* end IF */
      if (rc==0)
         {
         sprintf(szNewFile, "%s.%d", Prefix, fileCount);
         printf("Creating %s\n",szNewFile);
         rc=DosOpen(szNewFile, &hNewFile, &action, 0L, 0L,
                 OPEN_ACTION_REPLACE_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW,
                 OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_WRITEONLY,
                 0L);
         } /* end IF */
      /**************************************************************
      * Read from FileToSplit and loop until we hit the end of file
      **************************************************************/
      while (ulPosition<ulFileSize && rc==0)
         {
         rc=DosRead(hFileToSplit, buffer, BUFFER_SIZE, &ulBytesRead);
         if (rc==0)
            {
            ulPosition+=ulBytesRead;
            ulSize+=ulBytesRead;
            rc=DosWrite(hNewFile, buffer, ulBytesRead, &ulBytesWritten);
            if (ulSize>=450000 && rc==0)
               {
               printf("  File size is %d\n", ulSize);
               DosClose(hNewFile);
               ulSize=0;
               fileCount++;
               sprintf(szNewFile, "%s.%d", Prefix, fileCount);
               printf("Creating %s\n",szNewFile);
               rc=DosOpen(szNewFile, &hNewFile, &action, 0L, 0L,
                       OPEN_ACTION_REPLACE_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW,
                       OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_WRITEONLY,
                       0L);
               } /* end IF */
            } /* end IF */
         } /* end while */
      printf("  File size is %d\n", ulSize);
      DosClose(hNewFile);
      DosClose(hFileToSplit);
      } /* end if */
   else /* */
      {
      printf("  Syntax is: split FileToSplit OutputFilePrefix\n\n");
      printf("  For example: 'split oem.wav oem' results in 3 files:\n");
      printf("     OEM.1, OEM.2, and OEM.3\n");
      } /* end ELSE */
   /*****************************************************
   * If we had an error condition, print out a message
   *****************************************************/
   if (rc)
      printf("We encountered an error code on a Dos call: %d\n", rc);
   return(rc);
}
