/* file ffdecode.c */

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>

#define char_zero     ' '
#define char_one     0xff
#define i_tfsz       4096
#define i_ofsz       1024
#define ff_startline "ffcode"
#define linesize       64

int tfh = -1, ofh = -1,
    tfp = -1, ofp = 0,
    tfsz = 0, ofsz = 0,
    bitpos = 0, startline_pos = 0;
unsigned char *tfbuf = NULL, *hfbuf = NULL, *ofbuf = NULL, curbyte = 0;


int getchr(void)
{
  int c;

  if (tfsz < 1)
    return -1;
  if (tfp < 0 || tfp >= tfsz)
  {
    tfp = 0;
    tfsz = read(tfh, tfbuf, tfsz);
    if (tfsz < 1)
      return -1;
  }
  c = tfbuf[tfp++];
  return c;
}


int getbyte(int bitin)
{
  curbyte = (curbyte << 1) | (bitin ? 1 : 0);
  bitpos++;
  if (bitpos < 8)
    return -1;
  if (startline_pos >= 0)
  {
    if (curbyte == ff_startline[startline_pos])
    {
      bitpos = 0;
      if (ff_startline[++startline_pos] == 0)
        startline_pos = -1;
    }
    else
    {
      startline_pos = 0;
      bitpos = 7;
    }
    return -1;
  }
  else
  {
    bitpos = 0;
    return curbyte;
  }
}


void outchr(int c)
{
  int i;

  if (c >= 0 && ofp < ofsz)
    ofbuf[ofp++] = c;
  else
  {
    i = write(ofh, ofbuf, ofp);
    ofp = 0;
    if (i < 0)
    {
      printf("bad write, disk full?");
      exit(1);
    }
    if (c >= 0) ofbuf[ofp++] = c;
  }
}


int ffdecode(void)
{
  int done, c, didout, lpos;

  tfsz = i_tfsz;
  ofsz = i_ofsz;
  tfbuf = (unsigned char *)malloc(tfsz);
  ofbuf = (unsigned char *)malloc(ofsz);
  if (!tfbuf || !ofbuf)
  {
    printf("not enough memory\n");
    free(tfbuf);
    free(ofbuf);
    return 1;
  }
  tfp = -1;
  ofp = 0;
  done = 0;
  startline_pos = 0;
  bitpos = 0;
  didout = 0;
  lpos = 0;

  while (!done)
  {
    c = getchr();
    if (c == char_zero || c == char_one)
    {
      lpos++;
      c = getbyte(c == char_one ? 1 : 0);
      if (c >= 0)
      {
        didout = 1;
        outchr(c);
      }
    }
    else if (c == '\r')
    {
      while (lpos < linesize)
      {
        c = getbyte(0);
        if (c >= 0)
        {
          didout = 1;
          outchr(c);
        }
        lpos++;
      }
      lpos = 0;
    }
    else if (c < 0) done = 1;
    else if (c != '\n') lpos++;
  }
  outchr(-1);
  free(tfbuf);
  free(ofbuf);
  return didout;
}


int main(int argc, char *argv[])
{
  int i;

  if (argc != 3)
  {
    printf("ffdecode text file / message decryptor\n");
    printf("usage: ffdecode encodedfile outfile\n");
    exit(0);
  }
  
  tfh = open(argv[1], O_BINARY | O_RDONLY);
  if (tfh < 0)
  {
    printf("can't open encodedfile\n");
    exit(1);
  }

  ofh = open(argv[2], O_BINARY | O_WRONLY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
  if (ofh < 0)
  {
    printf("can't open outfile\n");
    exit(1);
  }

  i = ffdecode();
  close(tfh);
  close(ofh);
  printf(i ? "ffdecode done\n" : "file is not ffencoded\n");
  return 0;
}
