  #define BUNDLEVER 3
  #define EIDSIZ    (sizeof(struct _Address)+sizeof(unsigned long))

  struct _Address {
     unsigned int      Zone;
     unsigned int      Net;
     unsigned int      Node;
     unsigned int      Point;
  };

  struct _BundleHeader {
     struct _Address   B_Destination;    /* Address of target system    */
     struct _Address   B_Origination;    /* Address where bndl started  */
     unsigned int      B_Local1;         /* Used by bundler, etc        */
     unsigned int      B_Version;        /* Always 3                    */
     unsigned long     B_CreationTime;   /* Unix-type stamp (1970-base) */
     unsigned int      B_BundlerMajor;   /* Major version of bundler    */
     unsigned int      B_BundlerMinor;   /* Minor version of bundler    */
     unsigned char     B_Password[9];    /* NULL-padded array           */
     unsigned char     B_Local2;         /* Local use only              */
     unsigned char     B_Product[4];     /* Meaningful to same product  */
     unsigned char     B_FTSC[4];        /* Reserved by FTSC            */
  };

#define           END_SIGNAL        0
#define           AREA_HEADER       1
#define           MESSAGE_HEADER    2
#define           MSG_TEXT          3
#define           SEEN_INFO         4
#define		   PATH_INFO 		 5
#define           FILE_INFO         6
#define           KLUDGE_INFO       7
#define           MSG_ORIG          8		/* An Origin line */
#define           MISC_INFO         128

  struct   _Type {
    unsigned char  Version;
    unsigned char  Packetfiller;
    unsigned int   PacketType;
    unsigned int   PacketSize;
   };

  struct _BundleEnd {
     unsigned char     M_Version;        /* Always 3                    */
     unsigned char     M_filler;
     unsigned int      M_PacketType;     /* Always 0                    */
     unsigned int      M_PacketSize;
  };

  struct _AreaHeader {
#ifdef SCANNING
     unsigned char     E_Version;        /* Always 3                    */
     unsigned char     E_filler;
     unsigned int      E_PacketType;     /* Always 1                    */
    unsigned int       E_PacketSize;
#endif
     unsigned int      E_NameLength;     /* Actual bytes in E_Name      */
  };

  struct _MessageHeader {
#ifdef SCANNING
     unsigned char     M_Version;        /* Always 3                    */
     unsigned char     M_filler;
     unsigned int      M_PacketType;     /* Always 2                    */
    unsigned int       M_PacketSize;
#endif
     struct _Address   M_Destination;    /* FINAL Destination           */
     struct _Address   M_Origination;    /* Where message was entered   */
     unsigned long     M_CreationTime;   /* Unix-type stamp (1970-base) */
     unsigned long     M_My_ID;          /* Some sort of message id     */
     unsigned long     M_Reply_ID;          /* Some sort of message id     */
     unsigned int      M_Attributes;     /* Standard Fidonet bitweights */
     unsigned char     M_FromLength;     /* Number of bytes in FROM     */
	  unsigned char     M_ToLength;       /* Number of bytes in TO       */
     unsigned char     M_SubjectLength;  /* Number of bytes in SUBJECT  */
     unsigned char     M_Fill;		      /* Keeps it word-aligned       */
  };

  struct _Text {
#ifdef SCANNING
     unsigned char    T_Version;         /* Always 3                    */
     unsigned char    T_filler;
     unsigned int     T_PacketType;      /* Always 3                    */
    unsigned int      T_PacketSize;
#endif
     unsigned int     T_ByteCount;       /* Number of bytes ( <0x1000)  */
  };

  struct _Kludge {
#ifdef SCANNING
     unsigned char    K_Version;         /* Always 3                    */
     unsigned char    K_filler;
     unsigned int     K_PacketType;      /* Always 3                    */
    unsigned int      K_PacketSize;
#endif
     unsigned int     K_ByteCount;       /* Number of bytes ( <0x1000)  */
  };

  struct _SeenInfo {
#ifdef SCANNING
     unsigned char     EI_Version;       /* Always 3                    */
     unsigned char     EI_filler;
	  unsigned int      EI_PacketType;    /* Always 4                    */
     unsigned int      EI_PacketSize;
#endif
     unsigned int      EI_SeenbyCount;   /* Number of SEENBY items     */
  };

struct _Path {

#ifdef SCANNING
     unsigned char     P_Version;
     unsigned char     P_filler;
	  unsigned int      P_PacketType;
     unsigned int      P_PacketSize;
#endif
     unsigned int     P_PathCount;       /* Number of _ADDRESS          */
};

  struct _MiscInfo {
#ifdef SCANNING
     unsigned char     MI_Version;       /* Always 3                    */
     unsigned char     MI_filler;
     unsigned int      MI_PacketType;    /* 0x80-0xff, assigned by FTSC */
     unsigned int       MI_PacketSize;
#endif
     unsigned int       MI_PacketLength;
  };

struct _FileInfo {
   char    Name[64];		/* A file name (Can be longer than MSDOS) */
   long    Size;		    /* Total file size */
   long    Time;		    /* File's modification time */
   byte    Full_Path;		/* Where the file is located. Include MSDOS name */
   byte    Description;	/* The length of the description */
};

