(*(***********************************************************************

:Program.    TextGaugeIClass.mod
:Contents.   boopsi class for fuel gauge image using OberonBOOPSI
:Author.     hartmut Goebel [hG]
:Address.    Aufseplatz 5, D-90459 Nrnberg
:Address.    UseNet: hartmut@oberon.nbg.sub.org
:Address.    Z-Netz: hartmut@asn.zer   Fido: 2:246/81.1
:Copyright.  Copyright  1993 by hartmut Goebel
:Language.   Oberon-2
:Translator. Amiga Oberon 3.0
:Version.    $VER: TextGaugeIClass.mod 1.2 (19.10.93) Copyright  1993 by hartmut Goebel

(* $StackChk- $NilChk- $RangeChk- $CaseChk- $OvflChk- $ReturnChk- $ClearVars- *)
(****i* TextGaugeIClass/--history-- ***************************************
*
*  V1.2   internal changes, now creates different version string if compiled
*         with 'SET asLib'
*  V1.1  can be linked as shared library 'textgaugei.class' (compile with
*        option 'SET asLib' and link using 'LibLink WITH TextGaugeIClass.wth'
*  V1.0  works :-)
*
*********************************************************************)*)*)

MODULE TextGaugeIClass;

IMPORT
  RootClass,
  FG:= FuelGaugeIClass,
  I := Intuition,
  IC:= ImageClass,
  g := Graphics,
  Printf,
  str := Strings,
  e := Exec,
  ol:= OberonLib,
  y := SYSTEM;

CONST
  textGaugeIClassName * = "textgaugeiclass";

(*** SET asLib to get a module ready to be linked as library ***)

  (* $IF asLib *)
    versionString = "$VER: TextGaugeIClass 1.2 (19.10.93) linkable as library -- Copyright  1993 by hartmut Goebel";
    asLib = TRUE;
  (* $ELSE *)
    versionString = "$VER: TextGaugeIClass 1.2 (19.10.93) Copyright  1993 by hartmut Goebel";
    asLib = FALSE;
  (* $END *)
  publicClass = asLib;

TYPE
  TextGaugeI = UNTRACED POINTER TO TextGaugeIClass;
  TextGaugeIClass * = RECORD (FG.FuelGaugeIClass) END;

VAR
  textGaugeIClass * : I.IClassPtr;

(*
** redefinign FuelGaugIClass.Draw() to draw the percentage into the gauge
*)
PROCEDURE (VAR tg: TextGaugeIClass) Draw * (VAR msg: I.Draw): e.APTR;
VAR
  rPort: g.RastPortPtr;
  len: INTEGER;
  text: ARRAY 10 OF CHAR;
BEGIN
  IF tg.Draw^(msg) = NIL THEN END;
  IF FG.horizontal IN tg.kind THEN
    rPort := msg.rPort;

    IF g.base.libNode.version < 39 THEN
      g.SetAPen(rPort,tg.drawInfo.pens[I.fillPen]);
      g.SetDrMd(rPort,g.jam1);
    ELSE
      g.SetABPenDrMd(rPort,tg.drawInfo.pens[I.highLightTextPen],
                           tg.drawInfo.pens[I.backGroundPen],g.jam1);
    END;
    Printf.SPrintf1(text,"%ld%%\o", (tg.current * 100) DIV tg.max);
    len := SHORT(str.Length(text));
    g.Move(rPort,msg.offset.x+((tg.image.width-g.TextLength(rPort,text,len)) DIV 2),
                 msg.offset.y+((tg.image.height-rPort.txHeight) DIV 2) + rPort.txBaseline);
    g.Text(rPort,text,len);
  END;
  RETURN 1;
END Draw;

(*
** init TextGaugeIClass as private or public subclass (depending on 'asLib')
** of image class
** NOTE: TextGaugeIClass is from boopsi's point of view a subclass of imageclass
*)
PROCEDURE InitClass * (): BOOLEAN;
BEGIN
  IF asLib THEN ol.SetA5(); END; (* InitClass() is not called via HookEntry() *)
  IF textGaugeIClass = NIL THEN
    IF publicClass THEN (* public class *)
      textGaugeIClass := RootClass.InitPubFromName(textGaugeIClassName,
                        I.frameIClass,
                        IC.Dispatch,
                        SIZE(TextGaugeIClass),
                        y.TYPEDESC(TextGaugeIClass));
    ELSE (* private class *)
      textGaugeIClass := RootClass.InitPrivFromName(
                        I.frameIClass,
                        IC.Dispatch,
                        SIZE(TextGaugeIClass),
                        y.TYPEDESC(TextGaugeIClass));
    END;
  END;
  RETURN textGaugeIClass # NIL;
END InitClass;

CLOSE
  IF textGaugeIClass # NIL THEN
    IF publicClass THEN (* if it was public, remove it *)
      I.RemoveClass(textGaugeIClass);
    END;
    IF I.FreeClass (textGaugeIClass) THEN
      (* here some handling is missing, but I don't know what to do this case *)
    END;
  END;
END TextGaugeIClass.

