(*(***********************************************************************

:Program.    ImageClass.mod
:Contents.   Oberon-like interface to BOOPSI's imageclasses
:Author.     hartmut Goebel [hG]
:Address.    Aufseplatz 5, D-90459 Nrnberg
:Address.    UseNet: hartmut@oberon.nbg.sub.org
:Address.    Z-Netz: hartmut@asn.zer   Fido: 2:246/81.1
:Copyright.  Copyright  1993 by hartmut Goebel
:Language.   Oberon-2
:Translator. Amiga Oberon 3.0
:Imports.    Boopsi.mod - Albert Weinert with some changes bg [hG]
:Version.    $VER: ImageClass.mod 36.0 (5.9.93) Copyright  1993 by hartmut Goebel

(****i* ImageClass/--history-- ***************************************
*
*********************************************************************)*)*)

MODULE ImageClass;

(****** ImageClass/--background-- ************************************
*
*  This is an Oberon-like interface to the BOOPSI class 'imageclass'
*  and it's subclasses.
*
*************
* $StackChk- $NilChk- $RangeChk- $CaseChk- $OvflChk-
* $ReturnChk- $ClearVars- $TypeChk-
*)

IMPORT
  RootClass,
  bps:=Classface,
  e := Exec,
  I := Intuition;

CONST
  versionString = "$VER: ImageClass 36.0 (5.9.93) Copyright  1993 by hartmut Goebel";

TYPE
  Image = UNTRACED POINTER TO ImageClass;
  ImageClass * = RECORD (RootClass.RootClass)
    image -: I.ImagePtr;  (* same as ImageClass.object, avoid typecasts *)
  END;

PROCEDURE (VAR i: ImageClass) New * (VAR msg: I.OpSet): e.APTR;
BEGIN
  i.image := i.New^(msg);
  RETURN i.image;
END New;

(*
** one method for each message imageclass understands, but rootclass doesn't
*)
PROCEDURE (VAR i: ImageClass) Draw * (VAR msg: I.Draw): e.APTR;
BEGIN
  msg.msg.methodID := I.imDraw;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END Draw;

PROCEDURE (VAR i: ImageClass) HitTest * (VAR msg: I.IMHitTest): e.APTR;
BEGIN
  msg.msg.methodID := I.imHitTest;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END HitTest;

PROCEDURE (VAR i: ImageClass) Erase * (VAR msg: I.Erase): e.APTR;
BEGIN
  msg.msg.methodID := I.imErase;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END Erase;

PROCEDURE (VAR i: ImageClass) Move * (VAR msg: I.Msg): e.APTR;
BEGIN
  msg.methodID := I.imMove;
  RETURN bps.DoSuperMethodA(i.class,i.object,msg);
END Move;

PROCEDURE (VAR i: ImageClass) DrawFrame * (VAR msg: I.Draw): e.APTR;
BEGIN
  msg.msg.methodID := I.imDrawFrame;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END DrawFrame;

PROCEDURE (VAR i: ImageClass) FrameBox * (VAR msg: I.FrameBox): e.APTR;
BEGIN
  msg.msg.methodID := I.imFrameBox;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END FrameBox;

PROCEDURE (VAR i: ImageClass) HitFrame * (VAR msg: I.IMHitTest): e.APTR;
BEGIN
  msg.msg.methodID := I.imHitFrame;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END HitFrame;

PROCEDURE (VAR i: ImageClass) EraseFrame * (VAR msg: I.Erase): e.APTR;
BEGIN
  msg.msg.methodID := I.imEraseFrame;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END EraseFrame;

(*
** dispatcher for imageclass
** handles all yet (V36) defined imageclass messages and dispatches to
** the apropriate oberon method, rootclass messages are handle by the
** rootclass' dispatcher
*)

PROCEDURE Dispatch * (cl: I.IClassPtr; obj: I.ObjectPtr; msg: I.MsgPtr): e.APTR;
VAR
  i: Image;
BEGIN
  IF msg.methodID # I.new THEN (* object exists already? *)
    i := RootClass.BoopsiToObj(cl,obj)(Image);
  END;
  CASE msg.methodID OF
  |I.imDraw:
    RETURN i.Draw(msg^(I.Draw));
  |I.imHitTest:
    RETURN i.HitTest(msg^(I.IMHitTest));
  |I.imErase:
    RETURN i.Erase(msg^(I.Erase));
  |I.imMove:
      RETURN i.Move(msg^);
  |I.imDrawFrame:
    RETURN i.DrawFrame(msg^(I.Draw));
  |I.imFrameBox:
    RETURN i.FrameBox(msg^(I.FrameBox));
  |I.imHitFrame:
    RETURN i.HitFrame(msg^(I.IMHitTest));
  |I.imEraseFrame:
    RETURN i.EraseFrame(msg^(I.Erase));
  ELSE
    RETURN RootClass.Dispatch(cl,obj,msg);
  END;
END Dispatch;

END ImageClass.
