(*(***********************************************************************

:Program.    GetImageClass.mod
:Contents.   boopsi class for various GetXXX images
:Author.     hartmut Goebel [hG]
:Address.    Aufseplatz 5, D-90459 Nrnberg
:Address.    UseNet: hartmut@oberon.nbg.sub.org
:Address.    Z-Netz: hartmut@asn.zer   Fido: 2:246/81.1
:Copyright.  Copyright  1993 by hartmut Goebel
:Language.   Oberon-2
:Translator. Amiga Oberon 3.0
:Imports.    Boopsi.mod - Albert Weinert with some changes bg [hG]
:Version.    $VER: GetImageClass.mod 3.5 (19.10.93) Copyright  1993 by hartmut Goebel

(****i* GetImageClass/--history-- ***************************************
*
*  V3.5   internal changes, now creates different version string if compiled
*         with 'SET asLib'
*  V3.4   new image getPrinter (still to be improofed)
*  V3.3   can be linked as shared library 'getimage.class' (compile with
*         option 'SET asLib' and link using 'LibLink WITH GetImageClass.wth');
*         slidly improofed getSomethingElse image
*  V3.2   new image getSomethingElse
*  V3.1   renamed consts for 'which' tag (suffic 'Image' removed);
*         getScreen2 renamed to getScreenMode (more transparent);
*         title bar in getScreen-Image is now changed to barBlockPen only
*         if this color differs from shawdowPen (for drawInfo.version >=2)
*  V3.0   new images: getFontImage (big italic 'F'),
*                     getScreenImage2 (looks like a monitor)
*  V2.1   internal changes
*  V2.0   multi-colored images
*  V1.1   added getSrccenImage
*  V1.0   initial version with getFileImage, getFolderImage
*
*********************************************************************)*)*)

MODULE GetImageClass;

(* $StackChk- $NilChk- $RangeChk- $CaseChk- $OvflChk- $ReturnChk- $ClearVars- *)

IMPORT
  RootClass,
  IC:= ImageClass,
  e := Exec,
  g := Graphics,
  I := Intuition,
  ol := OberonLib,
  u := Utility,
  y := SYSTEM;

CONST
  getImageClassName * = "getimageclass";

(*** SET asLib to get a module ready to be linked as library ***)

  (* $IF asLib *)
    versionString = "$VER: GetImageClass 3.5 (19.10.93) linkable as library -- "
                    "Copyright  1993 by hartmut Goebel";
    asLib = TRUE;
  (* $ELSE *)
    asLib = FALSE;
    versionString = "$VER: GetImageClass 3.5 (19.10.93) Copyright  1993 by hartmut Goebel";
  (* $END *)
  publicClass = asLib; (* senseless if not lib *)

VAR
  getImageClass * : I.IClassPtr;

CONST
  defaultWidth * = 20; defaultHeight * = 14;

  which * = u.user + 1;

  getFile          * = 0;    minImage = 0;
  getFolder        * = 1;
  getScreen        * = 2;
  getFont          * = 3;
  getScreenMode    * = 4;
  getSomethingElse * = 5;
  getPrinter       * = 6;
                             maxImage = 6;

  (* old synonyms, do not use in new code *)
  getFileImage    * = getFile;
  getFolderImage  * = getFolder;
  getFontImage    * = getFont;
  getScreenImage  * = getScreen;
  getScreenImage2 * = getScreenMode;

  getOther = getSomethingElse; (* internal shortcut *)

TYPE
  PolyArray = ARRAY 12 OF g.Point;
  Rectangle = STRUCT
    pen: INTEGER;
    min, max: g.Point;
  END;
  RectangleArray = ARRAY 3 OF Rectangle;

CONST
  doNotDraw = MIN(INTEGER); (* terminates rectangle list,
                               if not all rects are used for drawing *)

TYPE
  GetImageClass * = RECORD (IC.ImageClass)
    leftEdge, topEdge: INTEGER;
    calculate: BOOLEAN;
    which: SHORTINT;
    polys: PolyArray;
    rectangles: RectangleArray;
    firstPoint: g.Point;
  END;

CONST
(*        11111111112               11111111112             11111111112
012345678901234567890    012345678901234567890    012345678901234567890
.....................  0 .....................  0 .....................
.....................  1 .....................  1 .....................
....OO-----O.........  2 ..........O--O.......  2 ....0--------O-0.....
....||.....|\........  3 ........./....\......  3 ....|........|.|.....
....||.....|.\.......  4 ....O---O......O.....  4 ....O--------0-0.....
....||.....|..\......  5 ....|O---O.....|.....  5 ....|..........|.....
....||.....O--OO.....  6 ....||....O---O|.....  6 ....|..........|.....
....||........||.....  7 ....||.........|.....  7 ....|..........|.....
....||........||.....  8 ....||.........|.....  8 ....|..........|.....
....||........||.....  9 ....||.........|.....  9 ....|..........|.....
....||........||..... 10 ....||.........|..... 10 ....|..........|.....
....OO--------0O..... 11 ....OO---------O..... 11....0----------0.....
..................... 12 ..................... 12 .....................
..................... 13 ..................... 13 .....................
..................... 14 ..................... 14 .....................
      getFile                  getFolder                getScreen
*)
  firstPointFile = g.Point(4,11);
  getFileData = PolyArray(4,2, 11,2, 15,6, 15,11, 5,11, 5,2,
                          11,2, 11,6, 14,6, 14,11, 14,11, 14,11);
  getFileRectanges = RectangleArray(
     I.shinePen,      6,3,  11,10,
     I.shinePen,      12,6, 13,10,
     I.backGroundPen, 12,4, 13,5);
  firstPointFolder = g.Point(4,11);
  getFolderData = PolyArray(4,4, 8,4, 10,2, 13,2, 15,4, 15,11,
                            5,11, 5,5, 9,5, 10,6, 14,6, 14,6);
  getFolderRectangles = RectangleArray(
     I.shinePen,      6,6,  9,10,
     I.shinePen,      10,7, 14,10,
     I.backGroundPen, 9,3,  14,5);
  firstPointScreen = g.Point(4,11);
  getScreenData = PolyArray(4,2, 15,2, 15,4, 4,4, 13,4, 13,2,
                            13,4, 15,4, 15,11, 5,11, 5,11, 5,11);
  getScreenRectangles = RectangleArray(
     I.shinePen,      5,3,  12,3, (* changes to I.barBlockPen, when V39+ *)
     I.shinePen,      14,3, 14,3,
     I.backGroundPen, 5,5,  14,10);

(*        11111111112               11111111112             11111111112
012345678901234567890    012345678901234567890    012345678901234567890
.....................  0 .....................  0 .....................
.....................  1 .....................  1 .....................
......O----OO---O....  2 .....O--------O......  2 ........O--O.........
.....O+....++........  3 ....O..........O.....  3 ........|..|.........
..........++.........  4 ....|..........|.....  4 ........|..|.........
..........++.........  5 ....|..........|.....  5 ........O--O.........
......O--O---O.......  6 ....|..........|.....  6 .....O--------O......
.....O...++..........  7 ....O..........O.....  7 ......\....../.......
........++...........  8 .....O-O----O-O......  8 .......\..../........
........OO...........  9 ....../......\.......  9 ........O--O.........
........+............ 10 ...../........\...... 10 .....................
....O--O............. 11 ....O----------O..... 11....O----------O.....
..................... 12 ..................... 12 ....O----------O.....
..................... 13 ..................... 13 .....................
..................... 14 ..................... 14 .....................
      getFont                getScreenMode
*)
  firstPointFont = g.Point(4,11);
  getFontData = PolyArray(7,11, 9,9, 12,2, 16,2, 6,2, 5,3,
                          11,2, 8,9, 9,6, 13,6, 6,6, 5,7);
  getFontRectangles = RectangleArray(
    doNotDraw, 0,0,0,0,
    doNotDraw, 0,0,0,0,
    doNotDraw, 0,0,0,0);
  firstPointScreenMode = g.Point(4,11);
  getScreenModeData = PolyArray(7,8, 14,8, 15,7, 15,3, 14,2,
                             5,2, 4,3, 4,7, 5,8, 12,8, 15,11, 4,11);
  getScreenModeRectangles = RectangleArray(
     I.shinePen,      5,3,  14,7,
     I.shinePen,      6,9,  13,10,
     I.backGroundPen, 6,4, 13,6);
  firstPointOther  = g.Point(4,6);
  getOtherData = PolyArray(14,6, 11,9, 8,9, 4,6, 4,6, 4,6, 4,6,
                                            4,6, 4,6, 4,6, 4,6, 4,6);
  getOtherRectangles = RectangleArray(
     I.shadowPen, 4,11, 15,12,
     I.shadowPen, 8,2,  11,5,
     I.shadowPen, 7,7,  12,8);

(*        11111111112               11111111112             11111111112
012345678901234567890    012345678901234567890    012345678901234567890
.....................  0 .....................  0 .....................
.....................  1 .....................  1 .....................
.....................  2 .....................  2 .....................
.......O----O........  3 .....................  3 .....................
......./..../........  4 .....................  4 .....................
......O....O.........  5 .....................  5 .....................
.......\....\........  6 .....................  6 .....................
.....O--O---O-O......  7 .....................  7 .....................
...../........\......  8 .....................  8 .....................
....|......**..|.....  9 .....................  9 .....................
....O..........O..... 10 ..................... 10 .....................
.....O--------O...... 11 ..................... 11.....................
..................... 12 ..................... 12 .....................
..................... 13 ..................... 13 .....................
..................... 14 ..................... 14 .....................
      getFont                getScreenMode
*)
  firstPointPrinter = g.Point(5,11);
  getPrinterData = PolyArray(14,11, 15,10, 14,7, 8,7, 6,5, 7,2, 12,2, 11,5, 12,7,
                          5,7, 4,10, 5,11);
  getPrinterRectangles = RectangleArray(
    I.shinePen,  5,7,  14,11,
    I.shinePen,  7,3,  11,6,
    I.shadowPen, 10,9, 12,9);

(* does not work due to compiler mis-behavior :-(
TYPE
  Rects = ARRAY maxImage +1 OF RectangleArray;
CONST
  rects = Rects(getFileRectangles,getFolderRectangles,getScreenRectangles,
                getFontRectangles,getScreenModeRectangles);
*)
PROCEDURE (VAR gf: GetImageClass) New * (VAR msg: I.OpSet): e.APTR;
BEGIN
  gf.which := SHORT(SHORT(u.GetTagData(which,getFile,msg.attrList)));
  IF ~ (gf.which IN {minImage..maxImage}) THEN
    RETURN NIL;
  END;
  IF gf.New^(msg) # NIL THEN
    gf.calculate := TRUE;
    gf.image.width := SHORT(u.GetTagData(I.iaWidth,defaultWidth,msg.attrList));
    gf.image.height := SHORT(u.GetTagData(I.iaHeight,defaultHeight,msg.attrList));
  END;
  RETURN gf.image;
END New;

PROCEDURE (VAR gf: GetImageClass) Draw * (VAR msg: I.Draw): e.APTR;
VAR
  rPort: g.RastPortPtr;
  left, top, width, height, pen, i: INTEGER;
BEGIN
  IF gf.Draw^(msg) = NIL THEN END;

  left := msg.offset.x; top  := msg.offset.y;
  width := gf.image.width; height := gf.image.height;
  rPort := msg.rPort;

  IF (gf.leftEdge # left) OR (gf.topEdge # top) THEN
    gf.leftEdge := left; gf.topEdge := top;
    gf.calculate := TRUE;
  END;

  INC(left,(width-defaultWidth) DIV 2);
  INC(top,(height-defaultHeight) DIV 2);
  IF gf.calculate THEN
    CASE gf.which OF
    |getFile:
      gf.polys := getFileData;
      gf.rectangles := getFileRectanges;
      gf.firstPoint := firstPointFile;
    |getFolder:
      gf.polys := getFolderData;
      gf.rectangles := getFolderRectangles;
      gf.firstPoint := firstPointFolder;
    |getScreen:
      gf.polys := getScreenData;
      gf.rectangles := getScreenRectangles;
      gf.firstPoint := firstPointScreen;
      IF (msg.drInfo.version >= 2)
      & (msg.drInfo.pens[I.shadowPen] # msg.drInfo.pens[I.barBlockPen]) THEN
        gf.rectangles[0].pen := I.barBlockPen;
      END;
    |getFont:
      gf.polys := getFontData;
      gf.rectangles := getFontRectangles;
      gf.firstPoint := firstPointFont;
    |getScreenMode:
      gf.polys := getScreenModeData;
      gf.rectangles := getScreenModeRectangles;
      gf.firstPoint := firstPointScreenMode;
    |getOther:
      gf.polys := getOtherData;
      gf.rectangles := getOtherRectangles;
      gf.firstPoint := firstPointOther;
    |getPrinter:
      gf.polys := getPrinterData;
      gf.rectangles := getPrinterRectangles;
      gf.firstPoint := firstPointPrinter;
    END;
    i := LEN(gf.polys);
    REPEAT
      DEC(i);
      INC(gf.polys[i].x,left); INC(gf.polys[i].y,top);
    UNTIL i = 0;
    i := LEN(gf.rectangles);
    REPEAT
      DEC(i);
      INC(gf.rectangles[i].min.x,left); INC(gf.rectangles[i].min.y,top);
      INC(gf.rectangles[i].max.x,left); INC(gf.rectangles[i].max.y,top);
    UNTIL i = 0;
    gf.calculate := FALSE;
  END;

  i := 0; pen := -1;
  WHILE (i < LEN(gf.rectangles)) & (gf.rectangles[i].pen >= 0) DO
    IF pen # gf.rectangles[i].pen THEN
      pen := gf.rectangles[i].pen;
      g.SetAPen(rPort,msg.drInfo.pens[pen]);
    END;
    g.RectFill(rPort,gf.rectangles[i].min.x,gf.rectangles[i].min.y,
                     gf.rectangles[i].max.x,gf.rectangles[i].max.y);
    INC(i);
  END;

  g.SetAPen(rPort,msg.drInfo.pens[I.shadowPen]);
  g.Move(rPort, left+gf.firstPoint.x, top+gf.firstPoint.y);
  g.PolyDraw(rPort,LEN(gf.polys),gf.polys);
  RETURN 1;
END Draw;

PROCEDURE (VAR gf: GetImageClass) Set * (VAR msg: I.OpSet): e.APTR;
BEGIN
  gf.calculate := TRUE;
  RETURN gf.Set^(msg);
END Set;


PROCEDURE InitClass * (): BOOLEAN;
BEGIN
  IF asLib THEN ol.SetA5(); END; (* InitClass() is not called via HookEntry() *)
  IF getImageClass = NIL THEN
    IF publicClass THEN (* public class *)
      getImageClass := RootClass.InitPubFromName(getImageClassName,
                        I.frameIClass,
                        IC.Dispatch,
                        SIZE(GetImageClass),
                        y.TYPEDESC(GetImageClass));
    ELSE (* private class *)
      getImageClass := RootClass.InitPrivFromName(
                        I.frameIClass,
                        IC.Dispatch,
                        SIZE(GetImageClass),
                        y.TYPEDESC(GetImageClass));
    END;
  END;
  RETURN getImageClass # NIL;
END InitClass;

CLOSE
  IF getImageClass # NIL THEN
    IF publicClass THEN (* if it was public, remove it *)
      I.RemoveClass(getImageClass);
    END;
    IF I.FreeClass (getImageClass) THEN
      (* here some handling is missing, but I don't know what to do this case *)
    END;
  END;

END GetImageClass.

