(*(***********************************************************************

:Program.    DatatypesClass.mod
:Contents.   .
:Author.     hartmut Goebel [hG]
:Address.    Aufseplatz 5, D-90459 Nrnberg
:Address.    UseNet: hartmut@oberon.nbg.sub.org
:Address.    Z-Netz: hartmut@asn.zer   Fido: 2:246/81.1
:Copyright.  Copyright  1993 by hartmut Goebel
:Language.   Oberon-2
:Translator. Amiga Oberon 3.0
:Imports.    Boopsi.mod - Albert Weinert with some changes bg [hG]
:Version.    $VER: DatatypesClass.mod 39.0 (5.9.93) Copyright  1993 by hartmut Goebel

(* $StackChk- $NilChk- $RangeChk- $CaseChk- $OvflChk- $ReturnChk- $ClearVars- *)
(****i* /-DatatypesClass-history-- ***************************************
*
*********************************************************************)*)*)

MODULE DatatypesClass;

IMPORT
  RootClass,
  bps:= Classface,
  DT := Datatypes,
  e := Exec,
  I := Intuition;

CONST
  versionString = "$VER: DatatypesClass 39.0 (5.9.93) Copyright  1993 by hartmut Goebel";

TYPE
  Datatype = UNTRACED POINTER TO DatatypesClass;
  DatatypesClass * = RECORD (RootClass.RootClass)
  END;


PROCEDURE (VAR i: DatatypesClass) FrameBox * (VAR msg: DT.FrameBox): e.APTR;
BEGIN
  msg.msg.methodID := DT.mFrameBox;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END FrameBox;

PROCEDURE (VAR i: DatatypesClass) ProcLayout * (VAR msg: I.Msg): e.APTR;
BEGIN
  msg.methodID := DT.mProcLayout;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END ProcLayout;

PROCEDURE (VAR i: DatatypesClass) AsyncLayout * (VAR msg: I.Msg): e.APTR;
BEGIN
  msg.methodID := DT.mAsyncLayout;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END AsyncLayout;

PROCEDURE (VAR i: DatatypesClass) RemoveObject * (VAR msg: DT.General): e.APTR;
BEGIN
  msg.msg.methodID := DT.mRemoveObject;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END RemoveObject;

PROCEDURE (VAR i: DatatypesClass) Select * (VAR msg: DT.Select): e.APTR;
BEGIN
  msg.msg.methodID := DT.mSelect;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END Select;

PROCEDURE (VAR i: DatatypesClass) ClearSelected * (VAR msg: DT.General): e.APTR;
BEGIN
  msg.msg.methodID := DT.mClearSelected;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END ClearSelected;

PROCEDURE (VAR i: DatatypesClass) Copy * (VAR msg: DT.General): e.APTR;
BEGIN
  msg.msg.methodID := DT.mCopy;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END Copy;

PROCEDURE (VAR i: DatatypesClass) Print * (VAR msg: I.Msg): e.APTR;
BEGIN
  msg.methodID := DT.mPrint;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END Print;

PROCEDURE (VAR i: DatatypesClass) AbortPrint * (VAR msg: DT.General): e.APTR;
BEGIN
  msg.msg.methodID := DT.mAbortPrint;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END AbortPrint;

PROCEDURE (VAR i: DatatypesClass) NewMember * (VAR msg: I.OpMember): e.APTR;
BEGIN
  msg.msg.methodID := DT.mNewMember;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END NewMember;

PROCEDURE (VAR i: DatatypesClass) DisposeMember * (VAR msg: I.OpMember): e.APTR;
BEGIN
  msg.msg.methodID := DT.mDisposeMember;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END DisposeMember;

PROCEDURE (VAR i: DatatypesClass) Goto * (VAR msg: DT.Goto): e.APTR;
BEGIN
  msg.msg.methodID := DT.mGoto;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END Goto;

PROCEDURE (VAR i: DatatypesClass) Trigger * (VAR msg: DT.Trigger): e.APTR;
BEGIN
  msg.msg.methodID := DT.mTrigger;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END Trigger;

PROCEDURE (VAR i: DatatypesClass) ObtainDrawInfo * (VAR msg: I.Msg): e.APTR;
BEGIN
  msg.methodID := DT.mObtainDrawInfo;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END ObtainDrawInfo;

PROCEDURE (VAR i: DatatypesClass) Draw * (VAR msg: DT.Draw): e.APTR;
BEGIN
  msg.msg.methodID := DT.mDraw;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END Draw;

PROCEDURE (VAR i: DatatypesClass) ReleaseDrawInfo * (VAR msg: I.Msg): e.APTR;
BEGIN
  msg.methodID := DT.mReleaseDrawInfo;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END ReleaseDrawInfo;

PROCEDURE (VAR i: DatatypesClass) Write * (VAR msg: DT.Write): e.APTR;
BEGIN
  msg.msg.methodID := DT.mWrite;
  RETURN bps.DoSuperMethodA(i.class,i.object, msg);
END Write;

PROCEDURE Dispatch * (cl: I.IClassPtr; obj: I.ObjectPtr; msg: I.MsgPtr): e.APTR;
VAR
  dt: Datatype;
BEGIN
  IF msg.methodID # I.new THEN
    dt := RootClass.BoopsiToObj(cl,obj)(Datatype);
  END;
  CASE msg.methodID OF
  |DT.mFrameBox:
    RETURN dt.FrameBox(msg^(DT.FrameBox));
  |DT.mProcLayout:
    RETURN dt.ProcLayout(msg^);
  |DT.mAsyncLayout:
    RETURN dt.AsyncLayout(msg^);
  |DT.mRemoveObject:
    RETURN dt.RemoveObject(msg^(DT.General));
  |DT.mSelect:
    RETURN dt.Select(msg^(DT.Select));
  |DT.mClearSelected:
    RETURN dt.ClearSelected(msg^(DT.General));
  |DT.mCopy:
    RETURN dt.Copy(msg^(DT.General));
  |DT.mPrint:
    RETURN dt.Print(msg^);
  |DT.mAbortPrint:
    RETURN dt.AbortPrint(msg^(DT.General));
  |DT.mNewMember:
    RETURN dt.NewMember(msg^(I.OpMember));
  |DT.mDisposeMember:
    RETURN dt.DisposeMember(msg^(I.OpMember));
  |DT.mGoto:
    RETURN dt.Goto(msg^(DT.Goto));
  |DT.mTrigger:
    RETURN dt.Trigger(msg^(DT.Trigger));
  |DT.mObtainDrawInfo:
    RETURN dt.ObtainDrawInfo(msg^);
  |DT.mDraw:
    RETURN dt.Draw(msg^(DT.Draw));
  |DT.mReleaseDrawInfo:
    RETURN dt.ReleaseDrawInfo(msg^);
  |DT.mWrite:
    RETURN dt.Write(msg^(DT.Write));
  ELSE
    RETURN RootClass.Dispatch(cl,obj,msg);
  END;
END Dispatch;

END DatatypesClass.
