DEFINT A-Z
 '============================= MLIBSAM1.BAS ================================
 '                  THIS SAMPLE PROGRAM IS PROVIDED AS IS.
 '
 ' You may modify/use this code in any way you wish, provided that you agree
 ' that Terry Venn has no warranties, obligations or liabilities for any code
 ' contained in this sample program.
 '
 ' MLIBSAM2.BAS is a sample program that demonstrates the following routines:
 '
 ' GetSizeM%()      - Get size of mouse state.
 ' SaveStateM()     - Save mouse state.
 ' RestoreStateM()  - Restore mouse state.
 '
 ' QB refers to: QuickBasic 4.5
 ' VBDOS refers to: Visual Basic for DOS
 '
 ' To run this sample program from inside the QB environment, start the QB
 ' editor by typing: QB/L MLIBN
 '
 ' To run this sample program from inside the VBDOS environment, start the
 ' editor by typing: VBDOS/L MLIBF
 '
 ' QuickBasic and Visual Basic are trademarks of Microsoft Corporation.
 '===========================================================================

 ' $INCLUDE: 'MLIB.BI'                           '
                                                 '
DECLARE SUB PrintMsg ()                          '
DECLARE SUB ChangeState ()                       '
                                                 '
SCREEN 0: CLS                                    '
                                                 '
CALL InitPointer(X%)                             'Must initialize the mouse.
                                                 '
CALL ShowPointer                                 '
                                                 '
CALL PrintMsg                                    '
                                                 '
                                                 '
BSize% = GetSizeM%                               'Get mouse state size, in
                                                 'bytes.
Buffer$ = SPACE$(BSize%)                         'Buffer to hold environment.
                                                 '
CALL SaveStateM(Buffer$, SaveErr%)               'Save the mouse environment.
                                                 '
IF NOT SaveErr% THEN                             '
   CALL HidePointer                              '
   CALL ChangeState                              '
   SCREEN 0                                      '
END IF                                           'NOTE! If Buffer$ is changed
                                                 'in any way now that it holds
                                                 'the mouse environment, you
                                                 'will effectively lock up
                                                 'your system.
                                                 '
CALL RestoreStateM(Buffer$, RestoreErr%)         'Restore mouse environment
                                                 'to its original state prior
CALL HidePointer                                 'to calling ChangeState.
                                                 
PRINT "Size of the mouse environment: "; BSize%; " bytes."

IF SaveErr% THEN
   PRINT "Error in saving the mouse environment."
ELSE
   PRINT "Mouse environment was successfully saved."
END IF

IF RestoreErr% THEN
   PRINT "Error in restoring the mouse environment."
ELSE
   PRINT "Mouse environment was successfully restored."
   PRINT "Pointer should be in the same position"
   PRINT "as it was before we changed screen modes."
END IF

PRINT
PRINT "Press any key to continue..."
CALL ShowPointer: a$ = INPUT$(1): CALL HidePointer

END

SUB ChangeState

SCREEN 9
PRINT "Initializing the mouse..."

CALL InitPointer(X%)
LOCATE 1, 1
PRINT "What we have done here is change to a graphics mode and initialized the"
PRINT "mouse (which will alter the mouse state). Now we could use this instance"
PRINT "of the mouse to do whatever we like. After we are done in here we will"
PRINT "restore the mouse state back to its original settings (SCREEN 0)."
PRINT
PRINT "Press a key to return..."

CALL ShowPointer

DO: LOOP UNTIL LEN(INKEY$)

CALL HidePointer

END SUB

SUB PrintMsg

PRINT "This example demonstrates how to save and restore the mouse environment."
PRINT
PRINT "First, move the pointer to a position you will remember. After a key has"
PRINT "been pressed, we will save the mouse driver's environment and call a"
PRINT "subroutine that will alter the state of the mouse."
PRINT
PRINT "Remember the pointer position."
PRINT "Press any key to continue...": a$ = INPUT$(1)

END SUB

