Program COM2_AT;
Uses Fossil;

Const

   Port = 1;    { COM2 }

Function UpStr(s: String): String;
Var
   i : Byte;
Begin
   For i := 1 to Ord(s[0]) do
      s[i] := UpCase(s[i]);
   UpStr := s;
End;

Function Parameters: String;
Var
   i : Integer;
   s : String;
Begin
   s := '';
   For i := 1 to ParamCount do
      s := s +UpStr(ParamStr(i)) +' ';
   If s > '' then s[Ord(s[0])] := #13
   else s := #13;
   Parameters := s;
   WriteLn('COM2 -> ', s);
End;

Procedure SetTimer(Var Timer: LongInt; Seconds: Real);
Var
   Ticks : LongInt Absolute $0040:$006C;
   Hr24  : Byte    Absolute $0040:$0070;
Begin
   Hr24  := 0;
   Timer := Ticks +Trunc(Seconds  /0.0549);
End;

Function TimeElapsed(Var Timer: LongInt): Boolean;
Var
   Ticks : LongInt Absolute $0040:$006C;
   Hr24  : Byte    Absolute $0040:$0070;
Begin
   If Hr24 > 0 then Begin
      Timer := Timer -786886;
      Hr24  := 0;
      End;
   If Ticks >= Timer then TimeElapsed := True
   else TimeElapsed := False;
End;

Procedure FossilSendStr(Port: Word; s: String);
Var
   i : Byte;
Begin
   For i := 1 to Ord(s[0]) do
      If Not FossilTransmit(Port, Ord(s[i])) then Begin
         WriteLn('Fossil not transmitting!');
         Halt(1);
         End;
End;

Procedure WatchInput(Port: Word; Seconds: Real);
Var
   Timer : LongInt;
Begin
   SetTimer(Timer, Seconds);
   Repeat
      While ((FossilStatus(Port) and DATA_READY) > 0) do Begin
         Write(Char(FossilReceiveWait(Port)));
         SetTimer(Timer, Seconds);
         End;
   Until TimeElapsed(Timer);
End;

Begin
   If FossilInit(Port) = 0 then Begin
      WriteLn('FOSSIL not loaded!');
      Halt(1);
      End;
   FossilSendStr(Port, Parameters);
   WatchInput(Port, 0.5);
   FossilDeInit(Port);
End.
