*  FOXPRO ZIP Code Lookup Demo Program

SET CONFIRM ON
SET COLOR TO W/B
SET TALK OFF
SET SCOREBOARD OFF
SET BELL OFF
CLEAR
SET STATUS OFF
USE zipcodes

* Check for existence of cdx file. If it is not present, create it
IF .NOT. FILE("ZIPCODES.CDX") .AND. .NOT. FILE("ZIPCODES.IDX")
	CLEAR
	answer = "Y"
	@ 1,1 SAY "You need an index file, requiring approximately 200K"
	@ 2,1 SAY "of space:"
	@ 2,10 SAY "   Continue?" GET answer
	READ
	IF answer = "Y"
		SET TALK ON
		CLEAR
		@ 12,36 SAY "Indexing"
		INDEX ON zipcode TO zipcodes COMPACT
		SET TALK OFF
		CLEAR
	ELSE
		CANCEL
	ENDIF
ELSE
	SET INDEX TO zipcodes
ENDIF

* Open address database
SELECT 2
USE demo
* Now enter data
APPEND BLANK
DO WHILE .T.
	SELE 2
	@  3, 29  SAY "Help Software Demo"
	@  6,  9  SAY "First Name:"
	@  6, 26  GET  demo->fname
	@  8,  9  SAY "Last Name:"
	@  8, 26  GET  demo->lname
	@ 10,  9  SAY "Address:"
	@ 10, 26  GET  demo->address
	@ 12,  9  SAY "City:"
	@ 12, 26  SAY  demo->city
	@ 14,  9  SAY "State:"
	@ 14, 26  SAY  demo->state
	@ 14, 32  SAY "Zip Code:"
	@ 14, 43  GET  demo->zipcode
	@ 16,  9  SAY "Phone:"
	@ 16,  16 SAY  demo->phone PICTURE "(   )    -    "
	@  2,  8  TO 18, 69
	@  4,  9  TO  4, 68
	@ 19,27     SAY "Press ESC to Abort Program"
	READ

	* Check for ESC key
	IF READKEY() = 12
		CLOSE ALL
		EXIT
	ENDIF

	huntzip=zipcode
	SELECT 1

	* If no Zipcode, then loop back through the record
	IF demo->zipcode = SPACE(5)
		LOOP
	ENDIF

	FIND &huntzip
	IF FOUND()
		SELECT 2
		*move data into database
		REPLACE zipcode WITH A->zipcode,;
			state WITH A->state,;
			city WITH A->city

		@ 12,  9  SAY "City:"
		@ 12, 26  SAY  demo->city
		@ 14,  9  SAY "State:"
		@ 14, 26  SAY  demo->state
		@ 16,  16 GET  demo->phone PICTURE "(999) 999-9999"
		READ
	ELSE
		@ 22,0
		WAIT "That zip code is not on file...any key to continue"
	ENDIF
	@ 23,0 CLEAR TO 23,79
	APPEND BLANK
ENDDO
CLOSE ALL


