/*****
 *
 *         Name: DoChisel    
 *  Description: Demo of the "shadow" box with "chiseled" borders
 *       Author: David L. Smith CIS 72351,225
 * Date created: 12-30-93
 *      Compile: Clipper DOCHISEL /n /m /w
 */
#include "box.ch"
#define FUZZY_STUFF     CHR( 178 )
#define RIGHT_CNR		CHR( 191 )
#define LEFT_CNR		CHR( 218 )
#define BOTTOM_CNR		CHR( 192 )
#define SIDE_LINE		CHR( 179 )
#define TOP_LINE		CHR( 196 )

FUNCTION Main()
Setcolor("W/B")
Setblink(.F.) 
// Paint a backdrop for the shadow
FuzzScreen(FUZZY_STUFF)

// Show the chisel box
// Gray box looks best
Chiselbox(8,20,16,60,"N/W")

// Add a title and exit instruction
@ 12,24 SAY PADC("YOUR BOX TITLE HERE",32," ") COLOR "N/W"
@ MAXROW(),0 SAY PADC("[ Press any key... ]",MAXCOL()+1,FUZZY_STUFF)

//Fini
INKEY(0)
RETURN NIL

/*****
 *
 *         Name: ChiselBox()    
 *  Description: A "shadow" box with "chiseled" borders
 *       Author: David L. Smith CIS 72351,225
 * Date created: 12-30-93
 *    Copyright: Free, gratis, Public Domain
 *
 *   Parameters: nTop 
 *             : nLeft
 *             : nBottom
 *             : nRight  - Windows coordinates
 *			   : cColor  - Box Color  "N/W" looks best to me
 *
 *        Needs: Parameter checking for sloppy coders
 */

FUNCTION ChiselBox(nTop,nLeft,nBottom,nRight,cColor)
LOCAL i,cUpClr,cDnClr

// Calculate Chisel Up and Down Colors
// You can also reverse the colors for a "sunken" border look
// Use N+ for Up Color and W+ for Down Color
cUpClr:="W+"+SUBSTR(cColor,AT("/",cColor))
cDnClr:="N+"+SUBSTR(cColor,AT("/",cColor))

//Draw the shadow 
Shadow(nTop+1,nLeft+2,nBottom+1,nRight+2)

//Draw the box
FOR i = 1 TO nBottom-nTop
    @ nTop+i, nLeft SAY REPLICATE(" ",nRight-nLeft+1) COLOR cColor
NEXT

//Draw the outer and inner boxes with single lines
@ nTop,nLeft,nBottom,nRight BOX B_SINGLE COLOR cDnClr
@ nTop+1,nLeft+2,nBottom-1,nRight-2 BOX B_SINGLE COLOR cUpClr


// Draw the outer box highlights
@ nTop,nLeft SAY LEFT_CNR COLOR cUpClr
@ nTop,nLeft+1 SAY REPLICATE(TOP_LINE,nRight-nLeft-1) COLOR cUpClr
@ nTop,nRight SAY RIGHT_CNR COLOR cUpClr
@ nBottom,nLeft SAY BOTTOM_CNR COLOR cUpClr

//Draw the inner box highlights
@ nTop+1,nLeft+2 SAY LEFT_CNR COLOR cDnclr
@ nTop+1,nLeft+3 SAY REPLICATE(TOP_LINE,nRight-nLeft-5) COLOR cDnclr
@ nTop+1,nRight-2 SAY RIGHT_CNR COLOR cDnclr
@ nBottom-1,nLeft+2 SAY BOTTOM_CNR COLOR cDnclr

//Finish the outer box vertical highlight
FOR i = 1 TO nBottom-nTop-1
    @ nTop+i, nLeft SAY SIDE_LINE COLOR cUpclr
NEXT

//Finish the inner box vertical highlight
FOR i = 1 TO nBottom-nTop-3
    @ nTop+i+1, nLeft+2 SAY SIDE_LINE COLOR cDnclr
NEXT
RETURN NIL

/*****
 *
 *         Name: FuzzScreen()    
 *  Description: A backdrop painter       
 *       Author: David L. Smith, CIS 72351,225
 *
 *   Parameters: nTop 
 *             : nLeft
 *             : nBottom
 *             : nRight  - Windows coordinates
 *
 */
//Paint a Screen Background
FUNCTION FuzzScreen(cFuzzChar)
  LOCAL nRow := 0
  DISPBEGIN()
    FOR nRow := 0 TO MAXROW()
      @ nRow, 00 SAY REPLICATE( cFuzzChar, MAXCOL()+1 )
    NEXT
  DISPEND()
RETURN( NIL )

/*****
 *
 *         Name: Shadow()    
 *  Description: A "shadow" with "see-thru"       
 *       Author: Luiz Quintela
 * Date created: 03-12-93
 *    Copyright: Computer Associates International, Inc.
 *
 *   Parameters: nTop 
 *             : nLeft
 *             : nBottom
 *             : nRight  - Windows coordinates
 *
 */

FUNCTION Shadow(nTop, nLeft, nBottom, nRight)
   LOCAL nShadowLen, cShadow

   cShadow := SaveScreen( nTop, nLeft, nBottom, nRight )
   nShadowLen := Len(cShadow)

   RestScreen( nTop, nLeft, nBottom, nRight,;
               Transform(cShadow, Replicate("X" + Chr(8), nShadowLen)))
   RETURN NIL


