/*
	     Structures document for QuickBBS version 2.80. This
	     information may be freely copied and used at no charge
	     by any party to write utilities and other software which
	     enhances the use of the QuickBBS software. Use of this
	     information in any other BBS program is strictly
	     prohibited. Copyright 1991,92,93  Pegasus Software
	     All Rights Reserved. Translation by Ed Grinnell		   */



enum            Boolean {False, True};
enum            UserActivityType {InMenu, InDoor, InCallback, ReadingMessages,
		WritingMessage,	ChattingWithSysop, ChattingWithUsers,
		AnsweringQuestionaire, ViewingTextFile, DownloadingFile,
		UploadingFile, ViewingFileList, DoingFileSearch, LoggingOn,
		LoggingOff, WaitingForCall};
enum		TypeMsgs {Standard, Netmail, FMail, EchoMail};
enum		KindMsgs {Both, Private, Public, ROnly};
enum		EventStat {Deleted, Enabled, Disabled};
enum		AskType {No, Maybe, Yes};
enum		ProtocolEnableType {Never, MNP_Only, Always};
enum            ProtocolTypes {Xmodem, Xmodem1K, Ymodem, YmodemG,
		Kermit, Zmodem, External};
enum            NodeTypes {ntZone, ntRegion, ntNet, ntNode, ntPrefix};
typedef         unsigned int 	Word;
typedef         unsigned char 	Byte;
typedef         int             Integer;
typedef         long            LongInt;
typedef         char            Char;


/* Uncomment the next line for GOLDBASE */
//#define GOLDBASE

#ifdef GOLDBASE
Integer  MaxMsgAreas  = 500;
Char 	 FileExt[] = ".DAT";
#else
Integer  MaxMsgAreas  = 200;
Char	 FileExt[] = ".BBS";
#endif
//Integer  MaxFileAreas = 200; :-)
Integer  MaxLanguages = 30;
Integer  MaxEvents    = 30;
Integer  MaxProtocols = 20;



struct  FlagType
	{
	Byte  		FlagType[4];
	};

typedef struct
	{
	Byte LengthOfString;
	char TheString[3];
	} StringDef3;

typedef struct
	{
	Byte LengthOfString;
	char TheString[5];
	} StringDef5;

typedef struct
	{
	Byte LengthOfString;
	char TheString[8];
	} StringDef8;

typedef struct
	{
	Byte LengthOfString;
	char TheString[10];
	} StringDef10;

typedef struct
	{
	Byte LengthOfString;
	char TheString[12];
	} StringDef12;

typedef struct
	{
	Byte LengthOfString;
	char TheString[15];
	} StringDef15;

typedef struct
	{
	Byte LengthOfString;
	char TheString[20];
	} StringDef20;

typedef struct
	{
	Byte LengthOfString;
	char TheString[25];
	} StringDef25;

typedef	struct
	{
	Byte LengthOfString;
	char TheString[35];
	} StringDef35;

typedef struct
	{
	Byte LengthOfString;
	char TheString[40];
	} StringDef40;

typedef struct
	{
	Byte LengthOfString;
	char TheString[48];
	} StringDef48;

typedef struct
	{
	Byte LengthOfString;
	char TheString[58];
	} StringDef58;

typedef	struct
	{
	Byte LengthOfString;
	char TheString[60];
	} StringDef60;

typedef struct
	{
	Byte LengthOfString;
	char TheString[66];
	} StringDef66;

typedef struct
	{
	Byte LengthOfString;
	char TheString[70];
	} StringDef70;

typedef struct
	{
	Byte LengthOfString;
	char TheString[72];
	} StringDef72;

typedef struct
	{
	Byte LengthOfString;
	char TheString[75];
	} StringDef75;

typedef struct
	{
	Byte LengthOfString;
	char TheString[80];
	} StringDef80;

typedef struct
	{
	Byte LengthOfString;
	char TheString[100];
	} StringDef100;

typedef struct
	{
	Byte LengthOfString;
	char TheString[255];
	} StringDef255;



/* USERIDX.BBS or USERIDX.DAT */

struct  UserIdxRecord
	{
	LongInt  	NameCRC;
	LongInt	        AliasCRC;
	};



/* USERS.BBS or USERS.DAT */

struct	UserRecord
	{
	StringDef35	Name;
	StringDef25	City;
	Byte    	ReservedZero;
	Byte    	Language;
	LongInt 	PwdCrc;
	Word    	PwdChangeDate;
	Word    	ExpireDate;
#ifdef GOLDBASE
	LongInt         HighMsgRead;
#else
	LongInt         UnusedSpace;

#endif
	Byte    	ExtraSpace[2];
	StringDef12	DataPhone;
	StringDef12	HomePhone;
	StringDef5	LastTime;
	StringDef8	LastDate;
	Byte		Attrib;
	FlagType 	Flags;
	Word		Credit;
	Word		Pending;
#ifdef GOLDBASE
	Word	 	TimesPosted;
	Word	 	ObsoleteField;
#else
	Word  		TimesPosted;
	Word 		HighMsgRead;
#endif
	Word		SecLvl;
	Word    	Times;
	Word		Ups;
	Word		Downs;
	Word		UpK;
	Word		DownK;
	Integer		TodayK;
	Integer		Elapsed;
	Integer		Len;
	Word    	CombinedPtr;
	Word    	AliasPtr;
	LongInt 	Birthday;
	};



/*	Attrib:

	Bit 0: Deleted
	Bit 1: Screen Clear Codes
	Bit 2: More Prompt
	Bit 3: ANSI
	Bit 4: No-Kill
	Bit 5: Ignore Download Hours
	Bit 6: ANSI Full Screen Editor
	Bit 7: Sex (0=male, 1=female)
*/



/* USERON.BBS */

struct  USERONrecord
	{
	StringDef35		Name;
	StringDef35		Alias;
	Byte			Line;
	Word			Baud;
	StringDef25		City;
	Boolean 		DoNotDisturb;
	Byte			Conference;
	UserActivityType	Activity;
	Byte    		Language;
	Byte    		Spare[8];
	};



/* ALIAS.BBS */

struct  AliasRecord
	{
	StringDef35	AliasRecord;
	};



/* MSGTOIDX.BBS or MSGTOIDX.DAT*/

struct  MsgToIdxRecord
	{
	StringDef35    	MsgToIdxRecord;
	};



/* MSGTXT.BBS or MSGTXT.DAT */

struct  MsgTxtRecord
	{
	StringDef255   	MsgTxtRecord;
	};



/*  Nodelist Records  */



/* NODEIDX.DAT */

struct	NodeIdxRecord
	{
	NodeTypes    	NodeType;
	Word	     	Number;
	Word	     	Cost;
	Byte         	RawFile;
	LongInt      	RawPos;
	};



struct  FileNameType
	{
	StringDef12    	FileNameType;
	};



/* NODEINC.DAT */

struct	NodeIncRecord
	{
	FileNameType 	FileName;
	LongInt      	DateStamp;
	};



/* Message Records */



/* COMBINED.BBS or COMBINED.DAT */

struct  CombSelectType
	{
#ifdef GOLDBASE
	Boolean 	CombSelectType[500];
#else
	Boolean		CombSelectType[200];
#endif
	};



/* MSGINFO.BBS or MSGINFO.DAT */

struct	InfoRecord
	{
#ifdef GOLDBASE
	LongInt		LowMsg;		   /* Lowest message in file.	*/
	LongInt		HighMsg;	   /* Highest message in file.	*/
	LongInt		TotalActive;	   /* Total active messages.	*/
	Word   		ActiveMsgs[500];
#else
	Integer		LowMsg;		   /* Lowest message in file.	*/
	Integer		HighMsg;	   /* Highest message in file.	*/
	Integer		TotalActive;	   /* Total active messages.	*/
	Integer		ActiveMsgs[200];
#endif
	};



/* MSGIDX.BBS or MSGIDX.DAT */

struct	IdxRecord
	{
#ifdef GOLDBASE
	LongInt		MsgNum;
	Word		Board;
#else
	Integer		MsgNum;
	Byte		Board;
#endif
	};



/* MSGHDR.BBS or MSGHDR.DAT */

struct	HdrRecord
	{
#ifdef GOLDBASE
	LongInt		MsgNum;
	LongInt		ReplyTo;
	LongInt		SeeAlsoNum;
#else
	Integer		MsgNum;
	Integer		ReplyTo;
	Integer		SeeAlsoNum;
#endif
	Integer		TRead;
#ifdef GOLDBASE
	LongInt 	StartRec;
#else
	Word		StartRec;
#endif
	Integer		NumRecs;
	Integer 	DestNet;
	Integer		DestNode;
	Integer		OrigNet;
	Integer		OrigNode;
	Byte		DestZone;
	Byte		OrigZone;
	Integer		Cost;
#ifdef GOLDBASE
	Word		MsgAttr;
	Word		NetAttr;
	Word		Board;
#else
	Byte		MsgAttr;
	Byte		NetAttr;
	Byte		Board;
#endif
	StringDef5	PostTime;
	StringDef8	PostDate;
	StringDef35	WhoTo;
	StringDef35	WhoFrom;
	StringDef72	Subj;
	};

/* Msg Attributes:

      Bit 0: Deleted
      Bit 1: Unmoved Outgoing Net Message
      Bit 2: Is a Net Mail Message
      Bit 3: Private
      Bit 4: Received
      Bit 5: Unmoved Outgoing Echo Message
      Bit 6: Local Bit
      Bit 7: Group Message

   Net Attributes:

      Bit 0: Kill Message after it's been sent
      Bit 1: Sent OK
      Bit 2: File(s) Attached
      Bit 3: Crash Priority
      Bit 4: Request Receipt
      Bit 5: Audit Request
      Bit 6: Is a Return Receipt
      Bit 7: Freq

*/



/*  Other Stuff */



/* SYSINFO.BBS */

struct	SysInfoRecord
	{
	LongInt		CallCount;
	StringDef35	LastCaller;
	StringDef35  	LastCallerAlias;
	Byte		ExtraSpace[92];
	};



/* TODAY.BBS */

struct  TodayRecord
	{
	StringDef35  	Name;
	StringDef35  	Alias;
	Byte    	Line;
	StringDef25	City;
	LongInt		Date;
	LongInt		Time;
	};



/* TIMELOG.BBS */

struct	TimeLogRecord
	{
	StringDef8	StartDate;
	Integer		BusyPerHour[24];
	Integer		BusyPerDay[7];
	};



/* LASTREAD.BBS or LASTREAD.DAT */

struct	LastReadType
	{
#ifdef GOLDBASE
	LongInt 	LastRead[500];
#else
	Word    	LastRead[200];
#endif
	};



/* Menu Structure */

/* TOP.MNU (Etc.) */

/*

Menus files will screw you up if you don't understand that they aren't
completely consistent. The first record is NOT a menu item. It's really
the prompt and highlight information. For the first record, the info is
actually:

struct	MenuRecord              First Record
	{
	Byte	 	Typ;	Highlight Foreground
	Word	 	Sec; 	Highlight Background
	FlagType 	Flags;	Not Used
	StringDef75 	Str;	Menu Prompt
	Char	 	Key;	Not Used
	StringDef80 	Data;	Not Used
	Byte	 	Fg;	Menu Prompt Foreground
	Byte	 	Bg;	Menu Prompt Background
	};

*/

/* Normal menu structure (2nd record to end of menu) */

struct	MenuRecord
	{
	Byte	 	Typ;
	Word	 	Sec;
	FlagType 	Flags;
	StringDef75 	Str;
	Char	 	Key;
	StringDef80 	Data;
	Byte	 	Fg;
	Byte	 	Bg;
	};



/* ENGLISH.LNG (Etc.) */

struct  PhraseRecord
	{
	StringDef80	TextString;
	StringDef10	KeyString;
	Byte		Color;
	};



/*  Configuration Information  */


struct  SecurityRecord
	{
	Word     	Security;
	FlagType 	Flags;
	};



/* FILECFG.DAT */

struct	FileAreaRecord
	{
	StringDef66    	AreaName;
	StringDef66    	FileName;
	StringDef66    	ListName;
	Boolean 	AllowUploads;
	Boolean 	IgnoreKlimit;
	Boolean 	IgnoreRatio;
	SecurityRecord 	DLSec;
	SecurityRecord 	SearchSec;
	SecurityRecord 	TemplateSec;
	Boolean 	CheckDupes;
	Byte    	Group;
	Byte    	Spare[10];
	};



/* MSGCFG.DAT */

struct	BoardRecord
	{
	StringDef40 	Name;
	TypeMsgs 	Typ;
	KindMsgs 	Kinds;
	Boolean	 	Combined;
	AskType	 	Aliases;
	Byte	 	Aka;
	StringDef58	OriginLine;
	Boolean  	AllowDelete;
	Word	 	KeepCnt;
	Word	 	KillRcvd;
	Word	 	KillOld;
	SecurityRecord 	ReadSec;
	SecurityRecord 	WriteSec;
	SecurityRecord 	TemplateSec;
	SecurityRecord 	SysopSec;
	Integer      	FileArea;
	Byte     	Group;
	Byte     	Spare[9];
	};



/* EVENTCFG.DAT */

struct	EventRecord
	{
	EventStat 	Status;
	LongInt	  	RunTime;
	Byte	  	ErrorLevel;
	Byte	  	Days;
	Boolean	  	Forced;
	LongInt      	LastTimeRun;
	Byte      	Spare[7];
	};



struct	FileKLimitRecord
	{
	Word		Baud;
	Integer		Limit;
	};


/* LIMITS.DAT */

struct	LimitRecord
	{
	Word	   		Security;
	Integer	   		DailyLimit;
	Integer	   		SessionLimit;
	Integer	   		DownLimit;
	Byte	    		PwdLife;
	Word	   		MinBaud;
	FileKLimitRecord	FileKLimits[8];
	Integer	   		FileKRatio;
	Integer	   		FileRatio;

	/* Questionaire to run when subscription expires */

	StringDef8   		ExpireQuest;

	/* Text File to display when subscription expires soon */

	StringDef8   		ExpireText;

	/* Number of days before expiration to start displaying ExpireText */

	Byte	   		DaysWarning;
	StringDef40   		Description;
	StringDef8   		TopMenu;

	/* For UserPack - delete users who haven't called in this many days */

	Byte			UserPurge;
	Byte	   		Spare[19];
	};



/* PROTOCOL.DAT */

struct	ProtocolRecord
	{
	StringDef25		Name;
	Char	     		Key;
	ProtocolTypes	     	ProtocolType;
	Char			LogCharacter;
	ProtocolEnableType	UploadsAllowed;
	ProtocolEnableType	DownloadsAllowed;
	StringDef66		LogFile;
	StringDef66   		ControlFile;
	StringDef100   		UploadCommand;
	StringDef100   		UploadControl;
	StringDef100   		DownloadCommand;
	StringDef100   		DownloadControl;
	Boolean	     		SupportsBatch;
	Byte	     		FileNamePos;
	StringDef20    		UploadKeyword;
	StringDef20    		DownloadKeyword;
	Byte	     		SuccessErrorLevel;
	Byte	     		FailureErrorLevel;
	Byte	     		Efficiency;
	Byte	     		Spare[100];
	};



/* LANGUAGE.DAT */

struct  LanguageRecord
	{
	StringDef20    	DisplayName;
	StringDef5	IEMSIName;
	Boolean 	Available;
	StringDef66	PhraseFilePath;
	StringDef66	MenuPath;
	StringDef66	TextPath;
	StringDef66	QuestPath;
	Byte		Spare[200];
	};



struct  ModemTranslationRecord
	{
	StringDef25	TranslateFrom;
	Word		TranslateTo;
	};



/* QUICKCFG.DAT */

struct	ConfigRecord
	{
	Word      		VersionID;
	Byte      		Node;

/*      Modem Parameters  */

	Integer			CommPort;
	Word			InitBaud;
	Word			ModemDelay;
	Integer			InitTimes;
	Integer			AnswerWait;
	StringDef70		ModemInitStr;
	StringDef70		ModemBusyStr;
	StringDef40		ModemInitResp;
	StringDef40		ModemBusyResp;
	ModemTranslationRecord 	ModemConnectResp[8];
	Word    		CBV_CallbackDelay;
	Word			CBV_WakeupDelay;
	StringDef8    		ARQ_String;
	Byte    		ModemSpareInfo[9];

/*	System Paths  */

	StringDef70		EditorCmdStr;
	StringDef66		Stat6Line1;
	StringDef66		Stat6Line2;
	StringDef66		NetPath;
	StringDef66		NodelistPath;
	StringDef66		MsgPath;
	StringDef66		SwapPath;
	StringDef66		OverlayPath;
	Byte    		OldPrompts[213];

/*	System Miscellaneous strings */

	StringDef58		OriginLine;
	StringDef3		QuoteStr;

/* 	User Restrictions */

	LongInt			LowBaudStart;
	LongInt			LowBaudEnd;
	LongInt			DownloadStart;
	LongInt			DownloadEnd;
	Integer			MaxPageTimes;
	Integer			PageBellLen;
	LongInt			PagingStart;
	LongInt			PagingEnd;
	Integer			MinBaud;
	Integer			GraphicsBaud;
	Integer			XferBaud;

/*	Matrix Information */

	Integer			MatrixZone[11];
	Integer			MatrixNet[11];
	Integer			MatrixNode[11];
	Integer			MatrixPoint[11];
	Integer			NetMailBoard;

/*	Default Information For New Users  */

	SecurityRecord 		DefaultSec;
	SecurityRecord 		MinimumSec;
	Integer			DefaultCredit;

/* 	Sysop Security And Sysop Information */

	SecurityRecord		SysopSecurity;
	StringDef35		SysopName;
	StringDef40		SystemName;
	LongInt			RegKey;

/*	Misc System Parameters  */

	Boolean			TextFileShells;
	Boolean			AltJswap;
	Boolean			Editorswap;
	Boolean			AutoLogonChar;
	Boolean			FastLogon;
	Boolean			UseLastRead;
	Boolean			MonoMode;
	Boolean			DirectWrite;
	Boolean			SnowCheck;
	Boolean			NetEchoExit;
	Boolean			OneWordNames;
	Boolean			CheckMail;
	Boolean			AskHomePhone;
	Boolean			AskDataPhone;
	Boolean			AskBirthday;
	Boolean			AskSex;
	Boolean			Use_Xmodem;
	Boolean			Use_Xmodem1k;
	Boolean			Use_Ymodem;
	ProtocolEnableType 	Use_YmodemG;
	Boolean			Use_Kermit;
	Boolean			Use_Zmodem;
	Boolean			Inp_Fields;
	Boolean			GraphicsAvail;
	Boolean			ForceUS_Phone;
	Integer     		InactiveTimeOut;
	Integer			LogonTime;
	Integer			DefFgColor;
	Integer			DefBgColor;
	Integer			PassWordTries;
	Byte			EntFldColor; /* Color for entry fields */
	Byte			BorderColor; /* Color for menu borders */
	Byte			WindowColor;
	Byte			StatusBarColor;
	Integer			UploadCredit;
	Byte			ScreenBlank;

/*	Callback Verifier */

	StringDef35		VerifierInit;
	StringDef15		DialString;
	StringDef15		DialSuffix;
	Boolean 		DupeCheck;
	Word			NewUserSec;
	Word			MemberSec;
	Char	 		MemberFlags[4][8];
	Word			LDcost;
	Boolean			LDenable;
	Boolean			ResumeLocal;
	Boolean			ResumeLD;
	LongInt			LDstart;
	LongInt			LDend;
	Byte			ForgotPwdBoard;
	Boolean			SendATA;
	StringDef60		Location;
	Boolean			ArchiveNetMail;
	Boolean			IEMSI;
	Boolean			IEMSI_New;
	Boolean			AutoAnsi;
	Boolean			MultiNode;
	Boolean			AutoLogChat;
	StringDef70		UserEditor;
	Byte			FileAreaCols;
	Byte			MsgAreaCols;
	Word			NewUserExpiry;
	Byte			PasswordLength;
	Boolean			ShowIdle;
	StringDef3		LocalRipExt;
	Byte			ExtraSpace[250];
	};



struct  GosubDataType
	{
	StringDef8    	GosubDataType[20];
	};



/* EXITINFO.BBS */

struct	ExitRecord
	{
	Integer		BaudRate;
	SysInfoRecord	SysInfo;
	TimeLogRecord	TimeLogInfo;
	UserRecord	UserInfo;
	EventRecord	EventInfo;
	Boolean		NetMailEntered;
	Boolean		EchoMailEntered;
	StringDef5	LoginTime;
	StringDef8	LoginDate;
	Integer		TmLimit;
	LongInt		LoginSec;
	LongInt		Credit;
	Integer		UserRecNum;
	Integer		ReadThru;
	Integer		PageTimes;
	Integer 	DownLimit;
	Boolean 	WantChat;
	Byte    	GosubLevel;
	GosubDataType 	GosubData;
	StringDef8    	Menu;
	Boolean		ScreenClear;
	Boolean		MorePrompts;
	Boolean		GraphicsMode;
	Boolean		ExternEdit;
	Integer		ScreenLength;
	Boolean		MNP_Connect;
	StringDef48	ChatReason;
	Boolean		ExternLogoff;
	Boolean		ANSI_Capable;
	Byte		CurrentLanguage;
	Boolean         RIP_Active;
	Byte		ExtraSpace[199];
	};
